/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.elements.base;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.FontHelper;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.info.elements.base.ElementFillType;
import sonar.logistics.core.tiles.displays.info.elements.base.HeightAlignment;
import sonar.logistics.core.tiles.displays.info.elements.base.IDisplayRenderable;
import sonar.logistics.core.tiles.displays.info.elements.base.IElementStorageHolder;
import sonar.logistics.core.tiles.displays.info.elements.base.WidthAlignment;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;

public interface IDisplayElement
extends IDisplayRenderable,
INBTSyncable {
    public String getRegisteredName();

    public String getRepresentiveString();

    public IElementStorageHolder setHolder(IElementStorageHolder var1);

    public IElementStorageHolder getHolder();

    public int getElementIdentity();

    default public DisplayGSI getGSI() {
        return this.getHolder().getContainer().getGSI();
    }

    @Override
    default public void render() {
        FontHelper.text((String)this.getRepresentiveString(), (int)0, (int)0, (int)this.getHolder().getContainer().getDefaultColour());
    }

    @Override
    default public void updateRender() {
    }

    public void onElementChanged();

    public double getPercentageFill();

    public double setPercentageFill(double var1);

    default public ElementFillType getFillType() {
        return ElementFillType.CUSTOM_SIZE;
    }

    public int[] getUnscaledWidthHeight();

    default public double[] getAlignmentTranslation(double[] maxScaling, double[] actualScaling) {
        return DisplayElementHelper.alignArray(maxScaling, actualScaling, this.getWidthAlignment(), this.getHeightAlignment());
    }

    public WidthAlignment getWidthAlignment();

    public WidthAlignment setWidthAlignment(WidthAlignment var1);

    public HeightAlignment getHeightAlignment();

    public HeightAlignment setHeightAlignment(HeightAlignment var1);

    @Override
    public double[] setMaxScaling(double[] var1);

    public double[] getMaxScaling();

    public double[] setActualScaling(double[] var1);

    public double[] getActualScaling();

    default public Object getClientEditGui(TileAbstractDisplay obj, Object origin, World world, EntityPlayer player) {
        return null;
    }

    default public void validate(DisplayGSI gsi) {
    }

    default public void invalidate(DisplayGSI gsi) {
    }
}

