/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.energy;

import java.util.List;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.energy.StoredEnergyStack;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.FontHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncNBTAbstract;
import sonar.logistics.api.asm.ASMInfo;
import sonar.logistics.api.core.tiles.displays.info.IComparableInfo;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.IJoinableInfo;
import sonar.logistics.api.core.tiles.displays.info.INameableInfo;
import sonar.logistics.api.core.tiles.displays.info.comparators.ComparableObject;
import sonar.logistics.base.utils.LogisticsHelper;
import sonar.logistics.core.tiles.displays.info.types.BaseInfo;
import sonar.logistics.core.tiles.displays.info.types.channels.MonitoredBlockCoords;
import sonar.logistics.network.sync.SyncMonitoredType;

@ASMInfo(id="energy", modid="practicallogistics2")
public class MonitoredEnergyStack
extends BaseInfo<MonitoredEnergyStack>
implements IJoinableInfo<MonitoredEnergyStack>,
INameableInfo<MonitoredEnergyStack>,
IComparableInfo<MonitoredEnergyStack> {
    public static final String id = "energy";
    private SyncNBTAbstract<StoredEnergyStack> energyStack = new SyncNBTAbstract(StoredEnergyStack.class, 0);
    private SyncMonitoredType<MonitoredBlockCoords> coords = new SyncMonitoredType(1);
    private final SyncNBTAbstract<StoredItemStack> dropStack = new SyncNBTAbstract(StoredItemStack.class, 3);

    public MonitoredEnergyStack() {
        this.syncList.addParts(new IDirtyPart[]{this.energyStack, this.coords, this.dropStack});
    }

    public MonitoredEnergyStack(StoredEnergyStack stack, MonitoredBlockCoords coords, StoredItemStack dropstack) {
        this.syncList.addParts(new IDirtyPart[]{this.energyStack, this.coords, this.dropStack});
        this.energyStack.setObject((INBTSyncable)stack);
        this.coords.setInfo(coords);
        this.dropStack.setObject((INBTSyncable)dropstack);
    }

    public MonitoredEnergyStack(StoredEnergyStack stack, MonitoredBlockCoords coords) {
        this.syncList.addParts(new IDirtyPart[]{this.energyStack, this.coords, this.dropStack});
        this.energyStack.setObject((INBTSyncable)stack);
        this.coords.setInfo(coords);
        this.dropStack.setObject((INBTSyncable)new StoredItemStack(LogisticsHelper.getCoordItem(coords.getCoords(), coords.getCoords().getWorld())));
    }

    @Override
    public boolean isIdenticalInfo(MonitoredEnergyStack info) {
        return ((StoredEnergyStack)this.energyStack.getObject()).equals((Object)info.energyStack.getObject()) && this.coords.getMonitoredInfo().isIdenticalInfo(info.coords.getMonitoredInfo());
    }

    @Override
    public boolean isMatchingInfo(MonitoredEnergyStack info) {
        return this.coords.getMonitoredInfo().isMatchingInfo(info.coords.getMonitoredInfo());
    }

    @Override
    public boolean isMatchingType(IInfo info) {
        return info instanceof MonitoredEnergyStack;
    }

    @Override
    public boolean canJoinInfo(MonitoredEnergyStack info) {
        return false;
    }

    @Override
    public IJoinableInfo joinInfo(MonitoredEnergyStack info) {
        ((StoredEnergyStack)this.energyStack.getObject()).add((StoredEnergyStack)info.energyStack.getObject());
        this.energyStack.markChanged();
        return this;
    }

    @Override
    public boolean isValid() {
        return this.energyStack.getObject() != null && ((StoredEnergyStack)this.energyStack.getObject()).energyType != null && this.coords.getMonitoredInfo() != null;
    }

    @Override
    public String getID() {
        return id;
    }

    @Override
    public MonitoredEnergyStack copy() {
        return new MonitoredEnergyStack(((StoredEnergyStack)this.energyStack.getObject()).copy(), this.coords.getMonitoredInfo().copy(), ((StoredItemStack)this.dropStack.getObject()).copy());
    }

    @Override
    public String getClientIdentifier() {
        return this.energyStack.getObject() != null && ((StoredEnergyStack)this.energyStack.getObject()).energyType != null ? ((StoredEnergyStack)this.energyStack.getObject()).energyType.getName() : "ENERGYSTACK";
    }

    @Override
    public String getClientObject() {
        return this.energyStack.getObject() != null ? "" + FontHelper.formatStorage((EnergyType)((StoredEnergyStack)this.energyStack.obj).energyType, (long)((StoredEnergyStack)this.energyStack.getObject()).stored) + " / " + FontHelper.formatStorage((EnergyType)((StoredEnergyStack)this.energyStack.obj).energyType, (long)((StoredEnergyStack)this.energyStack.getObject()).capacity) : "ERROR";
    }

    @Override
    public String getClientType() {
        return id;
    }

    public MonitoredBlockCoords getMonitoredCoords() {
        return this.coords.getMonitoredInfo();
    }

    public StoredEnergyStack getEnergyStack() {
        return (StoredEnergyStack)this.energyStack.getObject();
    }

    public StoredItemStack getDropStack() {
        return (StoredItemStack)this.dropStack.getObject();
    }

    @Override
    public List<ComparableObject> getComparableObjects(List<ComparableObject> objects) {
        BlockCoords blockCoords = this.getMonitoredCoords().getCoords();
        StoredEnergyStack stack = this.getEnergyStack();
        objects.add(new ComparableObject(this, "x", blockCoords.getX()));
        objects.add(new ComparableObject(this, "y", blockCoords.getY()));
        objects.add(new ComparableObject(this, "z", blockCoords.getZ()));
        objects.add(new ComparableObject(this, "input", stack.input));
        objects.add(new ComparableObject(this, "output", stack.output));
        objects.add(new ComparableObject(this, "stored", stack.stored));
        objects.add(new ComparableObject(this, "capacity", stack.capacity));
        objects.add(new ComparableObject(this, "types", stack.energyType.toString()));
        return objects;
    }
}

