/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.general;

import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.lists.EnumListChange;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValue;

public class InfoMonitoredValue<I extends IInfo<I>>
implements IMonitoredValue<I> {
    public I cachedInfo;
    public EnumListChange currentState;

    public InfoMonitoredValue(I fullInfo) {
        this.reset(fullInfo);
        this.currentState = EnumListChange.NEW_VALUE;
    }

    @Override
    public void reset(I fullInfo) {
        this.cachedInfo = fullInfo.copy();
    }

    @Override
    public EnumListChange getChange() {
        return this.currentState;
    }

    @Override
    public void resetChange() {
        this.currentState = EnumListChange.OLD_VALUE;
    }

    @Override
    public void combine(I combine) {
        EnumListChange newState;
        if (!this.cachedInfo.isIdenticalInfo(combine)) {
            this.cachedInfo.identifyChanges(combine);
            this.reset(combine);
            newState = EnumListChange.INCREASED;
        } else {
            newState = EnumListChange.EQUAL;
        }
        if (this.currentState != EnumListChange.NEW_VALUE) {
            this.currentState = newState;
        }
    }

    @Override
    public boolean isValid(Object info) {
        return info instanceof IInfo;
    }

    @Override
    public boolean canCombine(I combine) {
        return this.cachedInfo.isMatchingType((IInfo)combine) && this.cachedInfo.isMatchingInfo(combine);
    }

    @Override
    public I getSaveableInfo() {
        return this.cachedInfo;
    }

    @Override
    public void setNew() {
        this.currentState = EnumListChange.NEW_VALUE;
    }

    @Override
    public boolean shouldDelete(EnumListChange change) {
        return change.shouldDelete();
    }
}

