/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.progress;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.asm.ASMInfo;
import sonar.logistics.api.core.tiles.displays.info.IComparableInfo;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.INameableInfo;
import sonar.logistics.api.core.tiles.displays.info.ISuffixable;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.comparators.ComparableObject;
import sonar.logistics.api.core.tiles.displays.info.register.LogicPath;
import sonar.logistics.core.tiles.displays.info.elements.base.IDisplayElement;
import sonar.logistics.core.tiles.displays.info.elements.base.IElementStorageHolder;
import sonar.logistics.core.tiles.displays.info.types.general.LogicInfo;
import sonar.logistics.core.tiles.displays.info.types.progress.ElementProgressBar;
import sonar.logistics.core.tiles.readers.info.handling.InfoHelper;

@ASMInfo(id="progress", modid="practicallogistics2")
public class InfoProgressBar
implements IInfo<InfoProgressBar>,
INBTSyncable,
INameableInfo<InfoProgressBar>,
ISuffixable,
IComparableInfo<InfoProgressBar> {
    public static final String id = "progress";
    public LogicInfo first;
    public LogicInfo second;
    public int compare;
    public double firstNum;
    public double secondNum;

    public InfoProgressBar() {
    }

    public InfoProgressBar(IInfo first, IInfo second) {
        this.first = (LogicInfo)first;
        this.second = (LogicInfo)second;
        this.checkInfo();
    }

    public static boolean isStorableInfo(IInfo info) {
        return info instanceof LogicInfo;
    }

    public void checkInfo() {
        if (this.isValid() && this.first.isValid() && this.second.isValid() && this.first.getInfoType().isNumber() && this.second.getInfoType().isNumber()) {
            this.firstNum = Double.valueOf(this.first.getInfo().toString());
            this.secondNum = Double.valueOf(this.second.getInfo().toString());
            this.compare = Double.compare(this.firstNum, this.secondNum);
        }
    }

    @Override
    public String getClientIdentifier() {
        if (!this.isValid()) {
            return "ERROR";
        }
        return (this.compare == 1 ? this.second : this.first).getClientIdentifier();
    }

    @Override
    public String getRawData() {
        if (!this.isValid()) {
            return "ERROR";
        }
        return (this.compare == 1 ? this.second : this.first).getRawData();
    }

    @Override
    public String getClientObject() {
        if (!this.isValid()) {
            return "ERROR";
        }
        return (this.compare == 1 ? this.second : this.first).getClientObject();
    }

    @Override
    public String getClientType() {
        return "Progress";
    }

    @Override
    public String getSuffix() {
        if (!this.isValid()) {
            return "ERROR";
        }
        return (this.compare == 1 ? this.second : this.first).getSuffix();
    }

    @Override
    public String getPrefix() {
        if (!this.isValid()) {
            return "ERROR";
        }
        return (this.compare == 1 ? this.second : this.first).getPrefix();
    }

    @Override
    public void createDefaultElements(List<IDisplayElement> toAdd, IElementStorageHolder h, InfoUUID uuid) {
        IInfo.doCreateDefaultElements(this, toAdd, h, uuid);
        toAdd.add(new ElementProgressBar(uuid));
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.first = (LogicInfo)InfoHelper.loadInfo(InfoHelper.getName("logic"), nbt.func_74775_l("first"));
        this.second = (LogicInfo)InfoHelper.loadInfo(InfoHelper.getName("logic"), nbt.func_74775_l("second"));
        this.checkInfo();
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        nbt.func_74782_a("first", (NBTBase)InfoHelper.writeInfoToNBT(new NBTTagCompound(), this.first, type));
        nbt.func_74782_a("second", (NBTBase)InfoHelper.writeInfoToNBT(new NBTTagCompound(), this.second, type));
        return nbt;
    }

    @Override
    public boolean isIdenticalInfo(InfoProgressBar info) {
        return info.first.isIdenticalInfo(this.first) && info.second.isIdenticalInfo(this.second);
    }

    @Override
    public boolean isMatchingInfo(InfoProgressBar info) {
        return info.first.isMatchingInfo(this.first) && info.second.isMatchingInfo(this.second);
    }

    @Override
    public boolean isMatchingType(IInfo info) {
        return info instanceof InfoProgressBar;
    }

    @Override
    public boolean isHeader() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.first != null && this.second != null && this.first.isValid() && this.second.isValid();
    }

    @Override
    public String getID() {
        return id;
    }

    @Override
    public InfoProgressBar copy() {
        return new InfoProgressBar(this.first.copy(), this.second.copy());
    }

    @Override
    public void identifyChanges(InfoProgressBar newInfo) {
        this.first.identifyChanges(newInfo.first);
        this.second.identifyChanges(newInfo.second);
    }

    @Override
    public LogicPath getPath() {
        return null;
    }

    @Override
    public InfoProgressBar setPath(LogicPath path) {
        return this;
    }

    @Override
    public void onInfoStored() {
        this.first.onInfoStored();
        this.second.onInfoStored();
    }

    @Override
    public List<ComparableObject> getComparableObjects(List<ComparableObject> objects) {
        List<ComparableObject> firstObj;
        if (this.first != null) {
            firstObj = this.first.getComparableObjects(new ArrayList<ComparableObject>());
            firstObj.forEach(obj -> objects.add(new ComparableObject(this, "First: " + obj.string, obj.object)));
        }
        if (this.second != null) {
            firstObj = this.second.getComparableObjects(new ArrayList<ComparableObject>());
            firstObj.forEach(obj -> objects.add(new ComparableObject(this, "Second: " + obj.string, obj.object)));
        }
        return objects;
    }
}

