/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.text.utils;

import com.google.common.collect.Lists;
import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import sonar.logistics.core.tiles.displays.info.types.text.StyledTextElement;
import sonar.logistics.core.tiles.displays.info.types.text.styling.IStyledString;
import sonar.logistics.core.tiles.displays.info.types.text.styling.StyledStringLine;

public class StyledStringRenderer
extends FontRenderer {
    public static final StyledStringRenderer instance = new StyledStringRenderer();
    public static final String TEXT_FORMATTING_IDENTIFIERS = "0123456789abcdefklmnor";
    public static final String ALLOWED_CHARS = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000";

    public static StyledStringRenderer instance() {
        return instance;
    }

    public StyledStringRenderer() {
        super(Minecraft.func_71410_x().field_71474_y, new ResourceLocation("textures/font/ascii.png"), Minecraft.func_71410_x().field_71446_o, false);
        if (Minecraft.func_71410_x().field_71474_y.field_74363_ab != null) {
            this.func_78264_a(Minecraft.func_71410_x().func_152349_b());
            this.func_78275_b(Minecraft.func_71410_x().func_135016_M().func_135044_b());
        }
    }

    public float getPosX() {
        return this.field_78295_j;
    }

    public float getPosY() {
        return this.field_78296_k;
    }

    public void incrementRenderPositions(double x, double y) {
        this.field_78295_j += (float)x;
        this.field_78296_k += (float)y;
    }

    public void setRenderPositions(double x, double y) {
        this.field_78295_j = (float)x;
        this.field_78296_k = (float)y;
    }

    public void renderWrappedText(StyledStringRenderHandler handler, double width, double height, int startLine, int endLine) {
        Map<Integer, List<SimpleIndex>> page = handler.lines;
        if (page != null && !page.isEmpty()) {
            this.setRenderPositions(0.0, 0.0);
            for (Map.Entry<Integer, List<SimpleIndex>> line : page.entrySet()) {
                if (line.getKey() < startLine || line.getKey() >= endLine) continue;
                for (SimpleIndex index : line.getValue()) {
                    this.renderTextWithStyledString(index.string, index.string.getUnformattedString().substring(index.start, index.end));
                }
                this.setRenderPositions(0.0, (double)this.getPosY() + handler.totalLineSize());
            }
        }
    }

    public void startStyledStringRender(IStyledString ss) {
        if (this.func_78260_a()) {
            // empty if block
        }
        int red = ss.getStyle().rgb >> 16 & 0xFF;
        int green = ss.getStyle().rgb >> 8 & 0xFF;
        int blue = ss.getStyle().rgb & 0xFF;
        float alpha = 1.0f;
        GlStateManager.func_179141_d();
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)((float)red / 256.0f), (float)((float)green / 256.0f), (float)((float)blue / 256.0f), (float)alpha);
    }

    public void renderTextWithStyledString(IStyledString ss, String text) {
        this.startStyledStringRender(ss);
        for (int i = 0; i < text.length(); ++i) {
            char current_char = text.charAt(i);
            this.renderChar(ss, current_char);
        }
    }

    public void renderChar(IStyledString ss, char current_char) {
        boolean shadow = false;
        if (current_char != '\u00a7') {
            int char_index = ALLOWED_CHARS.indexOf(current_char);
            if (ss.getStyle().obfuscated && char_index != -1) {
                char obfuscated_char;
                int target_width = this.getCharWidthFromStyledString(ss, current_char);
                while (target_width != this.getCharWidthFromStyledString(ss, obfuscated_char = ALLOWED_CHARS.charAt(char_index = this.field_78289_c.nextInt(ALLOWED_CHARS.length())))) {
                }
                current_char = obfuscated_char;
            }
            float f1 = char_index == -1 || this.func_82883_a() ? 0.5f : 1.0f;
            boolean flag = false;
            float char_width = this.renderCharFromStyledString(ss, current_char);
            if (ss.getStyle().bold) {
                this.field_78295_j += f1;
                this.renderCharFromStyledString(ss, current_char);
                this.field_78295_j -= f1;
                char_width += 1.0f;
            }
            this.doDrawWithStyledString(ss, char_width);
        }
    }

    public int getRenderStringWidthWithStyledString(IStyledString ss, String string) {
        int width = 0;
        for (int i = 0; i < string.length(); ++i) {
            char current_char = string.charAt(i);
            width += this.getCharRenderWidthFromStyledString(ss, current_char);
        }
        return width;
    }

    public float renderCharFromStyledString(IStyledString string, char ch) {
        if (ch == '\u00a0') {
            return 4.0f;
        }
        if (ch == ' ') {
            return 4.0f;
        }
        int i = ALLOWED_CHARS.indexOf(ch);
        return i != -1 && !this.func_82883_a() ? this.func_78266_a(i, string.getStyle().italic) : this.func_78277_a(ch, string.getStyle().italic);
    }

    public int getCharWidthFromStyledString(IStyledString string, char character) {
        if (character == '\u00a0') {
            return 4;
        }
        if (character == '\u00a7') {
            return -1;
        }
        if (character == ' ') {
            return 4;
        }
        int i = ALLOWED_CHARS.indexOf(character);
        if (character > '\u0000' && i != -1 && !this.func_82883_a()) {
            return this.field_78286_d[i];
        }
        if (this.field_78287_e[character] != 0) {
            int j = this.field_78287_e[character] & 0xFF;
            int k = j >>> 4;
            int l = j & 0xF;
            return (++l - k) / 2 + 1;
        }
        return 0;
    }

    public int getCharRenderWidthFromStyledString(IStyledString string, char character) {
        int normal_width = this.getCharWidthFromStyledString(string, character);
        if (string.getStyle().bold) {
            ++normal_width;
        }
        return normal_width;
    }

    public void doDrawWithStyledString(IStyledString string, float f) {
        if (string.getStyle().strikethrough) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.func_179090_x();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            bufferbuilder.func_181662_b((double)this.field_78295_j, (double)(this.field_78296_k + (float)(this.field_78288_b / 2)), 0.0).func_181675_d();
            bufferbuilder.func_181662_b((double)(this.field_78295_j + f), (double)(this.field_78296_k + (float)(this.field_78288_b / 2)), 0.0).func_181675_d();
            bufferbuilder.func_181662_b((double)(this.field_78295_j + f), (double)(this.field_78296_k + (float)(this.field_78288_b / 2) - 1.0f), 0.0).func_181675_d();
            bufferbuilder.func_181662_b((double)this.field_78295_j, (double)(this.field_78296_k + (float)(this.field_78288_b / 2) - 1.0f), 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
        }
        if (string.getStyle().underlined) {
            Tessellator tessellator1 = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder1 = tessellator1.func_178180_c();
            GlStateManager.func_179090_x();
            bufferbuilder1.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            int l = string.getStyle().underlined ? -1 : 0;
            bufferbuilder1.func_181662_b((double)(this.field_78295_j + (float)l), (double)(this.field_78296_k + (float)this.field_78288_b), 0.0).func_181675_d();
            bufferbuilder1.func_181662_b((double)(this.field_78295_j + f), (double)(this.field_78296_k + (float)this.field_78288_b), 0.0).func_181675_d();
            bufferbuilder1.func_181662_b((double)(this.field_78295_j + f), (double)(this.field_78296_k + (float)this.field_78288_b - 1.0f), 0.0).func_181675_d();
            bufferbuilder1.func_181662_b((double)(this.field_78295_j + (float)l), (double)(this.field_78296_k + (float)this.field_78288_b - 1.0f), 0.0).func_181675_d();
            tessellator1.func_78381_a();
            GlStateManager.func_179098_w();
        }
        this.field_78295_j += (float)((int)f);
    }

    public String bidiReorderWithStyledString(IStyledString string, String text) {
        try {
            Bidi bidi = new Bidi(new ArabicShaping(8).shape(text), 127);
            bidi.setReorderingMode(0);
            return bidi.writeReordered(2);
        }
        catch (ArabicShapingException var3) {
            return text;
        }
    }

    public static class StyledStringRenderHandler {
        public final StyledTextElement text;
        public int line_spacing = 0;
        public int font_height;
        public Map<Integer, List<SimpleIndex>> lines;
        public int buildingLine;
        public double buildingX;
        public double buildingY;
        public double build_width;
        public double build_height;
        public List<SimpleIndex> lineBuild;
        public int last_space;
        public int linesPerPage;
        public IStyledString last_space_string;
        public StyledStringLine currentLine;
        public IStyledString currentString;

        public StyledStringRenderHandler(StyledTextElement text) {
            this.font_height = StyledStringRenderer.instance().field_78288_b;
            this.lines = new HashMap<Integer, List<SimpleIndex>>();
            this.buildingLine = 0;
            this.buildingX = 0.0;
            this.buildingY = 0.0;
            this.lineBuild = new ArrayList<SimpleIndex>();
            this.last_space = -1;
            this.last_space_string = null;
            this.text = text;
        }

        public void incrementX(double increment) {
            this.buildingX += increment;
            if (this.buildingX >= this.build_width) {
                this.incrementY(this.totalLineSize(), false);
            }
        }

        public void incrementY(double increment, boolean finishedLine) {
            List<Object> nextLine = new ArrayList();
            if (!finishedLine) {
                nextLine = this.trimToLastSpace(this.lineBuild);
            }
            this.saveSimpleIndexs();
            this.buildingX = 0.0;
            this.buildingY += increment;
            ++this.buildingLine;
            if (this.totalLineSize() > this.remainingY()) {
                this.buildingX = 0.0;
                this.buildingY = 0.0;
            }
            int total_width = 0;
            for (SimpleIndex simpleIndex : nextLine) {
                total_width += StyledStringRenderer.instance().getRenderStringWidthWithStyledString(simpleIndex.string, simpleIndex.string.getUnformattedString().substring(simpleIndex.start, simpleIndex.end));
            }
            this.incrementX(total_width);
            this.lineBuild.addAll(nextLine);
        }

        public double remainingY() {
            return this.build_height - this.buildingY;
        }

        public double remainingX() {
            return this.build_width - this.buildingX;
        }

        public double totalLineSize() {
            return this.font_height + this.line_spacing;
        }

        public void saveSimpleIndexs() {
            this.lines.put(this.buildingLine, Lists.newArrayList(this.lineBuild));
            this.lineBuild.clear();
        }

        public void addSimpleIndex(SimpleIndex index) {
            if (this.lineBuild.isEmpty()) {
                String s = index.string.getUnformattedString().substring(index.start, index.end);
                if (s.isEmpty()) {
                    return;
                }
                if (s.charAt(0) == ' ') {
                    ++index.start;
                }
            }
            this.lineBuild.add(index);
        }

        public List<SimpleIndex> trimToLastSpace(List<SimpleIndex> indexes) {
            if (this.last_space == -1 || this.last_space_string == null) {
                return new ArrayList<SimpleIndex>();
            }
            ArrayList<SimpleIndex> nextLine = new ArrayList<SimpleIndex>();
            boolean found = false;
            for (SimpleIndex si : indexes) {
                if (found) {
                    nextLine.add(si);
                    continue;
                }
                if (si.string != this.last_space_string || si.start > this.last_space || this.last_space + 1 >= si.end) continue;
                found = true;
                nextLine.add(new SimpleIndex(si.string, this.last_space + 1, si.end, si.lineIndex));
                si.end = this.last_space;
            }
            indexes.removeAll(nextLine);
            return nextLine;
        }

        public void wrapLines(double width, double height) {
            this.lines.clear();
            this.build_width = width;
            this.build_height = height;
            this.buildingX = 0.0;
            this.buildingY = 0.0;
            this.buildingLine = 0;
            this.linesPerPage = (int)Math.floor(height / this.totalLineSize());
            if (this.linesPerPage == 0) {
                return;
            }
            Iterator<StyledStringLine> iterator = this.text.iterator();
            while (iterator.hasNext()) {
                StyledStringLine line;
                this.currentLine = line = iterator.next();
                int lineIndex = 0;
                Iterator<IStyledString> iterator2 = line.iterator();
                while (iterator2.hasNext()) {
                    IStyledString ss;
                    this.currentString = ss = iterator2.next();
                    String string = ss.getUnformattedString();
                    int startIndex = 0;
                    int endIndex = 0;
                    double indexed_width = 0.0;
                    for (int i = 0; i < string.length(); ++i) {
                        char current_char = string.charAt(i);
                        int char_width = StyledStringRenderer.instance().getCharRenderWidthFromStyledString(ss, current_char);
                        if (current_char == ' ' || current_char == '\u00a0') {
                            this.last_space = i;
                            this.last_space_string = ss;
                        }
                        if ((double)char_width > width) {
                            return;
                        }
                        if ((double)char_width <= this.remainingX() - indexed_width) {
                            indexed_width += (double)char_width;
                            ++endIndex;
                            continue;
                        }
                        if (startIndex != endIndex) {
                            this.addSimpleIndex(new SimpleIndex(ss, startIndex, endIndex, lineIndex));
                            this.incrementX(indexed_width);
                            indexed_width = 0.0;
                        }
                        startIndex = i;
                        endIndex = i + 1;
                        this.incrementY(this.totalLineSize(), false);
                        this.incrementX(char_width);
                    }
                    if (startIndex != endIndex) {
                        this.addSimpleIndex(new SimpleIndex(ss, startIndex, endIndex, lineIndex));
                        this.incrementX(indexed_width);
                    }
                    lineIndex += ss.getStringLength();
                }
                this.incrementY(this.totalLineSize(), true);
            }
            this.saveSimpleIndexs();
        }
    }

    public static class SimpleIndex {
        public IStyledString string;
        public int start;
        public int end;
        public int lineIndex;

        public SimpleIndex(IStyledString string, int start, int end, int lineIndex) {
            this.string = string;
            this.start = start;
            this.end = end;
            this.lineIndex = lineIndex;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SimpleIndex) {
                return ((SimpleIndex)obj).string == this.string && ((SimpleIndex)obj).start == this.start && ((SimpleIndex)obj).end == this.end;
            }
            return false;
        }
    }
}

