/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.readers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import sonar.core.SonarCore;
import sonar.core.api.energy.StoredEnergyStack;
import sonar.core.api.fluids.StoredFluidStack;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.utils.SortingDirection;
import sonar.logistics.PL2ASMLoader;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.IProvidableInfo;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValue;
import sonar.logistics.api.core.tiles.readers.ILogicListSorter;
import sonar.logistics.core.tiles.displays.info.types.energy.MonitoredEnergyStack;
import sonar.logistics.core.tiles.displays.info.types.fluids.InfoNetworkFluid;
import sonar.logistics.core.tiles.displays.info.types.general.LogicInfo;
import sonar.logistics.core.tiles.displays.info.types.items.MonitoredItemStack;
import sonar.logistics.core.tiles.readers.energy.EnergyReader;
import sonar.logistics.core.tiles.readers.fluids.FluidReader;
import sonar.logistics.core.tiles.readers.items.InventoryReader;

public class SortingHelper {
    public static AbstractChangeableList<IProvidableInfo> sortInfo(AbstractChangeableList<IProvidableInfo> updateInfo) {
        updateInfo.getList().sort(Comparator.comparingInt(str -> ((IProvidableInfo)str.getSaveableInfo()).getRegistryType().sortOrder));
        ArrayList<IProvidableInfo> info = new ArrayList<IProvidableInfo>();
        IInfo lastInfo = null;
        for (IMonitoredValue<IProvidableInfo> value : updateInfo.getList()) {
            IProvidableInfo blockInfo = value.getSaveableInfo();
            if (blockInfo == null || blockInfo.isHeader()) continue;
            if (lastInfo == null || !lastInfo.isHeader() && !lastInfo.getRegistryType().equals((Object)blockInfo.getRegistryType())) {
                info.add(LogicInfo.buildCategoryInfo(blockInfo.getRegistryType()));
            }
            info.add(value.getSaveableInfo());
            lastInfo = blockInfo;
        }
        updateInfo.getList().clear();
        info.forEach(updateInfo::add);
        return updateInfo;
    }

    public static AbstractChangeableList<MonitoredItemStack> sortItems(AbstractChangeableList<MonitoredItemStack> updateInfo, SortingDirection direction, InventoryReader.SortingType type) {
        updateInfo.getList().sort((str1, str2) -> {
            StoredItemStack item1 = ((MonitoredItemStack)str1.getSaveableInfo()).getStoredStack();
            StoredItemStack item2 = ((MonitoredItemStack)str2.getSaveableInfo()).getStoredStack();
            return SonarHelper.compareStringsWithDirection((String)item1.getItemStack().func_82833_r(), (String)item2.getItemStack().func_82833_r(), (SortingDirection)direction);
        });
        switch (type) {
            case STORED: {
                updateInfo.getList().sort((str1, str2) -> {
                    StoredItemStack item1 = ((MonitoredItemStack)str1.getSaveableInfo()).getStoredStack();
                    StoredItemStack item2 = ((MonitoredItemStack)str2.getSaveableInfo()).getStoredStack();
                    return SonarHelper.compareWithDirection((long)item1.stored, (long)item2.stored, (SortingDirection)direction);
                });
                break;
            }
            case MODID: {
                updateInfo.getList().sort((str1, str2) -> {
                    StoredItemStack item1 = ((MonitoredItemStack)str1.getSaveableInfo()).getStoredStack();
                    StoredItemStack item2 = ((MonitoredItemStack)str2.getSaveableInfo()).getStoredStack();
                    String modid1 = item1.getItemStack().func_77973_b().getRegistryName().func_110624_b();
                    String modid2 = item2.getItemStack().func_77973_b().getRegistryName().func_110624_b();
                    return SonarHelper.compareStringsWithDirection((String)modid1, (String)modid2, (SortingDirection)direction);
                });
            }
        }
        return updateInfo;
    }

    public static AbstractChangeableList<InfoNetworkFluid> sortFluids(AbstractChangeableList<InfoNetworkFluid> updateInfo, SortingDirection dir, FluidReader.SortingType type) {
        updateInfo.getList().sort((str1, str2) -> {
            StoredFluidStack flu1 = ((InfoNetworkFluid)str1.getSaveableInfo()).getStoredStack();
            StoredFluidStack flu2 = ((InfoNetworkFluid)str2.getSaveableInfo()).getStoredStack();
            int res = String.CASE_INSENSITIVE_ORDER.compare(flu1.getFullStack().getLocalizedName(), flu2.getFullStack().getLocalizedName());
            if (res == 0) {
                res = flu1.getFullStack().getLocalizedName().compareTo(flu2.getFullStack().getLocalizedName());
            }
            return dir == SortingDirection.DOWN ? res : -res;
        });
        updateInfo.getList().sort((str1, str2) -> {
            StoredFluidStack flu1 = ((InfoNetworkFluid)str1.getSaveableInfo()).getStoredStack();
            StoredFluidStack flu2 = ((InfoNetworkFluid)str2.getSaveableInfo()).getStoredStack();
            switch (type) {
                case MODID: {
                    String modid1 = FluidRegistry.getModId((FluidStack)flu1.getFullStack());
                    String modid2 = FluidRegistry.getModId((FluidStack)flu2.getFullStack());
                    return SonarHelper.compareStringsWithDirection((String)(modid1 == null ? "minecraft" : modid1), (String)(modid2 == null ? "minecraft" : modid2), (SortingDirection)dir);
                }
                case NAME: {
                    break;
                }
                case STORED: {
                    return SonarHelper.compareWithDirection((long)flu1.stored, (long)flu2.stored, (SortingDirection)dir);
                }
                case TEMPERATURE: {
                    return SonarHelper.compareWithDirection((long)flu1.getFullStack().getFluid().getTemperature(), (long)flu2.getFullStack().getFluid().getTemperature(), (SortingDirection)dir);
                }
            }
            return 0;
        });
        return updateInfo;
    }

    public static AbstractChangeableList<MonitoredEnergyStack> sortEnergy(AbstractChangeableList<MonitoredEnergyStack> updateInfo, SortingDirection dir, EnergyReader.SortingType type) {
        updateInfo.getList().sort((str1, str2) -> {
            StoredEnergyStack item1 = ((MonitoredEnergyStack)str1.getSaveableInfo()).getEnergyStack();
            StoredEnergyStack item2 = ((MonitoredEnergyStack)str2.getSaveableInfo()).getEnergyStack();
            switch (type) {
                case CAPACITY: {
                    return SonarHelper.compareWithDirection((long)item1.capacity, (long)item2.capacity, (SortingDirection)dir);
                }
                case INPUT: {
                    return SonarHelper.compareWithDirection((long)item1.input, (long)item2.input, (SortingDirection)dir);
                }
                case NAME: {
                    String modid1 = ((MonitoredEnergyStack)str1.getSaveableInfo()).getMonitoredCoords().getUnlocalizedName();
                    String modid2 = ((MonitoredEnergyStack)str2.getSaveableInfo()).getMonitoredCoords().getUnlocalizedName();
                    return SonarHelper.compareStringsWithDirection((String)modid1, (String)modid2, (SortingDirection)dir);
                }
                case STORED: {
                    return SonarHelper.compareWithDirection((long)item1.stored, (long)item2.stored, (SortingDirection)dir);
                }
                case TYPE: {
                    return SonarHelper.compareStringsWithDirection((String)item1.energyType.getName(), (String)item2.energyType.getName(), (SortingDirection)dir);
                }
            }
            return 0;
        });
        return updateInfo;
    }

    public static ILogicListSorter copySorter(ILogicListSorter sorter) {
        NBTTagCompound saveTag = SortingHelper.saveListSorter(new NBTTagCompound(), sorter, NBTHelper.SyncType.SAVE);
        return SortingHelper.loadListSorter(saveTag);
    }

    public static int getRegisteredID(ILogicListSorter info) {
        if (info == null || info.getRegisteredName() == null) {
            return -1;
        }
        Integer id = PL2ASMLoader.changeableListSorterIDs.get(info.getRegisteredName());
        return id == null ? -1 : id;
    }

    public static Class<? extends ILogicListSorter> getElementClass(int id) {
        return PL2ASMLoader.changeableListSorterIClasses.get(id);
    }

    public static NBTTagCompound saveListSorter(NBTTagCompound tag, ILogicListSorter info, NBTHelper.SyncType type) {
        tag.func_74768_a("LsiD", SortingHelper.getRegisteredID(info));
        return info.writeData(tag, type);
    }

    public static ILogicListSorter loadListSorter(NBTTagCompound tag) {
        int elementID = tag.func_74762_e("LsiD");
        return SortingHelper.instanceListSorter(SortingHelper.getElementClass(elementID), tag);
    }

    @Nullable
    public static <T extends ILogicListSorter> T instanceListSorter(Class<T> classType, NBTTagCompound tag) {
        ILogicListSorter obj = null;
        try {
            if (classType != null) {
                obj = (ILogicListSorter)classType.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            SonarCore.logger.error("FAILED TO CREATE NEW INSTANCE OF " + classType.getSimpleName());
        }
        if (obj != null) {
            obj.readData(tag, NBTHelper.SyncType.SAVE);
            return (T)obj;
        }
        return null;
    }
}

