/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.readers.network.handling;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.api.core.tiles.displays.info.IProvidableInfo;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.readers.IListReader;
import sonar.logistics.base.channels.handling.DefaultNetworkChannels;
import sonar.logistics.base.tiles.INetworkTile;
import sonar.logistics.core.tiles.connections.data.network.CacheHandler;
import sonar.logistics.core.tiles.displays.info.types.general.InfoChangeableList;
import sonar.logistics.core.tiles.readers.network.handling.NetworkWatcherHandler;

public class NetworkWatcherChannels
extends DefaultNetworkChannels {
    public List<IListReader<IProvidableInfo>> readers = new ArrayList<IListReader<IProvidableInfo>>();
    protected Iterator<IListReader<IProvidableInfo>> readerIterator;
    public AbstractChangeableList<IProvidableInfo> networkList = new InfoChangeableList<IProvidableInfo>();
    public boolean shouldRapidUpdate;
    protected int readersPerTick = 0;
    protected boolean hasListeners = false;

    public NetworkWatcherChannels(ILogisticsNetwork network) {
        super(network, CacheHandler.READER);
    }

    public NetworkWatcherHandler handler() {
        return NetworkWatcherHandler.INSTANCE;
    }

    @Override
    public void updateChannel() {
        super.updateChannel();
        if (this.hasListeners) {
            this.updateNetworkList();
            this.updateReaders(true);
        }
    }

    @Override
    protected void tickChannels() {
        super.tickChannels();
        this.hasListeners = false;
        for (IListReader<IProvidableInfo> reader : this.readers) {
            if (!reader.getListenerList().hasListeners()) continue;
            this.hasListeners = true;
            break;
        }
        if (this.hasListeners) {
            this.updateTickLists();
        }
    }

    public void updateTickLists() {
        this.readersPerTick = this.readers.size() > this.handler().updateRate() ? (int)Math.ceil(this.readers.size() / Math.max(1, this.handler().updateRate())) : 1;
        this.readerIterator = this.readers.iterator();
    }

    @Override
    public void addConnection(INetworkTile connection) {
        IListReader reader = (IListReader)connection;
        if (reader.getValidHandlers().contains(this.handler()) && !this.readers.contains(reader) && this.readers.add(reader)) {
            this.onChannelsChanged();
            this.tickChannels();
        }
    }

    @Override
    public void removeConnection(INetworkTile connection) {
        if (connection instanceof IListReader && this.readers.remove(connection)) {
            this.onChannelsChanged();
            this.tickChannels();
        }
    }

    public void updateNetworkList() {
        this.networkList = this.handler().updateNetworkList(this.networkList, this.network);
    }

    public void updateReaders(boolean send) {
        for (int used = 0; this.readerIterator.hasNext() && used != this.readersPerTick; ++used) {
            IListReader<IProvidableInfo> reader = this.readerIterator.next();
            if (!reader.getListenerList().hasListeners()) continue;
            this.handler().updateAndSendList(this.network, reader, this.networkList, send);
        }
    }

    public void updateAllReaders(boolean send) {
        this.readers.forEach(reader -> this.handler().updateAndSendList(this.network, (IListReader<IProvidableInfo>)reader, this.networkList, send));
    }

    @Override
    public void onCreated() {
    }

    @Override
    public void onDeleted() {
        super.onDeleted();
        this.readers.clear();
        this.readerIterator = null;
    }

    @Override
    public int getUpdateRate() {
        return this.handler().updateRate();
    }
}

