/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.wireless.emitters;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.core.api.IFlexibleGui;
import sonar.core.handlers.inventories.containers.ContainerMultipartSync;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.integration.multipart.TileSonarMultipart;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.api.core.tiles.wireless.EnumWirelessConnectionState;
import sonar.logistics.api.core.tiles.wireless.EnumWirelessSecurity;
import sonar.logistics.api.core.tiles.wireless.IWirelessManager;
import sonar.logistics.api.core.tiles.wireless.emitters.IWirelessEmitter;
import sonar.logistics.api.core.tiles.wireless.receivers.IWirelessReceiver;
import sonar.logistics.core.tiles.wireless.base.TileAbstractWireless;
import sonar.logistics.core.tiles.wireless.emitters.GuiWirelessEmitter;

public abstract class TileAbstractEmitter<E extends IWirelessEmitter, R extends IWirelessReceiver>
extends TileAbstractWireless
implements IWirelessEmitter,
IFlexibleGui,
IByteBufTile {
    public static final String UNNAMED = "Unnamed Emitter";
    public SyncTagType.STRING emitterName = (SyncTagType.STRING)new SyncTagType.STRING(2).setDefault((Object)"Unnamed Emitter");
    public SyncEnum<EnumWirelessSecurity> security = new SyncEnum((Enum[])EnumWirelessSecurity.values(), 5);

    public TileAbstractEmitter() {
        this.syncList.addParts(new IDirtyPart[]{this.emitterName, this.security});
    }

    public abstract IWirelessManager<E, R> getWirelessHandler();

    @Override
    public EnumWirelessConnectionState canPlayerConnect(UUID uuid) {
        return EnumWirelessConnectionState.fromBoolean(this.playerUUID.getUUID().equals(uuid));
    }

    @Override
    public String getEmitterName() {
        return (String)this.emitterName.getObject();
    }

    @Override
    public EnumWirelessSecurity getSecurity() {
        return (EnumWirelessSecurity)this.security.getObject();
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new GuiWirelessEmitter(this) : null;
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new ContainerMultipartSync((TileSonarMultipart)this) : null;
    }

    public void writePacket(ByteBuf buf, int id) {
        ISyncPart part = NBTHelper.getSyncPartByID((ArrayList)this.syncList.getStandardSyncParts(), (int)id);
        if (part != null) {
            part.writeToBuf(buf);
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        EnumWirelessSecurity oldSetting = this.getSecurity();
        ISyncPart part = NBTHelper.getSyncPartByID((ArrayList)this.syncList.getStandardSyncParts(), (int)id);
        if (part != null) {
            part.readFromBuf(buf);
        }
        if (id == 5) {
            this.getWirelessHandler().onEmitterSecurityChanged(this, oldSetting);
        }
    }

    public void onGuiOpened(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                SonarMultipartHelper.sendMultipartSyncToPlayer((TileSonarMultipart)this, (EntityPlayerMP)((EntityPlayerMP)player));
            }
        }
    }
}

