/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.wireless.emitters;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import sonar.core.api.IFlexibleGui;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.integration.multipart.TileSonarMultipart;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.PL2;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValue;
import sonar.logistics.api.core.tiles.displays.info.lists.UniversalChangeableList;
import sonar.logistics.api.core.tiles.readers.channels.INetworkChannels;
import sonar.logistics.api.core.tiles.readers.channels.INetworkHandler;
import sonar.logistics.api.core.tiles.wireless.IWirelessManager;
import sonar.logistics.api.core.tiles.wireless.emitters.IDataEmitter;
import sonar.logistics.base.channels.NodeConnection;
import sonar.logistics.base.channels.handling.ListNetworkChannels;
import sonar.logistics.base.listeners.ListenerType;
import sonar.logistics.base.listeners.PL2ListenerList;
import sonar.logistics.core.tiles.displays.info.types.fluids.InfoNetworkFluid;
import sonar.logistics.core.tiles.displays.info.types.items.MonitoredItemStack;
import sonar.logistics.core.tiles.readers.fluids.handling.FluidNetworkHandler;
import sonar.logistics.core.tiles.readers.items.handling.ItemNetworkHandler;
import sonar.logistics.core.tiles.wireless.emitters.TileAbstractEmitter;
import sonar.logistics.core.tiles.wireless.handling.WirelessDataManager;

public class TileDataEmitter
extends TileAbstractEmitter
implements IDataEmitter,
IFlexibleGui,
IByteBufTile {
    public PL2ListenerList listeners = new PL2ListenerList(this, ListenerType.ALL.size());
    public static int STATIC_ITEM_ID = -16;
    public static int STATIC_FLUID_ID = -17;
    public List<INetworkHandler> validHandlers;

    public IWirelessManager getWirelessHandler() {
        return WirelessDataManager.instance();
    }

    @Override
    public AbstractChangeableList<MonitoredItemStack> getServerItems() {
        return PL2.proxy.getInfoManager(this.isClient()).getChangeableListMap().getOrDefault(new InfoUUID(this.getIdentity(), STATIC_ITEM_ID), UniversalChangeableList.newChangeableList());
    }

    @Override
    public AbstractChangeableList<InfoNetworkFluid> getServerFluids() {
        return PL2.proxy.getInfoManager(this.isClient()).getChangeableListMap().getOrDefault(new InfoUUID(this.getIdentity(), STATIC_FLUID_ID), UniversalChangeableList.newChangeableList());
    }

    @Override
    public AbstractChangeableList sortMonitoredList(AbstractChangeableList updateInfo, int channelID) {
        return updateInfo;
    }

    @Override
    public void sendRapidUpdate(EntityPlayer player) {
        SonarMultipartHelper.sendMultipartSyncToPlayer((TileSonarMultipart)this, (EntityPlayerMP)((EntityPlayerMP)player));
        for (INetworkHandler handler : this.getValidHandlers()) {
            INetworkChannels list = this.network.getNetworkChannels(handler.getChannelsType());
            if (!(list instanceof ListNetworkChannels)) continue;
            ((ListNetworkChannels)list).sendLocalRapidUpdate(this, player);
        }
    }

    @Override
    public AbstractChangeableList<IInfo> getViewableList(AbstractChangeableList<IInfo> updateList, InfoUUID uuid, Map<NodeConnection, AbstractChangeableList<IInfo>> channels, List<NodeConnection> usedChannels) {
        for (Map.Entry<NodeConnection, AbstractChangeableList<IInfo>> entry : channels.entrySet()) {
            if (entry.getValue().getList().isEmpty()) continue;
            for (IMonitoredValue<IInfo> coordInfo : entry.getValue().getList()) {
                updateList.add(coordInfo.getSaveableInfo());
            }
            usedChannels.add(entry.getKey());
        }
        return updateList;
    }

    @Override
    public List<INetworkHandler> getValidHandlers() {
        if (this.validHandlers == null) {
            this.validHandlers = Lists.newArrayList((Object[])new INetworkHandler[]{ItemNetworkHandler.INSTANCE, FluidNetworkHandler.INSTANCE});
        }
        return this.validHandlers;
    }

    @Override
    public List<NodeConnection> getUsedChannels(Map<NodeConnection, AbstractChangeableList<IInfo>> channels) {
        return Lists.newArrayList(channels.keySet());
    }

    @Override
    public PL2ListenerList getListenerList() {
        return this.listeners;
    }
}

