/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.wireless.receivers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.core.api.IFlexibleGui;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.api.core.tiles.wireless.IWirelessManager;
import sonar.logistics.api.core.tiles.wireless.emitters.IWirelessEmitter;
import sonar.logistics.api.core.tiles.wireless.receivers.IDataReceiver;
import sonar.logistics.base.guidance.errors.ErrorMessage;
import sonar.logistics.core.tiles.wireless.handling.WirelessDataManager;
import sonar.logistics.core.tiles.wireless.receivers.GuiDataReceiver;
import sonar.logistics.core.tiles.wireless.receivers.TileAbstractReceiver;

public class TileDataReceiver
extends TileAbstractReceiver
implements IDataReceiver,
IFlexibleGui,
IByteBufTile {
    public List<Integer> networks = new ArrayList<Integer>();

    public IWirelessManager getWirelessHandler() {
        return WirelessDataManager.instance();
    }

    public void updateStates() {
        this.states.markTileMessage(ErrorMessage.NO_EMITTERS_CONNECTED, this.clientEmitters.getObjects().isEmpty());
        this.states.markTileMessage(ErrorMessage.EMITTERS_OFFLINE, !this.clientEmitters.getObjects().isEmpty() && this.networks.isEmpty());
    }

    @Override
    public List<Integer> getConnectedNetworks() {
        return this.networks;
    }

    @Override
    public void refreshConnectedNetworks() {
        this.networks = this.getNetworks();
        this.updateStates();
    }

    public List<Integer> getNetworks() {
        ArrayList<Integer> networks = new ArrayList<Integer>();
        List emitters = this.getEmitters();
        for (IWirelessEmitter emitter : emitters) {
            if (emitter.getNetworkID() == -1) continue;
            networks.add(emitter.getNetworkID());
        }
        return networks;
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new GuiDataReceiver(this) : null;
    }

    @Override
    public ErrorMessage[] getValidMessages() {
        return validStates;
    }

    public void onEmitterConnected(IWirelessEmitter emitter) {
        this.refreshConnectedNetworks();
        WirelessDataManager.instance().connectNetworks(this.getNetwork(), emitter.getNetwork());
    }

    public void onEmitterDisconnected(IWirelessEmitter emitter) {
        this.refreshConnectedNetworks();
        WirelessDataManager.instance().disconnectNetworks(this.getNetwork(), emitter.getNetwork());
    }
}

