/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.integration.ae2;

import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import java.util.List;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.api.asm.ASMInfo;
import sonar.logistics.api.core.tiles.displays.info.IComparableInfo;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.INameableInfo;
import sonar.logistics.api.core.tiles.displays.info.IProvidableInfo;
import sonar.logistics.api.core.tiles.displays.info.comparators.ComparableObject;
import sonar.logistics.api.core.tiles.displays.info.register.LogicPath;
import sonar.logistics.api.core.tiles.displays.info.register.RegistryType;
import sonar.logistics.core.tiles.displays.info.types.BaseInfo;

@ASMInfo(id="ae2-drive-info", modid="appliedenergistics2")
public class AE2DriveInfo
extends BaseInfo<AE2DriveInfo>
implements IProvidableInfo<AE2DriveInfo>,
INameableInfo<AE2DriveInfo>,
IComparableInfo<AE2DriveInfo> {
    public static final String id = "ae2-drive-info";
    public SyncTagType.LONG totalBytes = new SyncTagType.LONG(1);
    public SyncTagType.LONG usedBytes = new SyncTagType.LONG(2);
    public SyncTagType.LONG totalTypes = new SyncTagType.LONG(3);
    public SyncTagType.LONG usedTypes = new SyncTagType.LONG(4);
    public SyncTagType.LONG itemCount = new SyncTagType.LONG(5);
    public SyncTagType.INT driveNum = new SyncTagType.INT(5);

    public AE2DriveInfo() {
        this.syncList.addParts(new IDirtyPart[]{this.totalBytes, this.usedBytes, this.totalTypes, this.usedTypes, this.itemCount, this.driveNum});
    }

    public AE2DriveInfo(int driveNum) {
        this.syncList.addParts(new IDirtyPart[]{this.totalBytes, this.usedBytes, this.totalTypes, this.usedTypes, this.itemCount, this.driveNum});
        this.driveNum.setObject((Object)driveNum);
    }

    public AE2DriveInfo(List<IMEInventoryHandler> invHandlers, int driveNum) {
        this(driveNum);
        for (IMEInventoryHandler handler : invHandlers) {
            ICellInventoryHandler cell;
            ICellInventory cellInventory;
            if (!(handler instanceof ICellInventoryHandler) || (cellInventory = (cell = (ICellInventoryHandler)handler).getCellInv()) == null) continue;
            SyncTagType.LONG lONG = this.totalBytes;
            Long.valueOf((Long)lONG.current + cellInventory.getTotalBytes());
            lONG.current = lONG.current;
            lONG = this.usedBytes;
            Long.valueOf((Long)lONG.current + cellInventory.getUsedBytes());
            lONG.current = lONG.current;
            lONG = this.totalTypes;
            Long.valueOf((Long)lONG.current + cellInventory.getTotalItemTypes());
            lONG.current = lONG.current;
            lONG = this.usedTypes;
            Long.valueOf((Long)lONG.current + cellInventory.getStoredItemTypes());
            lONG.current = lONG.current;
            lONG = this.itemCount;
            Long.valueOf((Long)lONG.current + cellInventory.getStoredItemCount());
            lONG.current = lONG.current;
        }
    }

    @Override
    public String getID() {
        return id;
    }

    @Override
    public boolean isIdenticalInfo(AE2DriveInfo info) {
        return ((Long)info.totalBytes.getObject()).equals(this.totalBytes.getObject()) && ((Long)info.usedBytes.getObject()).equals(this.usedBytes.getObject()) && ((Long)info.totalTypes.getObject()).equals(this.totalTypes.getObject()) && ((Long)info.usedTypes.getObject()).equals(this.usedTypes.getObject()) && ((Long)info.itemCount.getObject()).equals(this.itemCount.getObject());
    }

    @Override
    public boolean isMatchingInfo(AE2DriveInfo info) {
        return ((Integer)info.driveNum.getObject()).equals(this.driveNum.getObject());
    }

    @Override
    public boolean isMatchingType(IInfo info) {
        return info instanceof AE2DriveInfo;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public AE2DriveInfo copy() {
        AE2DriveInfo newInfo = new AE2DriveInfo();
        newInfo.syncList.copyFrom(this.syncList);
        newInfo.setPath(this.getPath().dupe());
        return newInfo;
    }

    @Override
    public List<ComparableObject> getComparableObjects(List<ComparableObject> objects) {
        objects.add(new ComparableObject(this, "total bytes", this.totalBytes.getObject()));
        objects.add(new ComparableObject(this, "used bytes", this.usedBytes.getObject()));
        objects.add(new ComparableObject(this, "total types", this.totalTypes.getObject()));
        objects.add(new ComparableObject(this, "used types", this.usedTypes.getObject()));
        objects.add(new ComparableObject(this, "items count", this.itemCount.getObject()));
        objects.add(new ComparableObject(this, "drive number", this.driveNum.getObject()));
        return objects;
    }

    @Override
    public String getClientIdentifier() {
        return (Integer)this.driveNum.getObject() == 0 ? "ME DRIVE" : "ME CELL " + this.driveNum.getObject();
    }

    @Override
    public String getClientObject() {
        return "Bytes[" + this.usedBytes.getObject() + "/" + this.totalBytes.getObject() + "]";
    }

    @Override
    public String getClientType() {
        return (Integer)this.driveNum.getObject() == 0 ? "ME drive" : "ME cell";
    }

    @Override
    public RegistryType getRegistryType() {
        return RegistryType.TILE;
    }

    @Override
    public AE2DriveInfo setRegistryType(RegistryType type) {
        return this;
    }

    @Override
    public void setFromReturn(LogicPath path, Object returned) {
    }
}

