/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.core.tiles.displays.info.InfoPacketHelper;

public class PacketInfoUpdates
implements IMessage {
    public NBTTagCompound tag;
    public NBTHelper.SyncType type;

    public PacketInfoUpdates() {
    }

    public PacketInfoUpdates(NBTTagCompound tag, NBTHelper.SyncType type) {
        this.tag = tag;
        this.type = type;
    }

    public void fromBytes(ByteBuf buf) {
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.type = NBTHelper.SyncType.values()[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
        buf.writeInt(this.type.ordinal());
    }

    public static class Handler
    implements IMessageHandler<PacketInfoUpdates, IMessage> {
        public IMessage onMessage(PacketInfoUpdates message, MessageContext ctx) {
            SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> InfoPacketHelper.receiveInfoUpdate(message.tag, message.type));
            return null;
        }
    }
}

