/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.displays.info.lists.UniversalChangeableList;
import sonar.logistics.api.core.tiles.readers.ILogicListSorter;
import sonar.logistics.base.ClientInfoHandler;
import sonar.logistics.base.events.types.InfoEvent;
import sonar.logistics.core.tiles.readers.info.handling.InfoHelper;

public class PacketMonitoredList
implements IMessage {
    public InfoUUID id;
    public int identity;
    public int networkID;
    public AbstractChangeableList list;
    public NBTTagCompound listTag;
    public NBTHelper.SyncType type;
    public ILogicListSorter sorter;

    public PacketMonitoredList() {
    }

    public PacketMonitoredList(int identity, InfoUUID id, int networkID, NBTTagCompound listTag, NBTHelper.SyncType type, ILogicListSorter sorter) {
        this.identity = identity;
        this.id = id;
        this.networkID = networkID;
        this.listTag = listTag;
        this.type = type;
        this.sorter = sorter;
    }

    public void fromBytes(ByteBuf buf) {
        this.identity = buf.readInt();
        this.networkID = buf.readInt();
        this.id = InfoUUID.getUUID(buf);
        this.type = NBTHelper.SyncType.values()[buf.readInt()];
        this.listTag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.identity);
        buf.writeInt(this.networkID);
        this.id.writeToBuf(buf);
        buf.writeInt(this.type.ordinal());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.listTag);
    }

    public static class Handler
    implements IMessageHandler<PacketMonitoredList, IMessage> {
        public IMessage onMessage(PacketMonitoredList message, MessageContext ctx) {
            if (message.listTag != null) {
                SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> {
                    AbstractChangeableList list = InfoHelper.readMonitoredList(message.listTag, (AbstractChangeableList)ClientInfoHandler.instance().getChangeableListMap().getOrDefault(message.id, UniversalChangeableList.newChangeableList()), message.type);
                    ClientInfoHandler.instance().getChangeableListMap().put(message.id, list);
                    MinecraftForge.EVENT_BUS.post((Event)new InfoEvent.ListChanged(list, message.id, ctx.side.isClient()));
                });
            }
            return null;
        }
    }
}

