/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.sync;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.SyncPart;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.core.tiles.readers.info.handling.InfoHelper;

public class SyncMonitoredType<T extends IInfo>
extends SyncPart {
    public IInfo<T> info;

    public SyncMonitoredType(int id) {
        super(id);
    }

    public void setInfo(IInfo<T> info) {
        this.info = info;
        this.markChanged();
    }

    public T getMonitoredInfo() {
        return (T)this.info;
    }

    public void writeToBuf(ByteBuf buf) {
        if (this.info != null && this.info.isValid()) {
            buf.writeBoolean(true);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
        } else {
            buf.writeBoolean(false);
        }
    }

    public void readFromBuf(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.readData(ByteBufUtils.readTag((ByteBuf)buf), NBTHelper.SyncType.SAVE);
        } else {
            this.info = null;
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.info != null && this.info.isValid()) {
            nbt.func_74782_a(this.getTagName(), (NBTBase)InfoHelper.writeInfoToNBT(new NBTTagCompound(), this.info, type));
        }
        return nbt;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (nbt.func_74764_b(this.getTagName())) {
            this.info = InfoHelper.readInfoFromNBT(nbt.func_74775_l(this.getTagName()));
        }
    }
}

