/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.lexicon.multiblock.IMultiblockRenderHook;
import vazkii.botania.api.lexicon.multiblock.Multiblock;
import vazkii.botania.api.lexicon.multiblock.MultiblockSet;
import vazkii.botania.api.lexicon.multiblock.component.MultiblockComponent;
import vazkii.botania.client.core.handler.MultiblockBlockAccess;
import vazkii.botania.client.core.helper.ShaderHelper;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="botania")
public final class MultiblockRenderHandler {
    private static final MultiblockBlockAccess blockAccess = new MultiblockBlockAccess();
    private static int dimension;
    public static boolean rendering;
    public static MultiblockSet currentMultiblock;
    public static BlockPos anchor;
    public static EnumFacing angle;

    private MultiblockRenderHandler() {
    }

    public static void setMultiblock(MultiblockSet set) {
        currentMultiblock = set;
        anchor = null;
        angle = EnumFacing.SOUTH;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            dimension = mc.field_71441_e.field_73011_w.getDimension();
        }
    }

    @SubscribeEvent
    public static void onWorldRenderLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71439_g == null || mc.field_71476_x == null || mc.field_71476_x.func_178782_a() == null || mc.field_71439_g.func_70093_af() && anchor == null)) {
            MultiblockRenderHandler.renderPlayerLook((EntityPlayer)mc.field_71439_g, mc.field_71476_x);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (currentMultiblock != null && anchor == null && event.getEntityPlayer() == Minecraft.func_71410_x().field_71439_g) {
            anchor = event.getPos();
            angle = event.getEntityPlayer().func_174811_aO();
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
        }
    }

    private static void renderPlayerLook(EntityPlayer player, RayTraceResult src) {
        if (currentMultiblock != null && dimension == player.field_70170_p.field_73011_w.getDimension()) {
            BlockPos anchorPos = anchor != null ? anchor : src.func_178782_a();
            GlStateManager.func_179094_E();
            GL11.glPushAttrib((int)64);
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179140_f();
            rendering = true;
            Multiblock mb = anchor != null ? currentMultiblock.getForFacing(angle) : currentMultiblock.getForEntity((Entity)player);
            boolean didAny = false;
            blockAccess.update((IBlockAccess)player.field_70170_p, mb, anchorPos);
            ShaderHelper.useShader(ShaderHelper.alpha, shader -> {
                int alpha = ARBShaderObjects.glGetUniformLocationARB((int)shader, (CharSequence)"alpha");
                ARBShaderObjects.glUniform1fARB((int)alpha, (float)0.4f);
            });
            for (MultiblockComponent comp : mb.getComponents()) {
                if (!MultiblockRenderHandler.renderComponentInWorld(player.field_70170_p, mb, comp, anchorPos)) continue;
                didAny = true;
            }
            ShaderHelper.releaseShader();
            rendering = false;
            GL11.glPopAttrib();
            GlStateManager.func_179121_F();
            if (!didAny) {
                MultiblockRenderHandler.setMultiblock(null);
                player.func_145747_a(new TextComponentTranslation("botaniamisc.structureComplete", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            }
        }
    }

    private static boolean renderComponentInWorld(World world, Multiblock mb, MultiblockComponent comp, BlockPos anchorPos) {
        double renderPosX = Minecraft.func_71410_x().func_175598_ae().field_78725_b;
        double renderPosY = Minecraft.func_71410_x().func_175598_ae().field_78726_c;
        double renderPosZ = Minecraft.func_71410_x().func_175598_ae().field_78723_d;
        BlockPos pos = comp.getRelativePosition();
        BlockPos pos_ = pos.func_177971_a((Vec3i)anchorPos);
        if (anchor != null && comp.matches(world, pos_)) {
            return false;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-renderPosX), (double)(-renderPosY), (double)(-renderPosZ));
        GlStateManager.func_179097_i();
        MultiblockRenderHandler.doRenderComponent(mb, comp, pos_);
        GlStateManager.func_179121_F();
        return true;
    }

    public static void renderMultiblockOnPage(Multiblock mb) {
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
        blockAccess.update(null, mb, mb.offPos);
        for (MultiblockComponent comp : mb.getComponents()) {
            BlockPos pos = comp.getRelativePosition();
            MultiblockRenderHandler.doRenderComponent(mb, comp, pos.func_177971_a((Vec3i)mb.offPos));
        }
    }

    private static void doRenderComponent(Multiblock mb, MultiblockComponent comp, BlockPos pos) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        IBlockState state = comp.getBlockState();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        if (state == null) {
            return;
        }
        if (IMultiblockRenderHook.renderHooks.containsKey(state.func_177230_c())) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            IMultiblockRenderHook renderHook = IMultiblockRenderHook.renderHooks.get(state.func_177230_c());
            if (renderHook.needsTranslate(state)) {
                GlStateManager.func_179137_b((double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5));
            }
            renderHook.renderBlockForMultiblock(blockAccess, mb, state, comp);
        } else {
            BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
            GlStateManager.func_179109_b((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)(pos.func_177952_p() + 1));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            brd.func_175016_a(state, 1.0f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }

    static {
        rendering = false;
    }
}

