/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileGenerating;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.lexicon.LexiconData;

public class SubTileHydroangeas
extends SubTileGenerating {
    private static final String TAG_BURN_TIME = "burnTime";
    private static final String TAG_COOLDOWN = "cooldown";
    private static final BlockPos[] OFFSETS = new BlockPos[]{new BlockPos(0, 0, 1), new BlockPos(0, 0, -1), new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(-1, 0, -1), new BlockPos(1, 0, 1), new BlockPos(1, 0, -1)};
    int burnTime;
    int cooldown;

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.cooldown > 0) {
            --this.cooldown;
            for (int i = 0; i < 3; ++i) {
                Botania.proxy.wispFX((double)this.supertile.func_174877_v().func_177958_n() + 0.5 + Math.random() * 0.2 - 0.1, (double)this.supertile.func_174877_v().func_177956_o() + 0.5 + Math.random() * 0.2 - 0.1, (double)this.supertile.func_174877_v().func_177952_p() + 0.5 + Math.random() * 0.2 - 0.1, 0.1f, 0.1f, 0.1f, (float)Math.random() / 6.0f, (float)(-Math.random()) / 30.0f);
            }
        }
        if (this.burnTime == 0) {
            if (this.mana < this.getMaxMana() && !this.supertile.func_145831_w().field_72995_K) {
                List<BlockPos> offsets = Arrays.asList(OFFSETS);
                Collections.shuffle(offsets);
                for (BlockPos offset : offsets) {
                    PropertyInteger prop;
                    BlockPos pos = this.supertile.func_174877_v().func_177971_a((Vec3i)offset);
                    Material search = this.getMaterialToSearchFor();
                    Object object = this.supertile.func_145831_w().func_180495_p(pos).func_177230_c() instanceof BlockLiquid ? BlockLiquid.field_176367_b : (prop = this.supertile.func_145831_w().func_180495_p(pos).func_177230_c() instanceof BlockFluidBase ? BlockFluidBase.LEVEL : null);
                    if (this.supertile.func_145831_w().func_180495_p(pos).func_185904_a() != search || this.getBlockToSearchBelow() != null && this.supertile.func_145831_w().func_180495_p(pos.func_177977_b()).func_177230_c() != this.getBlockToSearchBelow() || prop != null && (Integer)this.supertile.func_145831_w().func_180495_p(pos).func_177229_b((IProperty)prop) != 0) continue;
                    if (search != Material.field_151586_h) {
                        this.supertile.func_145831_w().func_175698_g(pos);
                    } else {
                        int waterAround = 0;
                        for (EnumFacing dir : EnumFacing.field_176754_o) {
                            if (this.supertile.func_145831_w().func_180495_p(pos.func_177972_a(dir)).func_185904_a() != search) continue;
                            ++waterAround;
                        }
                        if (waterAround < 2) {
                            this.supertile.func_145831_w().func_175698_g(pos);
                        }
                    }
                    if (this.cooldown == 0) {
                        this.burnTime += this.getBurnTime();
                    } else {
                        this.cooldown = this.getCooldown();
                    }
                    this.sync();
                    this.playSound();
                    break;
                }
            }
        } else {
            if (this.supertile.func_145831_w().field_73012_v.nextInt(8) == 0) {
                this.doBurnParticles();
            }
            --this.burnTime;
            if (this.burnTime == 0) {
                this.cooldown = this.getCooldown();
                this.sync();
            }
        }
    }

    public void doBurnParticles() {
        Botania.proxy.wispFX((double)this.supertile.func_174877_v().func_177958_n() + 0.55 + Math.random() * 0.2 - 0.1, (double)this.supertile.func_174877_v().func_177956_o() + 0.55 + Math.random() * 0.2 - 0.1, (double)this.supertile.func_174877_v().func_177952_p() + 0.5, 0.05f, 0.05f, 0.7f, (float)Math.random() / 6.0f, (float)(-Math.random()) / 60.0f);
    }

    public Material getMaterialToSearchFor() {
        return Material.field_151586_h;
    }

    public Block getBlockToSearchBelow() {
        return null;
    }

    public void playSound() {
        this.supertile.func_145831_w().func_184133_a(null, this.supertile.func_174877_v(), SoundEvents.field_187664_bz, SoundCategory.BLOCKS, 0.01f, 0.5f + (float)Math.random() * 0.5f);
    }

    public int getBurnTime() {
        return 40;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), 1);
    }

    @Override
    public int getMaxMana() {
        return 150;
    }

    @Override
    public int getColor() {
        return 5451744;
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.hydroangeas;
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_BURN_TIME, this.burnTime);
        cmp.func_74768_a(TAG_COOLDOWN, this.cooldown);
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        this.burnTime = cmp.func_74762_e(TAG_BURN_TIME);
        this.cooldown = cmp.func_74762_e(TAG_COOLDOWN);
    }

    @Override
    public void populateDropStackNBTs(List<ItemStack> drops) {
        super.populateDropStackNBTs(drops);
        int cooldown = this.cooldown;
        if (this.burnTime > 0) {
            cooldown = this.getCooldown();
        }
        if (cooldown > 0) {
            ItemNBTHelper.setInt(drops.get(0), TAG_COOLDOWN, this.getCooldown());
        }
    }

    @Override
    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, entity, stack);
        this.cooldown = ItemNBTHelper.getInt(stack, TAG_COOLDOWN, 0);
    }

    @Override
    public boolean canGeneratePassively() {
        return this.burnTime > 0;
    }

    @Override
    public int getDelayBetweenPassiveGeneration() {
        boolean rain = this.supertile.func_145831_w().func_180494_b(this.supertile.func_174877_v()).func_76727_i() > 0.0f && (this.supertile.func_145831_w().func_72896_J() || this.supertile.func_145831_w().func_72911_I());
        return rain ? 2 : 3;
    }

    public int getCooldown() {
        return 0;
    }

    @Override
    public boolean isPassiveFlower() {
        return true;
    }
}

