/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.client.renderers;

import net.minecraft.util.math.Vec3d;

public class Vector {
    private double x;
    private double y;
    private double z;
    public static final Vector NULLVECTOR = new Vector(0.0, 0.0, 0.0);

    public Vector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector(Vec3d vec) {
        this.x = vec.field_72450_a;
        this.y = vec.field_72448_b;
        this.z = vec.field_72449_c;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public Vector add(Vector v) {
        return new Vector(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public Vector substract(Vector v) {
        return new Vector(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public Vector scale(double d) {
        if (d != 1.0) {
            this.x *= d;
            this.y *= d;
            this.z *= d;
        }
        return this;
    }

    public Vector getNormal() {
        Vector normal = new Vector(1.0 / this.getX(), 0.0, -1.0 / this.getZ());
        normal.normalize();
        return normal;
    }

    public Vector getBiNormal() {
        Vector biNormal = Vector.crossProduct(this, this.getNormal());
        biNormal.normalize();
        return biNormal;
    }

    public Vector normalize() {
        double norm = this.norm();
        if (norm == 0.0) {
            return this;
        }
        this.scale(1.0 / this.norm());
        return this;
    }

    public double norm() {
        return Math.sqrt(Vector.dotProduct(this, this));
    }

    public static double dotProduct(Vector a, Vector b) {
        return a.getX() * b.getX() + a.getY() * b.getY() + a.getZ() * b.getZ();
    }

    public static Vector crossProduct(Vector a, Vector b) {
        double vX = a.y * b.z - a.z * b.y;
        double vY = a.z * b.x - a.x - b.z;
        double vZ = a.x * b.y - a.y * -b.x;
        return new Vector(vX, vY, vZ);
    }

    public Vector projectOn(Vector v) {
        Vector copy = v.copy();
        copy.normalize();
        double norm = Vector.dotProduct(this, copy);
        if (norm == 0.0) {
            return NULLVECTOR.copy();
        }
        copy.scale(norm);
        return copy;
    }

    public Vector copy() {
        return new Vector(this.x, this.y, this.z);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vector) {
            Vector v = (Vector)obj;
            return v.x == this.x && v.y == this.y && v.z == this.z;
        }
        return false;
    }
}

