/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.tile;

import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.SonarCore;
import sonar.core.common.tile.TileEntitySaveable;
import sonar.core.helpers.NBTHelper;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ListenableList;
import sonar.core.listener.ListenerTally;
import sonar.core.listener.PlayerListener;
import sonar.core.network.PacketTileSync;

public class TileEntitySyncable
extends TileEntitySaveable {
    public ListenableList<PlayerListener> listeners = new ListenableList<PlayerListener>(new Listener(this), 1);

    public boolean hasSyncListeners() {
        return this.listeners.hasListeners(0);
    }

    public List<PlayerListener> getSyncListeners() {
        return this.listeners.getListeners(0);
    }

    @Override
    public void onValuesChanged() {
        super.onValuesChanged();
        if (!this.field_145850_b.field_72995_K && this.hasSyncListeners()) {
            this.performSync();
        }
    }

    public void performSync() {
        NBTTagCompound tag;
        if (!this.field_145850_b.field_72995_K && !(tag = this.writeData(new NBTTagCompound(), NBTHelper.SyncType.DEFAULT_SYNC)).func_82582_d()) {
            this.getSyncListeners().forEach(l -> SonarCore.network.sendTo((IMessage)new PacketTileSync(this.func_174877_v(), tag, NBTHelper.SyncType.DEFAULT_SYNC), l.player));
        }
    }

    public void sendFirstPacket(EntityPlayerMP playerMP) {
        if (!this.field_145850_b.field_72995_K) {
            NBTTagCompound tag = this.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE);
            SonarCore.network.sendTo((IMessage)new PacketTileSync(this.func_174877_v(), tag, NBTHelper.SyncType.SAVE), playerMP);
        }
    }

    public void sendLastPacket(EntityPlayerMP playerMP) {
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.listeners.invalidateList();
    }

    public static class Listener
    implements ISonarListenable<PlayerListener> {
        public final TileEntitySyncable tile;

        public Listener(TileEntitySyncable tile) {
            this.tile = tile;
        }

        @Override
        public void onListenerAdded(ListenerTally<PlayerListener> tally) {
            this.tile.sendFirstPacket(((PlayerListener)tally.listener).player);
        }

        @Override
        public void onListenerRemoved(ListenerTally<PlayerListener> tally) {
            this.tile.sendLastPacket(((PlayerListener)tally.listener).player);
        }

        @Override
        public ListenableList<PlayerListener> getListenerList() {
            return this.tile.listeners;
        }

        @Override
        public boolean isValid() {
            return !this.tile.func_145837_r();
        }
    }
}

