/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.energy;

import net.minecraftforge.energy.IEnergyStorage;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.utils.ActionType;
import sonar.core.handlers.energy.EnumEnergyWrapperType;
import sonar.core.handlers.energy.IEnergyHandler;

public class EnergyStorageWrapper
implements IEnergyHandler {
    public IEnergyStorage storage;
    public EnumEnergyWrapperType wrapperType;
    public EnergyType type;

    public EnergyStorageWrapper(IEnergyStorage storage, EnumEnergyWrapperType wrapperType, EnergyType type) {
        this.storage = storage;
        this.wrapperType = wrapperType;
        this.type = type;
    }

    @Override
    public EnumEnergyWrapperType getWrapperType() {
        return this.wrapperType;
    }

    @Override
    public EnergyType getEnergyType() {
        return this.type;
    }

    @Override
    public boolean canAddEnergy() {
        return this.storage.canReceive();
    }

    @Override
    public boolean canRemoveEnergy() {
        return this.storage.canExtract();
    }

    @Override
    public boolean canReadEnergy() {
        return true;
    }

    @Override
    public boolean canRenderConnection() {
        return true;
    }

    @Override
    public long addEnergy(long add, ActionType actionType) {
        return this.storage.receiveEnergy((int)Math.min(Integer.MAX_VALUE, add), actionType.shouldSimulate());
    }

    @Override
    public long removeEnergy(long remove, ActionType actionType) {
        return this.storage.extractEnergy((int)Math.min(Integer.MAX_VALUE, remove), actionType.shouldSimulate());
    }

    @Override
    public long getStored() {
        return this.storage.getEnergyStored();
    }

    @Override
    public long getCapacity() {
        return this.storage.getMaxEnergyStored();
    }
}

