/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ChunkHelper {
    public static List<EntityPlayerMP> getChunkPlayers(World world, BlockPos pos) {
        return ChunkHelper.getChunkPlayers(world, new ChunkPos(pos));
    }

    public static List<EntityPlayerMP> getChunkPlayers(World world, ChunkPos pos) {
        WorldServer server;
        PlayerChunkMap map;
        PlayerChunkMapEntry entry;
        if (world instanceof WorldServer && (entry = (map = (server = (WorldServer)world).func_184164_w()).func_187301_b(pos.field_77276_a, pos.field_77275_b)) != null) {
            return ChunkHelper.getChunkPlayers(entry);
        }
        return new ArrayList<EntityPlayerMP>();
    }

    public static List<EntityPlayerMP> getChunkPlayers(World world, List<ChunkPos> chunks) {
        ArrayList<EntityPlayerMP> allPlayers = new ArrayList<EntityPlayerMP>();
        if (world instanceof WorldServer) {
            WorldServer server = (WorldServer)world;
            PlayerChunkMap map = server.func_184164_w();
            for (ChunkPos pos : chunks) {
                PlayerChunkMapEntry entry;
                if (!server.func_190526_b(pos.field_77276_a, pos.field_77275_b) || (entry = map.func_187301_b(pos.field_77276_a, pos.field_77275_b)) == null) continue;
                List<EntityPlayerMP> players = ChunkHelper.getChunkPlayers(entry);
                for (EntityPlayerMP player : players) {
                    if (allPlayers.contains(player)) continue;
                    allPlayers.add(player);
                }
            }
        }
        return allPlayers;
    }

    public static List<ChunkPos> getChunksInRadius(BlockPos pos, double radius) {
        ArrayList<ChunkPos> entities = new ArrayList<ChunkPos>();
        int smallX = MathHelper.func_76128_c((double)(((double)pos.func_177958_n() - radius) / 16.0));
        int bigX = MathHelper.func_76128_c((double)(((double)pos.func_177958_n() + radius) / 16.0));
        int smallZ = MathHelper.func_76128_c((double)(((double)pos.func_177952_p() - radius) / 16.0));
        int bigZ = MathHelper.func_76128_c((double)(((double)pos.func_177952_p() + radius) / 16.0));
        for (int x = smallX; x <= bigX; ++x) {
            for (int z = smallZ; z <= bigZ; ++z) {
                entities.add(new ChunkPos(x, z));
            }
        }
        return entities;
    }

    public static List<EntityPlayerMP> getChunkPlayers(PlayerChunkMapEntry entry) {
        return entry.getWatchingPlayers();
    }
}

