/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.DirtyPart;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.ISyncableListener;
import sonar.core.network.sync.SyncableList;

public abstract class BaseSyncListPart
extends DirtyPart
implements ISyncableListener,
INBTSyncable {
    public SyncableList syncList = new SyncableList(this);

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.shouldEmbed()) {
            NBTTagCompound tag = nbt.func_74775_l(((ISyncPart)((Object)this)).getTagName());
            if (!tag.func_82582_d()) {
                NBTHelper.readSyncParts(tag, type, this.syncList);
            }
        } else {
            NBTHelper.readSyncParts(nbt, type, this.syncList);
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.shouldEmbed()) {
            NBTTagCompound tag = NBTHelper.writeSyncParts(new NBTTagCompound(), type, this.syncList, type == NBTHelper.SyncType.SYNC_OVERRIDE);
            if (!tag.func_82582_d()) {
                nbt.func_74782_a(((ISyncPart)((Object)this)).getTagName(), (NBTBase)tag);
            }
        } else {
            NBTHelper.writeSyncParts(nbt, type, this.syncList, type.isType(NBTHelper.SyncType.SAVE));
        }
        return nbt;
    }

    @Override
    public void markChanged(IDirtyPart part) {
        this.syncList.markSyncPartChanged(part);
        this.markChanged();
    }

    public boolean shouldEmbed() {
        return this instanceof ISyncPart;
    }
}

