/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.sync;

import sonar.core.sync.ISonarValue;
import sonar.core.sync.IValueWatcher;

public class SonarValue<T>
implements ISonarValue<T> {
    public final Class<T> type;
    public final IValueWatcher watcher;
    public T value;
    public boolean isDirty;

    public SonarValue(Class<T> type, IValueWatcher watcher, T value) {
        this.type = type;
        this.watcher = watcher;
        this.watcher.addSyncValue(this);
        this.setValueInternal(value);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public boolean setValueInternal(T set) {
        if (this.value == null || set != null && !set.equals(this.value)) {
            this.value = set;
            this.watcher.onSyncValueChanged(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }
}

