/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.misc;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import pregenerator.base.impl.misc.SelectionList;

public class ListMap<L, V> {
    List<L> listOptions = new ArrayList<L>();
    Map<L, SelectionList<V>> values = new LinkedHashMap<L, SelectionList<V>>();
    int index = 0;

    public void fillIndexes(List<L> list) {
        if (this.values.isEmpty()) {
            this.index = 0;
            this.listOptions.addAll(list);
            return;
        }
        L last = this.listOptions.get(this.index);
        this.listOptions.clear();
        this.listOptions.addAll(list);
        this.index = Math.max(0, this.listOptions.indexOf(last));
    }

    public void putData(List<V> data) {
        L key = this.getCurrentKey();
        if (key == null) {
            return;
        }
        this.values.put(key, new SelectionList<V>(data));
    }

    public void putData(L value, List<V> data) {
        this.values.put(value, new SelectionList<V>(data));
    }

    public void setIndex(int index) {
        this.index = Math.max(0, Math.min(index, this.listOptions.size() - 1));
    }

    public void next() {
        ++this.index;
        if (this.index >= this.listOptions.size()) {
            this.index = 0;
        }
    }

    public void prev() {
        --this.index;
        if (this.index < 0) {
            this.index = Math.max(0, this.listOptions.size() - 1);
        }
    }

    public int size() {
        return this.listOptions.size();
    }

    public int getCurrentIndex() {
        return this.index;
    }

    public L getCurrentKey() {
        return this.listOptions.isEmpty() ? null : (L)this.listOptions.get(this.index);
    }

    public L getKey(int index) {
        return index < 0 || index >= this.listOptions.size() ? null : (L)this.listOptions.get(index);
    }

    public SelectionList<V> getCurrentValues() {
        if (this.listOptions.isEmpty()) {
            return null;
        }
        return this.values.get(this.listOptions.get(this.index));
    }

    public SelectionList<V> getForIndex(int index) {
        return index < 0 || index >= this.listOptions.size() ? null : this.values.get(this.listOptions.get(index));
    }

    public SelectionList<V> getOrCreate(L value) {
        SelectionList<V> result = this.values.get(value);
        if (result == null) {
            result = new SelectionList();
            this.values.put(value, result);
            this.listOptions.add(value);
        }
        return result;
    }

    public List<L> getKeys() {
        return this.listOptions;
    }

    public void clear() {
        this.index = 0;
        this.listOptions.clear();
        this.values.clear();
    }
}

