/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.gui;

import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Mouse;
import pregenerator.ChunkPregenerator;
import pregenerator.base.impl.gui.GuiPregenBase;
import pregenerator.base.impl.misc.ListMap;
import pregenerator.base.impl.misc.SelectionList;
import pregenerator.impl.client.gui.GuiPregenMenu;
import pregenerator.impl.client.gui.GuiWorldStuff;
import pregenerator.impl.network.packets.DimRequestPacket;
import pregenerator.impl.network.packets.chunkRequest.RemoveStructurePacket;
import pregenerator.impl.network.packets.chunkRequest.StructureRequestPacket;
import pregenerator.impl.network.packets.chunkRequest.TPChunkPacket;
import pregenerator.impl.structure.StructureData;

public class GuiStructureView
extends GuiPregenBase {
    public static final SelectionList<StructureData> DEFAULT_VALUE = new SelectionList();
    public static GuiStructureView INSTANCE = new GuiStructureView();
    SelectionList<Integer> dimensions = new SelectionList();
    int answerType = -2;
    int packetsLeft;
    ListMap<String, StructureData> structures = new ListMap();
    int ticker;

    public void openUI() {
        this.ticker = 0;
        ChunkPregenerator.networking.sendPacketToServer(new DimRequestPacket(4));
    }

    public void onCleared() {
        this.answerType = -1;
        this.packetsLeft = 0;
        this.dimensions.clear();
        this.structures.clear();
        this.structures.getOrCreate("All");
    }

    public void noDataFound() {
        this.answerType = -2;
        this.ticker = 0;
    }

    public void addData(List<StructureData> data, int type) {
        this.packetsLeft = type;
        for (StructureData entry : data) {
            this.structures.getOrCreate("All").addValue(entry);
            this.structures.getOrCreate(entry.getType()).addValue(entry);
        }
        if (type == 0) {
            this.answerType = 2;
            this.structures.setIndex(0);
        }
    }

    public void addDims(List<Integer> list) {
        boolean wasEmpty = this.dimensions.size() <= 0;
        this.dimensions.setValues(list);
        if (wasEmpty) {
            this.dimensions.setIndexFromValue(0);
            this.structures.clear();
            this.structures.getOrCreate("All");
        }
    }

    public int getDimension() {
        Integer value = this.dimensions.getValue();
        return value == null ? 0 : value;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.registerButton(0, -30, 88, 60, 20, "Back");
        this.registerButton(1, 100, -81, 20, 20, "-");
        this.registerButton(2, 121, -81, 20, 20, "+");
        this.registerButton(3, -145, -102, 95, 20, "Dim: " + this.getDimension());
        this.registerButton(4, -145, -80, 40, 20, GuiStructureView.func_146272_n() ? "Clear" : "Reload");
        this.registerButton(5, -50, -102, 60, 20, "Reload Dim");
        this.registerButton(6, 11, -102, 120, 20, "Type: " + this.structures.getCurrentKey());
        int offset = 51;
        int index = 10;
        SelectionList<StructureData> data = this.getData();
        for (int i = 0; i < 3 && i + data.getIndex() < data.size(); ++i) {
            this.registerButton(index, 83, -offset + 21, 60, 20, "Remove");
            this.registerButton(index + 1, -18, -offset, 100, 20, "Remove From World");
            this.registerButton((int)(index + 2), (int)83, (int)(-offset), (int)60, (int)20, (String)"Teleport").field_146124_l = this.field_146297_k.field_71439_g.field_71093_bK == this.getDimension();
            offset -= 47;
        }
    }

    protected void func_146284_a(GuiButton button) {
        int id = button.field_146127_k;
        if (id == 0) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiWorldStuff(new GuiPregenMenu()));
        } else if (id == 2) {
            this.getData().next();
        } else if (id == 1) {
            this.getData().prev();
        }
        if (id == 3) {
            if (GuiStructureView.func_146272_n()) {
                this.dimensions.prev();
                this.structures.clear();
                this.structures.getOrCreate("All");
            } else {
                this.dimensions.next();
                this.structures.clear();
                this.structures.getOrCreate("All");
            }
        } else if (id == 4) {
            this.structures.clear();
            this.structures.getOrCreate("All");
            if (GuiStructureView.func_146272_n()) {
                this.answerType = -1;
            } else {
                ChunkPregenerator.networking.sendPacketToServer(new StructureRequestPacket(this.getDimension()));
                this.answerType = 0;
            }
        } else if (id == 5) {
            ChunkPregenerator.networking.sendPacketToServer(new DimRequestPacket(4));
        } else if (id == 6) {
            if (GuiStructureView.func_146272_n()) {
                this.structures.prev();
            } else {
                this.structures.next();
            }
            button.field_146126_j = "Type: " + this.structures.getCurrentKey();
        } else if (id >= 10) {
            int index = (id -= 10) / 3;
            int buttonID = id % 3;
            SelectionList<StructureData> values = this.getData();
            StructureData data = values.getValue(values.getIndex() + index);
            if (buttonID == 0 || buttonID == 1) {
                ChunkPregenerator.networking.sendPacketToServer(new RemoveStructurePacket(this.getDimension(), data, buttonID == 1));
                values.removeIndex(values.getIndex() + index);
            } else if (buttonID == 2) {
                ChunkPregenerator.networking.sendPacketToServer(new TPChunkPacket(data.getPos().toChunkPos()));
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int i;
        int effect = Mouse.getDWheel() / 120;
        SelectionList<StructureData> data = this.getData();
        data.setIndex(data.getIndex() - effect * (GuiScreen.func_146271_m() ? 10 : 1));
        this.func_73866_w_();
        ++this.ticker;
        this.func_146276_q_();
        this.drawRectangle(150, 110, 0, 0, -3750202, false);
        int startY = -30;
        int end = 0;
        for (i = 0; i + data.getIndex() < data.size() && i < 3; ++i) {
            this.drawRectangle(145, 22, 0, startY, -7631989, true);
            startY += 47;
            ++end;
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawCenterText("Structure View", 4, -110, 0x404040);
        this.drawLeftText(data.getIndex() + "/" + data.size(), 144, -60, 0x404040);
        if (this.answerType == -1) {
            this.drawText("<-- Require Reloading", -100, -68, 0x404040);
        } else if (this.answerType == -2) {
            this.drawText("No Structures Found", -100, -68, 0x404040);
            if (this.ticker >= 200) {
                this.answerType = 2;
            }
        } else if (this.answerType == 1) {
            this.drawText("Awaiting Packets: " + this.packetsLeft, -100, -68, 0x404040);
        } else if (this.answerType != 2) {
            this.drawText("Reloading: ", -100, -68, 0x404040);
            StringBuilder build = new StringBuilder();
            int index = this.ticker / 20 % 5;
            for (int i2 = 0; i2 < 5; ++i2) {
                if (i2 == index) {
                    build.append("O");
                    continue;
                }
                build.append("o");
            }
            this.drawText(build.toString(), -45, -68, 0x404040);
        }
        startY = -49;
        for (i = 0; i < end; ++i) {
            StructureData entry = data.getValue(data.getIndex() + i);
            this.drawText("Type: " + entry.getType(), -144, startY, 0x404040);
            this.drawText("BlockX: " + entry.getX(), -144, startY += 10, 0x404040);
            this.drawText("BlockZ: " + entry.getZ(), -144, startY += 10, 0x404040);
            this.drawText("Will Generate: " + entry.isSuitable(), -144, startY += 10, 0x404040);
            this.drawText("Parts: " + entry.getParts(), -40, startY, 0x404040);
            startY += 17;
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private SelectionList<StructureData> getData() {
        SelectionList<StructureData> data = this.structures.getCurrentValues();
        return data == null ? DEFAULT_VALUE : data;
    }
}

