/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.infos;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pregenerator.base.api.misc.IConfig;
import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.impl.client.ClientHandler;
import pregenerator.impl.client.infos.CenterEntry;
import pregenerator.impl.client.infos.GenerationType;
import pregenerator.impl.client.infos.LagBarEntry;
import pregenerator.impl.client.infos.LoadedChunksEntry;
import pregenerator.impl.client.infos.LoadedFilesEntry;
import pregenerator.impl.client.infos.PlayerLimitEntry;
import pregenerator.impl.client.infos.PrepaireEntry;
import pregenerator.impl.client.infos.ProgressBarEntry;
import pregenerator.impl.client.infos.RadiusEntry;
import pregenerator.impl.client.infos.RunningTimeEntry;
import pregenerator.impl.client.infos.ServerRamEntry;
import pregenerator.impl.client.infos.TaskEntry;
import pregenerator.impl.processor.generator.ChunkProcessor;

public abstract class InfoEntry {
    public static final DecimalFormat FORMAT = new DecimalFormat("###,###");
    static List<InfoEntry> REGISTRY = new ArrayList<InfoEntry>();
    int id = -1;
    boolean isActive = false;

    public static List<InfoEntry> getRegistry() {
        return new ArrayList<InfoEntry>(REGISTRY);
    }

    public static InfoEntry getByID(int id) {
        if (REGISTRY.size() > id && id >= 0) {
            return REGISTRY.get(id);
        }
        return null;
    }

    public static void init() {
        new TaskEntry();
        new RadiusEntry();
        new CenterEntry();
        new GenerationType();
        new PrepaireEntry();
        new LoadedChunksEntry();
        new RunningTimeEntry();
        new LagBarEntry();
        new ServerRamEntry();
        new LoadedFilesEntry();
        new PlayerLimitEntry();
        new ProgressBarEntry();
    }

    protected final void register() {
        for (InfoEntry entry : REGISTRY) {
            if (!entry.getName().equals(this.getName())) continue;
            throw new RuntimeException("Duplicated is now allowed");
        }
        this.id = REGISTRY.size();
        REGISTRY.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public final void setActive(boolean state) {
        this.isActive = state;
        this.onValueChanged();
    }

    @SideOnly(value=Side.CLIENT)
    public final boolean isActive() {
        return this.isActive;
    }

    @SideOnly(value=Side.CLIENT)
    private final void onValueChanged() {
        ClientHandler.INSTANCE.info.saveEntry(this);
    }

    @SideOnly(value=Side.CLIENT)
    public final void readFromConfig(IConfig config) {
        this.isActive = config.getBoolean("general", this.getName(), true);
    }

    public abstract String getName();

    public boolean shouldRender() {
        return true;
    }

    public int getYOffset() {
        return 6;
    }

    public final int getID() {
        return this.id;
    }

    public abstract void write(IWriteableBuffer var1);

    public abstract void read(IReadableBuffer var1);

    public abstract int currentValue();

    public abstract int maxValue();

    @SideOnly(value=Side.CLIENT)
    public abstract void render(int var1, int var2, float var3, int var4, IRenderHelper var5);

    public ChunkProcessor getProcessor() {
        return ChunkProcessor.INSTANCE;
    }
}

