/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.gen;

import java.util.ArrayList;
import java.util.List;
import pregenerator.impl.command.CompleterHelper;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.command.base.CommandContainer;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.storage.PregenTask;

public class StartExpansionSubCommand
extends BasePregenCommand {
    public StartExpansionSubCommand() {
        super(7);
        this.addDescription(0, "Type: Which Shape the generation should have");
        this.addDescription(1, "X Center: Which Chunk the center should be in. (if 'b' infront of the number or after ~ means block position)");
        this.addDescription(2, "Z Center: Which Chunk the center should be in. (if 'b' infront of the number or after ~ means block position)");
        this.addDescription(3, "Min Radius: The Radius the Generation should start at. (if 'b' infront of the number or after ~ means block radius");
        this.addDescription(4, "Max Radius: The Radius the Generation should end at. (if 'b' infront of the number or after ~ means block radius");
        this.addDescription(5, "(Optional) Dimension: The Dimension  the Generation should happen in. (It Autoloads dimension if they are unloaded)");
        this.addDescription(6, "(Optional) Processing Rule: Which type of Generation it should use.");
        this.addSuggestion("startexpansion square 0 0 100 200", "Generates everything within a area from 100 Chunks to 200 Chunks in every direction");
        this.addSuggestion("startexpansion square 0 0 100 200 0 TerrainOnly", "Generates only Terrain within a area from 100 Chunks to 200 Chunks in every direction in the Overworld");
    }

    @Override
    public String getName() {
        return "startexpansion";
    }

    @Override
    public String getDescription() {
        return "Generates a area around a already generated area";
    }

    @Override
    public int getRequiredParameterCount() {
        return 5;
    }

    @Override
    public void execute(CommandContainer container, String[] args) {
        if (args.length >= 5) {
            int type = StartExpansionSubCommand.getGenType(args[0]);
            FilePos center = StartExpansionSubCommand.getChunkPos(args[1], args[2], container.getPlayerPos());
            int minRadius = StartExpansionSubCommand.getNumber(args[3], 0);
            int maxRadius = StartExpansionSubCommand.getNumber(args[4], 0);
            int dimension = StartExpansionSubCommand.getDimension(container, StartExpansionSubCommand.getArg(args, 5));
            int postRule = StartExpansionSubCommand.getProcessRule(StartExpansionSubCommand.getArg(args, 6));
            if (!StartExpansionSubCommand.isDimensionValid(dimension)) {
                container.sendChatMessage("Dimension " + dimension + " is not Registered!");
                return;
            }
            long ringCount = StartExpansionSubCommand.getRingCount(minRadius, maxRadius, type == 1);
            if (ringCount > 2500000000L) {
                container.sendChatMessage("Expansion uses more then 2.5 Billion Chunks. That is to big. Please make it smaller. (Your Expansion Amount: " + ringCount + ")");
                return;
            }
            center = StartExpansionSubCommand.applySpawn(args[1], args[2], center, container.getWorldSpawn(dimension));
            PregenTask task = new PregenTask(4 + type, dimension, center.x, center.z, minRadius, maxRadius, postRule);
            if (container.onProcessStarted(task)) {
                container.sendChatMessage("Pregenerator already running. Adding Task to the TaskStorage");
                return;
            }
            container.getProcessor().startTask(task);
        } else {
            this.throwErrors(container, args.length);
        }
    }

    @Override
    public List<String> getAutoCompleteOption(String[] args, int argLayer, int commandIndex) {
        if (commandIndex == 0) {
            return StartExpansionSubCommand.getBestMatch(args, CompleterHelper.GEN_TYPE);
        }
        if (commandIndex == 1 || commandIndex == 2) {
            return StartExpansionSubCommand.getBestMatch(args, "0", "~");
        }
        if (commandIndex == 3 || commandIndex == 4) {
            if (args[argLayer].startsWith("b")) {
                return StartExpansionSubCommand.getBestMatch(args, CompleterHelper.GEN_RADIUS_BLOCK);
            }
            return StartExpansionSubCommand.getBestMatch(args, CompleterHelper.GEN_RADIUS_CHUNK);
        }
        if (commandIndex == 5) {
            return StartExpansionSubCommand.getBestMatch(args, CompleterHelper.DIMENSION);
        }
        if (commandIndex == 6) {
            return StartExpansionSubCommand.getBestMatch(args, CompleterHelper.GEN_PROCESS);
        }
        return new ArrayList<String>();
    }
}

