/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network.packets;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.base.api.network.PregenPacket;
import pregenerator.impl.client.ClientHandler;
import pregenerator.impl.client.trackerInfo.TrackerEntry;
import pregenerator.impl.tracking.ServerTracker;

public class TrackerAnswerPacket
extends PregenPacket {
    List<TrackerEntry> entries = new ArrayList<TrackerEntry>();
    boolean enabled = false;

    public TrackerAnswerPacket() {
    }

    public TrackerAnswerPacket(List<TrackerEntry> list) {
        this.entries.addAll(list);
        this.enabled = ServerTracker.INSTANCE.isEnabled();
    }

    @Override
    public void read(IReadableBuffer buffer) {
        this.enabled = buffer.readBoolean();
        if (!this.enabled) {
            return;
        }
        int amount = buffer.readByte();
        for (int i = 0; i < amount; ++i) {
            TrackerEntry entry = TrackerEntry.getByID(buffer.readByte());
            if (entry == null) continue;
            entry.readClient(buffer);
        }
    }

    @Override
    public void write(IWriteableBuffer buffer) {
        buffer.writeBoolean(this.enabled);
        if (!this.enabled) {
            return;
        }
        buffer.writeByte(this.entries.size());
        for (TrackerEntry entry : this.entries) {
            buffer.writeByte(entry.getID());
            entry.writeServer(buffer);
        }
    }

    @Override
    public void handle(EntityPlayer player) {
        this.handleClient();
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient() {
        ClientHandler.INSTANCE.tracker.running = this.enabled;
    }
}

