/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor.generator;

import java.text.DecimalFormat;
import java.util.EnumSet;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import pregenerator.ChunkPregenerator;
import pregenerator.ConfigManager;
import pregenerator.impl.misc.ChunkTimer;
import pregenerator.impl.misc.DeltaTimer;
import pregenerator.impl.misc.FileCounter;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.misc.ProcessResult;
import pregenerator.impl.processor.PrepaireProgress;
import pregenerator.impl.processor.generator.BenchmarkManager;
import pregenerator.impl.processor.generator.ChunkLogger;
import pregenerator.impl.processor.generator.ChunkProcess;
import pregenerator.impl.processor.generator.ChunkThread;
import pregenerator.impl.storage.GlobalListeners;
import pregenerator.impl.storage.PregenTask;
import pregenerator.impl.storage.TaskStorage;

public class ChunkProcessor {
    public static final DecimalFormat format = new DecimalFormat("#.#");
    public static ChunkProcessor INSTANCE = new ChunkProcessor();
    public static final int IDLE_MODE = 0;
    public static final int PROCESSING_MODE = 1;
    public static final int POST_PROCESSING_MODE = 2;
    int ticker = 0;
    DeltaTimer timer = new DeltaTimer();
    ChunkTimer chunkTimer = new ChunkTimer();
    FileCounter counter = new FileCounter();
    FileCounter memoryAverage = new FileCounter();
    int maxTimePerTick = 40;
    EnumSet<ChunkLogger> log = EnumSet.noneOf(ChunkLogger.class);
    public PrepaireProgress progress = new PrepaireProgress();
    Future<ChunkProcess> future = null;
    PregenTask task = null;
    ChunkProcess currentTask = null;
    int mode = 0;
    int processed = 0;
    int skipped = 0;
    int failed = 0;
    long startTime = -1L;
    boolean priority = false;
    boolean working = false;
    AtomicLong threadID = new AtomicLong(-1L);

    @SubscribeEvent
    public void onServerTickEvent(TickEvent.ServerTickEvent event) {
        block28: {
            if (this.isStopped() || this.task == null) {
                return;
            }
            if (this.shouldDisable()) {
                return;
            }
            if (this.future != null) {
                int newTime = (int)((System.currentTimeMillis() - this.startTime) / 1000L);
                if (this.ticker != newTime) {
                    this.ticker = newTime;
                    this.sendChatMessage("Prepaire Progress: " + this.progress.getCurrent() + " / " + this.progress.getMax());
                }
                if (this.future.isDone()) {
                    try {
                        this.currentTask = this.future.get();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.future = null;
                    if (this.currentTask != null) {
                        this.currentTask.setStartMemory();
                    }
                    this.progress.reset();
                    if (this.mode == 1) {
                        long total;
                        long l = total = this.currentTask != null ? (long)this.currentTask.getTotalWorkList() : 0L;
                        if (this.task.isPostProcessingTask()) {
                            this.sendChatMessage("Processing: " + total + " Chunks, with a possible " + total + " Chunks to Post Generate");
                        } else {
                            this.sendChatMessage("Processing: " + total + " Chunks");
                        }
                    }
                }
                return;
            }
            if (this.currentTask == null) {
                return;
            }
            if (event.phase == TickEvent.Phase.START) {
                this.timer.start();
            } else {
                long deltaTime = this.timer.averageDelta();
                if (deltaTime >= (long)this.maxTimePerTick) {
                    this.working = false;
                    return;
                }
                this.working = true;
                if (this.priority) {
                    deltaTime = 0L;
                }
                this.chunkTimer.startTime();
                this.currentTask.onTickStart();
                try {
                    while (deltaTime + this.timer.getDeltaTime() < (long)this.maxTimePerTick && this.currentTask.hasWork()) {
                        ProcessResult result = this.currentTask.tick();
                        if (this.currentTask.hasLight()) {
                            this.currentTask.checkLight();
                        }
                        ++this.processed;
                        this.counter.onChunkProcessed();
                        this.chunkTimer.onChunkFinished();
                        if (result == ProcessResult.CRASH) {
                            ++this.failed;
                            continue;
                        }
                        if (result != ProcessResult.MISSING) continue;
                        ++this.skipped;
                    }
                    int newTime = (int)((System.currentTimeMillis() - this.startTime) / 1000L);
                    if (newTime != this.ticker) {
                        this.ticker = newTime;
                        this.buildPreText(this.currentTask.getPosition());
                    }
                    if (!this.currentTask.hasWork()) {
                        if (this.currentTask.hasLight()) {
                            this.currentTask.checkLight();
                        } else {
                            this.onFinished();
                        }
                        break block28;
                    }
                    this.getCounter().onTickEnded();
                    this.timer.finishDeltaTime();
                    this.memoryAverage.add(this.freeMemory());
                    if (!ConfigManager.autoRestart || ConfigManager.restartMemory <= this.memoryAverage.getIntAverage()) break block28;
                    try {
                        for (WorldServer world : this.getServer().field_71305_c) {
                            if (world == null) continue;
                            boolean flag = world.field_73058_d;
                            world.field_73058_d = false;
                            world.func_73044_a(true, (IProgressUpdate)null);
                            world.field_73058_d = flag;
                        }
                        ThreadedFileIOBase.func_178779_a().func_75734_a();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ChunkPregenerator.LOGGER.info("Auto Restart Enabled (Can be disabled at own Risk)");
                    ChunkPregenerator.LOGGER.info("Average Free RAM [" + this.memoryAverage.getAverage() + " MB] is below the suggested amount [" + ConfigManager.restartMemory + " MB]");
                    ChunkPregenerator.LOGGER.info("Risk of world corruption because of low RAM");
                    ChunkPregenerator.LOGGER.info("Forcing Restart of the Game now to ensure enough RAM");
                    ChunkPregenerator.LOGGER.info("Pregenerator Progress is saved!");
                    ChunkPregenerator.LOGGER.info("All Worlds are saved");
                    ChunkPregenerator.LOGGER.info("Enforing Shutdown!");
                    FMLCommonHandler.instance().exitJava(0, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void skipChunks(int amount) {
        int current;
        if (this.currentTask == null) {
            return;
        }
        for (current = 0; current < amount && this.currentTask.hasWork(); ++current) {
            this.currentTask.tick();
            ++this.processed;
            ++this.skipped;
        }
        this.sendChatMessage(current + " Chunks were Skipped!");
    }

    public void startTask(PregenTask task) {
        this.task = task;
        this.mode = task.startTask(this.getServer());
        this.future = task.createTask(this.progress);
        this.startTime = System.currentTimeMillis();
        System.gc();
        this.threadID.incrementAndGet();
        ConfigManager.saveStart(true);
        Thread thread = new Thread((Runnable)new ChunkThread(this), "Chunk Processor Thread");
        thread.setDaemon(true);
        thread.start();
    }

    public void interruptTask(boolean notify) {
        this.interruptTask(notify, true);
    }

    public void interruptTask(boolean notify, boolean clearListeners) {
        this.interruptTask(notify, clearListeners, true);
    }

    public void interruptTask(boolean notify, boolean clearListeners, boolean cleanup) {
        if (this.mode == 0) {
            return;
        }
        this.mode = 0;
        this.cleanup(cleanup);
        if (notify) {
            this.sendChatMessage("Interrupted Current Pregeneration Task");
        }
        if (clearListeners) {
            GlobalListeners.INSTANCE.clearListeners();
        }
        if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
            BenchmarkManager.INSTANCE.interruptBenchmark();
        }
    }

    private void onFinished() {
        WorldServer world = this.currentTask.world;
        long processed = this.processed - this.skipped;
        long startTime = this.startTime;
        PregenTask task = this.currentTask.getTask();
        this.sendChatMessage("Pregenerated: " + processed + " Chunks in " + this.formatIntoTime(this.getWorkTime()) + ", " + this.skipped + " Chunks Skipped, " + this.failed + " Failed");
        TaskStorage storage = TaskStorage.getStorage();
        storage.finishTask(task);
        this.cleanup(true);
        if (task.isBenchmarkTask()) {
            BenchmarkManager.INSTANCE.addBenchmarkResult(task.getTaskSize(), processed, System.currentTimeMillis() - startTime, !task.isLargeTask(), (World)world);
        }
        if (storage.hasTasks()) {
            task = storage.getNextTask();
            this.sendChatMessage("Starting next task: " + task.toString());
            this.startTask(task);
        } else {
            if (BenchmarkManager.INSTANCE.isBenchmarkRunning()) {
                BenchmarkManager.INSTANCE.onBenchmarkFinished();
            }
            GlobalListeners.INSTANCE.clearListeners();
        }
    }

    private void cleanup(boolean cleanup) {
        if (this.currentTask != null) {
            this.currentTask.onRemove();
        }
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
        this.currentTask = null;
        this.mode = 0;
        this.failed = 0;
        this.processed = 0;
        this.skipped = 0;
        this.startTime = -1L;
        this.chunkTimer.cleanUp();
        this.counter.reset();
        this.timer.reset();
        if (cleanup) {
            try {
                for (WorldServer world : this.getServer().field_71305_c) {
                    if (world == null) continue;
                    boolean flag = world.field_73058_d;
                    world.field_73058_d = false;
                    world.func_73044_a(true, (IProgressUpdate)null);
                    world.field_73058_d = flag;
                }
                ThreadedFileIOBase.func_178779_a().func_75734_a();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ConfigManager.saveStart(false);
        }
        System.gc();
    }

    public void buildPreText(FilePos pos) {
        if (this.log.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (ChunkLogger log : this.log) {
            log.addPreLog(builder, this, pos);
            builder.append(" ");
        }
        this.sendChatMessage(builder.toString());
    }

    public void sendChatMessage(String text) {
        GlobalListeners.INSTANCE.sendChatMessage(text);
    }

    public void setMaxTime(int time) {
        this.maxTimePerTick = time;
        ConfigManager.msPerTick = time;
    }

    public int getMaxTime() {
        return this.maxTimePerTick;
    }

    public boolean isWorking() {
        return this.working;
    }

    public PregenTask getTask() {
        return this.currentTask != null ? this.currentTask.getTask() : null;
    }

    public ChunkProcess getCurrentTask() {
        return this.currentTask;
    }

    public boolean shouldDisable() {
        if (ConfigManager.playerDeactivation == -1) {
            return false;
        }
        return this.getServer().func_71233_x() >= ConfigManager.playerDeactivation;
    }

    public boolean isPriority() {
        return this.priority;
    }

    public void setPriority(boolean priority) {
        this.priority = priority;
    }

    public FileCounter getCounter() {
        return this.counter;
    }

    public boolean isStopped() {
        return this.mode == 0;
    }

    public boolean isRunning() {
        return this.mode != 0;
    }

    public boolean isProcessing() {
        return this.mode == 1;
    }

    public int getLoadedChunks() {
        return this.currentTask != null ? this.currentTask.getProvider().func_73152_e() : 0;
    }

    public MinecraftServer getServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    long getRamUsage() {
        long l = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        return l / 1024L / 1024L;
    }

    int freeMemory() {
        long max = Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory();
        long l = (Runtime.getRuntime().freeMemory() + max) / 1024L / 1024L;
        return (int)l;
    }

    public String getRunningTime() {
        return this.currentTask != null ? this.formatIntoTime(this.getWorkTime()) : "Not Running";
    }

    String formatIntoTime(long time) {
        int sec = (int)(time /= 1000L) % 60;
        int min = (int)(time /= 60L) % 60;
        int hour = (int)(time /= 60L) % 24;
        return String.format("%02d:%02d:%02d:%02d", time /= 24L, hour, min, sec);
    }

    public long getWorkTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public EnumSet<ChunkLogger> getLoggerInfo() {
        return this.log;
    }

    public int getCurrentProcessed() {
        return this.processed;
    }

    public int getMaxProcess() {
        return this.currentTask != null ? this.currentTask.getTotalWorkList() : 0;
    }

    public int getAverageCPUTime() {
        return this.timer.hasValues() ? (int)this.timer.getAverageDelta() : 0;
    }

    public int averageLagPerChunk() {
        return this.chunkTimer.hasValues() ? (int)this.chunkTimer.getAverage() : 0;
    }
}

