/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Arrays;
import meldexun.entityculling.CullingThread;
import meldexun.entityculling.EntityCullingConfig;
import meldexun.entityculling.EntityCullingWorldEventListener;
import meldexun.entityculling.GLHelper;
import meldexun.entityculling.ICullable;
import meldexun.entityculling.plugin.Hook;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL15;

public class EntityCullingContainer
extends DummyModContainer {
    public static final String MOD_ID = "entity_culling";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final CullingThread CULLING_THREAD = new CullingThread();
    public static int vertexBuffer;
    public static int indexBuffer;

    public EntityCullingContainer() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.name = "Entity Culling";
        meta.version = "4.1.5";
        meta.modId = MOD_ID;
        meta.authorList = Arrays.asList("Meldexun");
        meta.url = "https://github.com/Meldexun/EntityCulling";
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void onFMLConstructionEvent(FMLConstructionEvent event) {
        ConfigManager.sync((String)MOD_ID, (Config.Type)Config.Type.INSTANCE);
        CullingThread.updateBlacklists();
        GLHelper.init();
        EntityCullingContainer.generateCubeDisplayList();
        CULLING_THREAD.start();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MOD_ID)) {
            ConfigManager.sync((String)MOD_ID, (Config.Type)Config.Type.INSTANCE);
            CullingThread.updateBlacklists();
        }
    }

    @SubscribeEvent
    public void onWorldTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (EntityCullingConfig.debug && Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.func_82737_E() % 40L == 0L) {
                int i1 = (int)Arrays.stream(EntityCullingContainer.CULLING_THREAD.time).sum() / 1000 / 10;
                int i2 = Hook.getRenderer().entitiesRendered;
                int i3 = Hook.getRenderer().entitiesOcclusionCulled;
                int i4 = Hook.getRenderer().tileEntitiesRendered;
                int i5 = Hook.getRenderer().tileEntitiesOcclusionCulled;
                LOGGER.info("Culling Thread: {}\u00b5s, Entities Rendered: {}, Entities Culled: {}, TileEntities Rendered: {}, TileEntities Culled: {}", (Object)i1, (Object)i2, (Object)i3, (Object)i4, (Object)i5);
            }
            if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.func_82737_E() % 20L == 0L) {
                ICullable.deleteInvalidTileEntityQueries((World)Minecraft.func_71410_x().field_71441_e);
            }
        }
    }

    public static void generateCubeDisplayList() {
        FloatBuffer vertexByteBuffer = ByteBuffer.allocateDirect(96).order(ByteOrder.nativeOrder()).asFloatBuffer();
        vertexByteBuffer.put(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f});
        vertexByteBuffer.rewind();
        ByteBuffer indexByteBuffer = ByteBuffer.allocateDirect(14).order(ByteOrder.nativeOrder());
        indexByteBuffer.put(new byte[]{0, 4, 1, 5, 7, 4, 6, 0, 2, 1, 3, 7, 2, 6});
        indexByteBuffer.rewind();
        vertexBuffer = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)vertexBuffer);
        GL15.glBufferData((int)34962, (FloatBuffer)vertexByteBuffer, (int)35044);
        GL15.glBindBuffer((int)34962, (int)0);
        indexBuffer = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34963, (int)indexBuffer);
        GL15.glBufferData((int)34963, (ByteBuffer)indexByteBuffer, (int)35044);
        GL15.glBindBuffer((int)34963, (int)0);
    }

    @SubscribeEvent
    public void onWorldLoadEvent(WorldEvent.Load event) {
        if (event.getWorld().field_72995_K) {
            event.getWorld().func_72954_a((IWorldEventListener)new EntityCullingWorldEventListener());
        }
    }

    @SubscribeEvent
    public void onWorldUnloadEvent(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            for (Entity e : event.getWorld().field_72996_f) {
                ((ICullable)e).deleteQuery();
            }
            for (TileEntity te : event.getWorld().field_147482_g) {
                ((ICullable)te).deleteQuery();
            }
            ICullable.deleteTileEntityQueries();
        }
    }

    @SubscribeEvent
    public void onChunkUnloadEvent(ChunkEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            for (ClassInheritanceMultiMap entityMap : event.getChunk().func_177429_s()) {
                for (Entity e : entityMap) {
                    ((ICullable)e).deleteQuery();
                }
            }
            for (TileEntity te : event.getChunk().func_177434_r().values()) {
                ((ICullable)te).deleteQuery();
            }
        }
    }
}

