/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling;

import java.util.HashMap;
import java.util.Map;
import meldexun.entityculling.GLHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL15;

public interface ICullable {
    public static final Map<BlockPos, TileEntity> TILE_ENTITY_MAP = new HashMap<BlockPos, TileEntity>();

    public boolean isCulledFast();

    public void setCulledFast(boolean var1);

    public boolean isCulledSlow();

    public void setCulledSlow(boolean var1);

    public boolean isCulledShadowPass();

    public void setCulledShadowPass(boolean var1);

    public int getQuery();

    public void setQuery(int var1);

    public boolean isQueryInitialized();

    public void setQueryInitialized(boolean var1);

    public boolean isQueryResultDirty();

    public void setQueryResultDirty(boolean var1);

    default public boolean isVisible() {
        return !this.isCulledFast() || !this.isCulledSlow();
    }

    default public int initQuery() {
        if (!this.isQueryInitialized()) {
            this.setQuery(GLHelper.createQuery());
            GLHelper.beginQuery(this.getQuery());
            GLHelper.endQuery();
            if (this instanceof TileEntity) {
                BlockPos pos = ((TileEntity)this).func_174877_v();
                TileEntity te = TILE_ENTITY_MAP.get(pos);
                if (te != null) {
                    ((ICullable)te).deleteQuery();
                }
                TILE_ENTITY_MAP.put(pos, (TileEntity)this);
            }
            this.setQueryInitialized(true);
        }
        return this.getQuery();
    }

    default public void deleteQuery() {
        if (this.isQueryInitialized()) {
            GL15.glDeleteQueries((int)this.getQuery());
            this.setQuery(-1);
            this.setQueryInitialized(false);
        }
    }

    public static void deleteInvalidTileEntityQueries(World world) {
        for (Map.Entry<BlockPos, TileEntity> entry : TILE_ENTITY_MAP.entrySet()) {
            if (world.func_175625_s(entry.getKey()) == entry.getValue()) continue;
            ((ICullable)entry.getValue()).deleteQuery();
        }
    }

    public static void deleteTileEntityQueries() {
        for (TileEntity tileEntity : TILE_ENTITY_MAP.values()) {
            ((ICullable)tileEntity).deleteQuery();
        }
        TILE_ENTITY_MAP.clear();
    }
}

