/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.plugin;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import meldexun.entityculling.EntityCullingConfig;
import meldexun.entityculling.EntityCullingContainer;
import meldexun.entityculling.GLHelper;
import meldexun.entityculling.ICullable;
import meldexun.entityculling.ITileEntityBBCache;
import meldexun.entityculling.integration.CubicChunks;
import meldexun.entityculling.reflection.ReflectionField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderUtil;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.common.Loader;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;

public class EntityCullingRenderer {
    protected static final ReflectionField<Integer> FIELD_COUNT_ENTITIES_RENDERED = new ReflectionField(RenderGlobal.class, "field_72749_I", "countEntitiesRendered");
    protected static final ReflectionField<Framebuffer> FIELD_ENTITY_OUTLINE_FRAMEBUFFER = new ReflectionField(RenderGlobal.class, "field_175015_z", "entityOutlineFramebuffer");
    protected static final ReflectionField<ShaderGroup> FIELD_ENTITY_OUTLINE_SHADER = new ReflectionField(RenderGlobal.class, "field_174991_A", "entityOutlineShader");
    protected static final ReflectionField<Set<TileEntity>> FIELD_SET_TILE_ENTITIES = new ReflectionField(RenderGlobal.class, "field_181024_n", "setTileEntities");
    private static final ByteBuffer COLOR_MASK_BUFFER = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder());
    protected static final Random RAND = new Random();
    protected boolean renderingPrepared;
    protected Minecraft mc;
    protected float partialTicks;
    protected Entity renderViewEntity;
    protected double x;
    protected double y;
    protected double z;
    protected Frustum frustum;
    protected Framebuffer entityOutlineFramebuffer;
    protected ShaderGroup entityOutlineShader;
    protected List<Entity> entityListNormalPass1;
    protected List<Entity> entityListMultipassPass1;
    protected List<TileEntity> tileEntityListPass1;
    protected boolean entityOutlinesRendered = false;
    public int entitiesRendered;
    public int entitiesOcclusionCulled;
    public int tileEntitiesRendered;
    public int tileEntitiesOcclusionCulled;

    protected void preRenderEntities() {
        this.renderingPrepared = true;
        this.mc = Minecraft.func_71410_x();
        this.partialTicks = this.mc.func_184121_ak();
        this.renderViewEntity = this.mc.func_175606_aa();
        this.x = this.renderViewEntity.field_70142_S + (this.renderViewEntity.field_70165_t - this.renderViewEntity.field_70142_S) * (double)this.partialTicks;
        this.y = this.renderViewEntity.field_70137_T + (this.renderViewEntity.field_70163_u - this.renderViewEntity.field_70137_T) * (double)this.partialTicks;
        this.z = this.renderViewEntity.field_70136_U + (this.renderViewEntity.field_70161_v - this.renderViewEntity.field_70136_U) * (double)this.partialTicks;
        this.frustum = new Frustum();
        this.frustum.func_78547_a(this.x, this.y, this.z);
        this.entityOutlineFramebuffer = FIELD_ENTITY_OUTLINE_FRAMEBUFFER.get(this.mc.field_71438_f);
        this.entityOutlineShader = FIELD_ENTITY_OUTLINE_SHADER.get(this.mc.field_71438_f);
        this.entityListNormalPass1 = new ArrayList<Entity>(16);
        this.entityListMultipassPass1 = new ArrayList<Entity>(8);
        this.tileEntityListPass1 = new ArrayList<TileEntity>(16);
        this.entitiesRendered = 0;
        this.entitiesOcclusionCulled = 0;
        this.tileEntitiesRendered = 0;
        this.tileEntitiesOcclusionCulled = 0;
    }

    protected void postRenderEntities() {
        this.renderingPrepared = false;
        this.mc = null;
        this.partialTicks = 0.0f;
        this.renderViewEntity = null;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.frustum = null;
        this.entityOutlineFramebuffer = null;
        this.entityOutlineShader = null;
        this.entityListNormalPass1 = null;
        this.entityListMultipassPass1 = null;
        this.tileEntityListPass1 = null;
    }

    public boolean renderEntities() {
        if (!EntityCullingConfig.enabled) {
            return false;
        }
        int pass = MinecraftForgeClient.getRenderPass();
        if (!this.renderingPrepared) {
            this.preRenderEntities();
            this.updateEntityCullingState();
        }
        RenderManager renderManager = this.mc.func_175598_ae();
        if (pass == 0) {
            boolean isThirdPersonView = this.mc.field_71474_y.field_74320_O != 0;
            boolean isSleeping = this.renderViewEntity instanceof EntityLivingBase && ((EntityLivingBase)this.renderViewEntity).func_70608_bn();
            boolean firstPersonAndNotSleeping = !isThirdPersonView && !isSleeping;
            boolean spectatorAndOutlinesEnabled = this.mc.field_71439_g.func_175149_v() && this.mc.field_71474_y.field_178883_an.func_151470_d();
            int entitiesRendered = 0;
            ArrayList<Entity> multipassEntityList = new ArrayList<Entity>();
            ArrayList<Entity> outlineEntityList = new ArrayList<Entity>();
            for (RenderChunk renderChunk : RenderUtil.getRenderChunks()) {
                BlockPos chunkPos = renderChunk.func_178568_j();
                Chunk chunk = this.mc.field_71441_e.func_175726_f(chunkPos);
                ClassInheritanceMultiMap entityMap = !Loader.isModLoaded((String)"cubicchunks") ? chunk.func_177429_s()[chunkPos.func_177956_o() >> 4] : CubicChunks.getEntityList((World)this.mc.field_71441_e, renderChunk.func_178568_j());
                for (Entity entity : entityMap) {
                    Render render;
                    if (!entity.shouldRenderInPass(0) && !entity.shouldRenderInPass(1) || (render = renderManager.func_78713_a(entity)) == null || !render.func_177071_a(entity, (ICamera)this.frustum, this.x, this.y, this.z) && !entity.func_184215_y((Entity)this.mc.field_71439_g) || entity == this.renderViewEntity && firstPersonAndNotSleeping) continue;
                    boolean renderOutlines = entity.func_184202_aL() || spectatorAndOutlinesEnabled && entity instanceof EntityPlayer;
                    boolean entityWasRendered = false;
                    if (entity.shouldRenderInPass(0)) {
                        if (((ICullable)entity).isVisible()) {
                            renderManager.func_188388_a(entity, this.partialTicks, false);
                            if (render.func_188295_H_()) {
                                multipassEntityList.add(entity);
                            }
                            entityWasRendered = true;
                        }
                        if (renderOutlines) {
                            outlineEntityList.add(entity);
                            entityWasRendered = true;
                        }
                    }
                    if (entity.shouldRenderInPass(1) && ((ICullable)entity).isVisible()) {
                        this.entityListNormalPass1.add(entity);
                        if (render.func_188295_H_()) {
                            this.entityListMultipassPass1.add(entity);
                        }
                        entityWasRendered = true;
                    }
                    if (entityWasRendered) {
                        ++entitiesRendered;
                        ++this.entitiesRendered;
                        continue;
                    }
                    ++this.entitiesOcclusionCulled;
                }
            }
            for (Entity entity : multipassEntityList) {
                renderManager.func_188389_a(entity, this.partialTicks);
            }
            if (this.isRenderEntityOutlines() && (!outlineEntityList.isEmpty() || this.entityOutlinesRendered)) {
                this.mc.field_71441_e.field_72984_F.func_76318_c("entityOutlines");
                this.entityOutlineFramebuffer.func_147614_f();
                boolean bl = this.entityOutlinesRendered = !outlineEntityList.isEmpty();
                if (!outlineEntityList.isEmpty()) {
                    GlStateManager.func_179143_c((int)519);
                    GlStateManager.func_179106_n();
                    this.entityOutlineFramebuffer.func_147610_a(false);
                    RenderHelper.func_74518_a();
                    renderManager.func_178632_c(true);
                    for (Entity entity : outlineEntityList) {
                        renderManager.func_188388_a(entity, this.partialTicks, false);
                    }
                    renderManager.func_178632_c(false);
                    RenderHelper.func_74519_b();
                    GlStateManager.func_179132_a((boolean)false);
                    this.entityOutlineShader.func_148018_a(this.partialTicks);
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179127_m();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179142_g();
                    GlStateManager.func_179143_c((int)515);
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179141_d();
                }
                this.mc.func_147110_a().func_147610_a(false);
            }
            FIELD_COUNT_ENTITIES_RENDERED.set(this.mc.field_71438_f, FIELD_COUNT_ENTITIES_RENDERED.get(this.mc.field_71438_f) + entitiesRendered);
        } else if (pass == 1) {
            for (Entity entity : this.entityListNormalPass1) {
                renderManager.func_188388_a(entity, this.partialTicks, false);
            }
            for (Entity entity : this.entityListMultipassPass1) {
                renderManager.func_188389_a(entity, this.partialTicks);
            }
        }
        return true;
    }

    protected boolean isRenderEntityOutlines() {
        return this.entityOutlineFramebuffer != null && this.entityOutlineShader != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renderTileEntities() {
        if (!EntityCullingConfig.enabled) {
            return false;
        }
        int pass = MinecraftForgeClient.getRenderPass();
        if (pass == 0) {
            for (Object renderChunk : RenderUtil.getRenderChunks()) {
                List tileEntities = renderChunk.field_178590_b.func_178485_b();
                if (tileEntities.isEmpty() || !this.mc.field_71441_e.func_175668_a(renderChunk.func_178568_j(), false)) continue;
                for (TileEntity tileEntity : tileEntities) {
                    if (!tileEntity.shouldRenderInPass(0) && !tileEntity.shouldRenderInPass(1) || TileEntityRendererDispatcher.field_147556_a.func_147547_b(tileEntity) == null || tileEntity.func_145835_a(this.x, this.y, this.z) > tileEntity.func_145833_n() || !this.frustum.func_78546_a(((ITileEntityBBCache)tileEntity).getCachedAABB()) || !this.mc.field_71441_e.func_175668_a(tileEntity.func_174877_v(), false)) continue;
                    if (!((ICullable)tileEntity).isVisible()) {
                        ++this.tileEntitiesOcclusionCulled;
                        continue;
                    }
                    ++this.tileEntitiesRendered;
                    if (tileEntity.shouldRenderInPass(0)) {
                        TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEntity, this.partialTicks, -1);
                    }
                    if (!tileEntity.shouldRenderInPass(1)) continue;
                    this.tileEntityListPass1.add(tileEntity);
                }
            }
            Set<TileEntity> setTileEntities = FIELD_SET_TILE_ENTITIES.get(this.mc.field_71438_f);
            if (!setTileEntities.isEmpty()) {
                Object renderChunk;
                renderChunk = setTileEntities;
                synchronized (renderChunk) {
                    for (TileEntity tileEntity : setTileEntities) {
                        if (!tileEntity.shouldRenderInPass(0) && !tileEntity.shouldRenderInPass(1) || TileEntityRendererDispatcher.field_147556_a.func_147547_b(tileEntity) == null || tileEntity.func_145835_a(this.x, this.y, this.z) > tileEntity.func_145833_n() || !this.frustum.func_78546_a(((ITileEntityBBCache)tileEntity).getCachedAABB()) || !this.mc.field_71441_e.func_175668_a(tileEntity.func_174877_v(), false)) continue;
                        if (!((ICullable)tileEntity).isVisible()) {
                            ++this.tileEntitiesOcclusionCulled;
                            continue;
                        }
                        ++this.tileEntitiesRendered;
                        if (tileEntity.shouldRenderInPass(0)) {
                            TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEntity, this.partialTicks, -1);
                        }
                        if (!tileEntity.shouldRenderInPass(1)) continue;
                        this.tileEntityListPass1.add(tileEntity);
                    }
                }
            }
        } else if (pass == 1) {
            for (TileEntity tileEntity : this.tileEntityListPass1) {
                TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEntity, this.partialTicks, -1);
            }
        }
        if (pass == 1) {
            this.postRenderEntities();
        }
        return true;
    }

    protected void updateEntityCullingState() {
        int query;
        AxisAlignedBB aabb;
        if (!EntityCullingConfig.betaFeatures) {
            return;
        }
        double updateChance = MathHelper.func_151237_a((double)(10.0 / (double)Minecraft.func_175610_ah()), (double)1.0E-7, (double)0.5);
        GL11.glGetBoolean((int)3107, (ByteBuffer)COLOR_MASK_BUFFER);
        boolean depthMaskEnabled = GL11.glGetBoolean((int)2930);
        boolean depthTestEnabled = GL11.glGetBoolean((int)2929);
        boolean texture2dEnabled = GL11.glGetBoolean((int)3553);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-this.x), (double)(-this.y), (double)(-this.z));
        GL15.glBindBuffer((int)34962, (int)EntityCullingContainer.vertexBuffer);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
        GL15.glBindBuffer((int)34963, (int)EntityCullingContainer.indexBuffer);
        for (Entity entity : this.mc.field_71441_e.field_72996_f) {
            aabb = entity.func_184177_bl();
            if (!((ICullable)entity).isCulledFast() || !this.frustum.func_78548_b(aabb.field_72340_a - 0.5, aabb.field_72338_b - 0.5, aabb.field_72339_c - 0.5, aabb.field_72336_d + 0.5, aabb.field_72337_e + 0.5, aabb.field_72334_f + 0.5) || this.mc.field_71439_g.func_70068_e(entity) < 16.0) {
                ((ICullable)entity).setCulledSlow(false);
                ((ICullable)entity).setQueryResultDirty(false);
                continue;
            }
            query = ((ICullable)entity).initQuery();
            if (((ICullable)entity).isQueryResultDirty()) {
                ((ICullable)entity).setCulledSlow(GL15.glGetQueryObjecti((int)query, (int)34918) == 0);
            }
            if (RAND.nextDouble() < updateChance) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)(aabb.field_72340_a - 0.5), (double)(aabb.field_72338_b - 0.5), (double)(aabb.field_72339_c - 0.5));
                GL11.glScaled((double)(aabb.field_72336_d - aabb.field_72340_a + 1.0), (double)(aabb.field_72337_e - aabb.field_72338_b + 1.0), (double)(aabb.field_72334_f - aabb.field_72339_c + 1.0));
                GLHelper.beginQuery(query);
                GL11.glDrawElements((int)5, (int)14, (int)5121, (long)0L);
                GLHelper.endQuery();
                GL11.glPopMatrix();
                ((ICullable)entity).setQueryResultDirty(true);
                continue;
            }
            ((ICullable)entity).setQueryResultDirty(false);
        }
        for (TileEntity tileEntity : this.mc.field_71441_e.field_147482_g) {
            aabb = ((ITileEntityBBCache)tileEntity).getCachedAABB();
            if (!((ICullable)tileEntity).isCulledFast() || !this.frustum.func_78548_b(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f) || this.mc.field_71439_g.func_174831_c(tileEntity.func_174877_v()) < 16.0) {
                ((ICullable)tileEntity).setCulledSlow(false);
                ((ICullable)tileEntity).setQueryResultDirty(false);
                continue;
            }
            query = ((ICullable)tileEntity).initQuery();
            if (((ICullable)tileEntity).isQueryResultDirty()) {
                ((ICullable)tileEntity).setCulledSlow(GL15.glGetQueryObjecti((int)query, (int)34918) == 0);
            }
            if (RAND.nextDouble() < updateChance) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)aabb.field_72340_a, (double)aabb.field_72338_b, (double)aabb.field_72339_c);
                GL11.glScaled((double)(aabb.field_72336_d - aabb.field_72340_a), (double)(aabb.field_72337_e - aabb.field_72338_b), (double)(aabb.field_72334_f - aabb.field_72339_c));
                GLHelper.beginQuery(query);
                GL11.glDrawElements((int)5, (int)14, (int)5121, (long)0L);
                GLHelper.endQuery();
                GL11.glPopMatrix();
                ((ICullable)tileEntity).setQueryResultDirty(true);
                continue;
            }
            ((ICullable)tileEntity).setQueryResultDirty(false);
        }
        GL15.glBindBuffer((int)34963, (int)0);
        GL20.glDisableVertexAttribArray((int)0);
        GL15.glBindBuffer((int)34962, (int)0);
        GL11.glPopMatrix();
        if (texture2dEnabled) {
            GL11.glEnable((int)3553);
        } else {
            GL11.glDisable((int)3553);
        }
        if (depthTestEnabled) {
            GL11.glEnable((int)2929);
        } else {
            GL11.glDisable((int)2929);
        }
        GL11.glDepthMask((boolean)depthMaskEnabled);
        GL11.glColorMask((COLOR_MASK_BUFFER.get(0) == 1 ? 1 : 0) != 0, (COLOR_MASK_BUFFER.get(1) == 1 ? 1 : 0) != 0, (COLOR_MASK_BUFFER.get(2) == 1 ? 1 : 0) != 0, (COLOR_MASK_BUFFER.get(3) == 1 ? 1 : 0) != 0);
    }
}

