/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import meldexun.entityculling.plugin.transformer.ClassTransformer;
import meldexun.entityculling.plugin.transformer.FieldTransformer;
import meldexun.entityculling.plugin.transformer.MethodTransformer;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EntityCullingTransformer
implements IClassTransformer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, List<ClassTransformer>> CLASS_TRANSFORMERS = new HashMap<String, List<ClassTransformer>>();
    private static final Map<String, Map<String, List<FieldTransformer>>> FIELD_TRANSFORMERS = new HashMap<String, Map<String, List<FieldTransformer>>>();
    private static final Map<String, Map<String, List<MethodTransformer>>> METHOD_TRANSFORMERS = new HashMap<String, Map<String, List<MethodTransformer>>>();
    public static final boolean IS_OPTIFINE_DETECTED;
    public static final boolean IS_WORKSPACE_ENVIRONMENT;

    public static void registerClassTransformer(ClassTransformer classTransformer) {
        CLASS_TRANSFORMERS.computeIfAbsent(classTransformer.transformedClassName, key -> new ArrayList()).add(classTransformer);
    }

    public static void registerFieldTransformer(FieldTransformer fieldTransformer) {
        Map map = FIELD_TRANSFORMERS.computeIfAbsent(fieldTransformer.transformedClassName, key -> new HashMap());
        map.computeIfAbsent(fieldTransformer.fieldName, key -> new ArrayList()).add(fieldTransformer);
        map.computeIfAbsent(fieldTransformer.transformedFieldName, key -> new ArrayList()).add(fieldTransformer);
    }

    public static void registerMethodTransformer(MethodTransformer methodTransformer) {
        Map map = METHOD_TRANSFORMERS.computeIfAbsent(methodTransformer.transformedClassName, key -> new HashMap());
        map.computeIfAbsent(methodTransformer.methodName, key -> new ArrayList()).add(methodTransformer);
        map.computeIfAbsent(methodTransformer.transformedMethodName, key -> new ArrayList()).add(methodTransformer);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        List<ClassTransformer> classTransformers = CLASS_TRANSFORMERS.get(transformedName);
        Map<String, List<FieldTransformer>> fieldTransformerMap = FIELD_TRANSFORMERS.get(transformedName);
        Map<String, List<MethodTransformer>> methodTransformerMap = METHOD_TRANSFORMERS.get(transformedName);
        if (!(classTransformers != null && !classTransformers.isEmpty() || fieldTransformerMap != null && !fieldTransformerMap.isEmpty() || methodTransformerMap != null && !methodTransformerMap.isEmpty())) {
            return basicClass;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        if (classTransformers != null) {
            for (ClassTransformer classTransformer : classTransformers) {
                classTransformer.transformer.accept(classNode);
            }
        }
        if (fieldTransformerMap != null) {
            for (FieldNode fieldNode : classNode.fields) {
                List<FieldTransformer> fieldTransformers = fieldTransformerMap.get(fieldNode.name);
                if (fieldTransformers == null || fieldTransformers.isEmpty()) continue;
                for (FieldTransformer fieldTransformer : fieldTransformers) {
                    if (!fieldTransformer.canApplyTransform(fieldNode)) continue;
                    fieldTransformer.transformer.accept(fieldNode);
                }
            }
        }
        if (methodTransformerMap != null) {
            for (MethodNode methodNode : classNode.methods) {
                List<MethodTransformer> methodTransformers = methodTransformerMap.get(methodNode.name);
                if (methodTransformers == null || methodTransformers.isEmpty()) continue;
                for (MethodTransformer methodTransformer : methodTransformers) {
                    if (!methodTransformer.canApplyTransform(methodNode)) continue;
                    methodTransformer.transformer.accept(methodNode);
                }
            }
        }
        ClassWriter classWriter = new ClassWriter(3);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    public static void printMethodInstructions(MethodNode method) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (AbstractInsnNode instruction : method.instructions.toArray()) {
            if (i >= 0) {
                sb.append("\n" + i + " " + EntityCullingTransformer.insnToString(instruction));
            }
            ++i;
        }
        LOGGER.info((CharSequence)sb);
    }

    public static String insnToString(AbstractInsnNode insn) {
        StringBuilder sb = new StringBuilder(insn.getOpcode() + " " + insn.getClass().getSimpleName() + "\t");
        if (insn instanceof MethodInsnNode) {
            sb.append(" " + ((MethodInsnNode)insn).owner);
            sb.append(" " + ((MethodInsnNode)insn).name);
            sb.append(" " + ((MethodInsnNode)insn).desc);
        } else if (insn instanceof VarInsnNode) {
            sb.append(" " + ((VarInsnNode)insn).var);
        } else if (insn instanceof FieldInsnNode) {
            sb.append(" " + ((FieldInsnNode)insn).owner);
            sb.append(" " + ((FieldInsnNode)insn).name);
            sb.append(" " + ((FieldInsnNode)insn).desc);
        } else if (insn instanceof JumpInsnNode) {
            sb.append(" " + ((JumpInsnNode)insn).label.getLabel());
        } else if (insn instanceof LabelNode) {
            sb.append(" " + ((LabelNode)insn).getLabel());
        } else if (insn instanceof FrameNode) {
            sb.append(" " + ((FrameNode)insn).local);
            sb.append(" " + ((FrameNode)insn).stack);
        }
        return sb.toString();
    }

    static {
        boolean flag = false;
        try {
            Class.forName("optifine.OptiFineClassTransformer", false, EntityCullingTransformer.class.getClassLoader());
            flag = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        IS_OPTIFINE_DETECTED = flag;
        IS_WORKSPACE_ENVIRONMENT = !EntityCullingTransformer.class.getResource("").getProtocol().equals("jar");
        EntityCullingTransformer.registerClassTransformer(new ClassTransformer("ve", "net.minecraft.entity.Entity", classNode -> {
            classNode.fields.add(new FieldNode(2, "isCulledFast", "Z", null, (Object)false));
            classNode.fields.add(new FieldNode(2, "isCulledSlow", "Z", null, (Object)false));
            classNode.fields.add(new FieldNode(2, "isCulledShadowPass", "Z", null, (Object)false));
            classNode.fields.add(new FieldNode(2, "query", "I", null, (Object)-1));
            classNode.fields.add(new FieldNode(2, "queryInitialized", "Z", null, (Object)false));
            classNode.fields.add(new FieldNode(2, "queryResultDirty", "Z", null, (Object)false));
            classNode.interfaces.add("meldexun/entityculling/ICullable");
            MethodNode methodIsCulledFast = new MethodNode(1, "isCulledFast", "()Z", null, null);
            methodIsCulledFast.instructions.clear();
            methodIsCulledFast.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodIsCulledFast.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/Entity", "isCulledFast", "Z"));
            methodIsCulledFast.instructions.add((AbstractInsnNode)new InsnNode(172));
            classNode.methods.add(methodIsCulledFast);
            MethodNode methodSetCulledFast = new MethodNode(1, "setCulledFast", "(Z)V", null, null);
            methodSetCulledFast.instructions.clear();
            methodSetCulledFast.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodSetCulledFast.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
            methodSetCulledFast.instructions.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/entity/Entity", "isCulledFast", "Z"));
            methodSetCulledFast.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(methodSetCulledFast);
            MethodNode methodIsCulledSlow = new MethodNode(1, "isCulledSlow", "()Z", null, null);
            methodIsCulledSlow.instructions.clear();
            methodIsCulledSlow.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodIsCulledSlow.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/Entity", "isCulledSlow", "Z"));
            methodIsCulledSlow.instructions.add((AbstractInsnNode)new InsnNode(172));
            classNode.methods.add(methodIsCulledSlow);
            MethodNode methodSetCulledSlow = new MethodNode(1, "setCulledSlow", "(Z)V", null, null);
            methodSetCulledSlow.instructions.clear();
            methodSetCulledSlow.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodSetCulledSlow.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
            methodSetCulledSlow.instructions.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/entity/Entity", "isCulledSlow", "Z"));
            methodSetCulledSlow.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(methodSetCulledSlow);
            MethodNode methodIsCulledShadowPass = new MethodNode(1, "isCulledShadowPass", "()Z", null, null);
            methodIsCulledShadowPass.instructions.clear();
            methodIsCulledShadowPass.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodIsCulledShadowPass.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/Entity", "isCulledShadowPass", "Z"));
            methodIsCulledShadowPass.instructions.add((AbstractInsnNode)new InsnNode(172));
            classNode.methods.add(methodIsCulledShadowPass);
            MethodNode methodSetCulledShadowPass = new MethodNode(1, "setCulledShadowPass", "(Z)V", null, null);
            methodSetCulledShadowPass.instructions.clear();
            methodSetCulledShadowPass.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodSetCulledShadowPass.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
            methodSetCulledShadowPass.instructions.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/entity/Entity", "isCulledShadowPass", "Z"));
            methodSetCulledShadowPass.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(methodSetCulledShadowPass);
            MethodNode methodGetQuery = new MethodNode(1, "getQuery", "()I", null, null);
            methodGetQuery.instructions.clear();
            methodGetQuery.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodGetQuery.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/Entity", "query", "I"));
            methodGetQuery.instructions.add((AbstractInsnNode)new InsnNode(172));
            classNode.methods.add(methodGetQuery);
            MethodNode methodSetQuery = new MethodNode(1, "setQuery", "(I)V", null, null);
            methodSetQuery.instructions.clear();
            methodSetQuery.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodSetQuery.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
            methodSetQuery.instructions.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/entity/Entity", "query", "I"));
            methodSetQuery.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(methodSetQuery);
            MethodNode methodIsQueryInitialized = new MethodNode(1, "isQueryInitialized", "()Z", null, null);
            methodIsQueryInitialized.instructions.clear();
            methodIsQueryInitialized.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodIsQueryInitialized.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/Entity", "queryInitialized", "Z"));
            methodIsQueryInitialized.instructions.add((AbstractInsnNode)new InsnNode(172));
            classNode.methods.add(methodIsQueryInitialized);
            MethodNode methodSetQueryInitialized = new MethodNode(1, "setQueryInitialized", "(Z)V", null, null);
            methodSetQueryInitialized.instructions.clear();
            methodSetQueryInitialized.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodSetQueryInitialized.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
            methodSetQueryInitialized.instructions.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/entity/Entity", "queryInitialized", "Z"));
            methodSetQueryInitialized.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(methodSetQueryInitialized);
            MethodNode methodIsQueryResultUpToDate = new MethodNode(1, "isQueryResultDirty", "()Z", null, null);
            methodIsQueryResultUpToDate.instructions.clear();
            methodIsQueryResultUpToDate.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodIsQueryResultUpToDate.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/Entity", "queryResultDirty", "Z"));
            methodIsQueryResultUpToDate.instructions.add((AbstractInsnNode)new InsnNode(172));
            classNode.methods.add(methodIsQueryResultUpToDate);
            MethodNode methodSetQueryResultUpToDate = new MethodNode(1, "setQueryResultDirty", "(Z)V", null, null);
            methodSetQueryResultUpToDate.instructions.clear();
            methodSetQueryResultUpToDate.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodSetQueryResultUpToDate.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
            methodSetQueryResultUpToDate.instructions.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/entity/Entity", "queryResultDirty", "Z"));
            methodSetQueryResultUpToDate.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(methodSetQueryResultUpToDate);
        }));
        EntityCullingTransformer.registerClassTransformer(new ClassTransformer("avh", "net.minecraft.tileentity.TileEntity", classNode -> {
            classNode.fields.add(new FieldNode(2, "isCulledFast", "Z", null, (Object)false));
            classNode.fields.add(new FieldNode(2, "isCulledSlow", "Z", null, (Object)false));
            classNode.fields.add(new FieldNode(2, "isCulledShadowPass", "Z", null, (Object)false));
            classNode.fields.add(new FieldNode(2, "query", "I", null, (Object)-1));
            classNode.fields.add(new FieldNode(2, "queryInitialized", "Z", null, (Object)false));
            classNode.fields.add(new FieldNode(2, "queryResultDirty", "Z", null, (Object)false));
            classNode.interfaces.add("meldexun/entityculling/ICullable");
            MethodNode methodIsCulledFast = new MethodNode(1, "isCulledFast", "()Z", null, null);
            methodIsCulledFast.instructions.clear();
            methodIsCulledFast.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodIsCulledFast.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/tileentity/TileEntity", "isCulledFast", "Z"));
            methodIsCulledFast.instructions.add((AbstractInsnNode)new InsnNode(172));
            classNode.methods.add(methodIsCulledFast);
            MethodNode methodSetCulledFast = new MethodNode(1, "setCulledFast", "(Z)V", null, null);
            methodSetCulledFast.instructions.clear();
            methodSetCulledFast.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodSetCulledFast.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
            methodSetCulledFast.instructions.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/tileentity/TileEntity", "isCulledFast", "Z"));
            methodSetCulledFast.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(methodSetCulledFast);
            MethodNode methodIsCulledSlow = new MethodNode(1, "isCulledSlow", "()Z", null, null);
            methodIsCulledSlow.instructions.clear();
            methodIsCulledSlow.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodIsCulledSlow.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/tileentity/TileEntity", "isCulledSlow", "Z"));
            methodIsCulledSlow.instructions.add((AbstractInsnNode)new InsnNode(172));
            classNode.methods.add(methodIsCulledSlow);
            MethodNode methodSetCulledSlow = new MethodNode(1, "setCulledSlow", "(Z)V", null, null);
            methodSetCulledSlow.instructions.clear();
            methodSetCulledSlow.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodSetCulledSlow.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
            methodSetCulledSlow.instructions.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/tileentity/TileEntity", "isCulledSlow", "Z"));
            methodSetCulledSlow.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(methodSetCulledSlow);
            MethodNode methodIsCulledShadowPass = new MethodNode(1, "isCulledShadowPass", "()Z", null, null);
            methodIsCulledShadowPass.instructions.clear();
            methodIsCulledShadowPass.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodIsCulledShadowPass.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/tileentity/TileEntity", "isCulledShadowPass", "Z"));
            methodIsCulledShadowPass.instructions.add((AbstractInsnNode)new InsnNode(172));
            classNode.methods.add(methodIsCulledShadowPass);
            MethodNode methodSetCulledShadowPass = new MethodNode(1, "setCulledShadowPass", "(Z)V", null, null);
            methodSetCulledShadowPass.instructions.clear();
            methodSetCulledShadowPass.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodSetCulledShadowPass.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
            methodSetCulledShadowPass.instructions.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/tileentity/TileEntity", "isCulledShadowPass", "Z"));
            methodSetCulledShadowPass.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(methodSetCulledShadowPass);
            MethodNode methodGetQuery = new MethodNode(1, "getQuery", "()I", null, null);
            methodGetQuery.instructions.clear();
            methodGetQuery.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodGetQuery.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/tileentity/TileEntity", "query", "I"));
            methodGetQuery.instructions.add((AbstractInsnNode)new InsnNode(172));
            classNode.methods.add(methodGetQuery);
            MethodNode methodSetQuery = new MethodNode(1, "setQuery", "(I)V", null, null);
            methodSetQuery.instructions.clear();
            methodSetQuery.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodSetQuery.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
            methodSetQuery.instructions.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/tileentity/TileEntity", "query", "I"));
            methodSetQuery.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(methodSetQuery);
            MethodNode methodIsQueryInitialized = new MethodNode(1, "isQueryInitialized", "()Z", null, null);
            methodIsQueryInitialized.instructions.clear();
            methodIsQueryInitialized.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodIsQueryInitialized.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/tileentity/TileEntity", "queryInitialized", "Z"));
            methodIsQueryInitialized.instructions.add((AbstractInsnNode)new InsnNode(172));
            classNode.methods.add(methodIsQueryInitialized);
            MethodNode methodSetQueryInitialized = new MethodNode(1, "setQueryInitialized", "(Z)V", null, null);
            methodSetQueryInitialized.instructions.clear();
            methodSetQueryInitialized.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodSetQueryInitialized.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
            methodSetQueryInitialized.instructions.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/tileentity/TileEntity", "queryInitialized", "Z"));
            methodSetQueryInitialized.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(methodSetQueryInitialized);
            MethodNode methodIsQueryResultUpToDate = new MethodNode(1, "isQueryResultDirty", "()Z", null, null);
            methodIsQueryResultUpToDate.instructions.clear();
            methodIsQueryResultUpToDate.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodIsQueryResultUpToDate.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/tileentity/TileEntity", "queryResultDirty", "Z"));
            methodIsQueryResultUpToDate.instructions.add((AbstractInsnNode)new InsnNode(172));
            classNode.methods.add(methodIsQueryResultUpToDate);
            MethodNode methodSetQueryResultUpToDate = new MethodNode(1, "setQueryResultDirty", "(Z)V", null, null);
            methodSetQueryResultUpToDate.instructions.clear();
            methodSetQueryResultUpToDate.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodSetQueryResultUpToDate.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
            methodSetQueryResultUpToDate.instructions.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/tileentity/TileEntity", "queryResultDirty", "Z"));
            methodSetQueryResultUpToDate.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(methodSetQueryResultUpToDate);
            classNode.fields.add(new FieldNode(2, "prevAABB", "Lnet/minecraft/util/math/AxisAlignedBB;", null, null));
            classNode.fields.add(new FieldNode(2, "prevPos", "Lnet/minecraft/util/math/BlockPos;", null, null));
            classNode.fields.add(new FieldNode(2, "prevState", "Lnet/minecraft/block/Block;", null, null));
            classNode.interfaces.add("meldexun/entityculling/ITileEntityBBCache");
            MethodNode methodGetPrevAABB = new MethodNode(1, "getPrevAABB", "()Lnet/minecraft/util/math/AxisAlignedBB;", null, null);
            methodGetPrevAABB.instructions.clear();
            methodGetPrevAABB.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodGetPrevAABB.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/tileentity/TileEntity", "prevAABB", "Lnet/minecraft/util/math/AxisAlignedBB;"));
            methodGetPrevAABB.instructions.add((AbstractInsnNode)new InsnNode(176));
            classNode.methods.add(methodGetPrevAABB);
            MethodNode methodSetPrevAABB = new MethodNode(1, "setPrevAABB", "(Lnet/minecraft/util/math/AxisAlignedBB;)V", null, null);
            methodSetPrevAABB.instructions.clear();
            methodSetPrevAABB.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodSetPrevAABB.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            methodSetPrevAABB.instructions.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/tileentity/TileEntity", "prevAABB", "Lnet/minecraft/util/math/AxisAlignedBB;"));
            methodSetPrevAABB.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(methodSetPrevAABB);
            MethodNode methodGetPrevPos = new MethodNode(1, "getPrevPos", "()Lnet/minecraft/util/math/BlockPos;", null, null);
            methodGetPrevPos.instructions.clear();
            methodGetPrevPos.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodGetPrevPos.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/tileentity/TileEntity", "prevPos", "Lnet/minecraft/util/math/BlockPos;"));
            methodGetPrevPos.instructions.add((AbstractInsnNode)new InsnNode(176));
            classNode.methods.add(methodGetPrevPos);
            MethodNode methodSetPrevPos = new MethodNode(1, "setPrevPos", "(Lnet/minecraft/util/math/BlockPos;)V", null, null);
            methodSetPrevPos.instructions.clear();
            methodSetPrevPos.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodSetPrevPos.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            methodSetPrevPos.instructions.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/tileentity/TileEntity", "prevPos", "Lnet/minecraft/util/math/BlockPos;"));
            methodSetPrevPos.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(methodSetPrevPos);
            MethodNode methodGetPrevState = new MethodNode(1, "getPrevState", "()Lnet/minecraft/block/Block;", null, null);
            methodGetPrevState.instructions.clear();
            methodGetPrevState.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodGetPrevState.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/tileentity/TileEntity", "prevState", "Lnet/minecraft/block/Block;"));
            methodGetPrevState.instructions.add((AbstractInsnNode)new InsnNode(176));
            classNode.methods.add(methodGetPrevState);
            MethodNode methodSetPrevState = new MethodNode(1, "setPrevState", "(Lnet/minecraft/block/Block;)V", null, null);
            methodSetPrevState.instructions.clear();
            methodSetPrevState.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodSetPrevState.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            methodSetPrevState.instructions.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/tileentity/TileEntity", "prevState", "Lnet/minecraft/block/Block;"));
            methodSetPrevState.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(methodSetPrevState);
        }));
        if (!IS_OPTIFINE_DETECTED) {
            EntityCullingTransformer.registerMethodTransformer(new MethodTransformer("buw", "net.minecraft.client.renderer.RenderGlobal", "a", "renderEntities", "(Lvg;Lbxy;F)V", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/client/renderer/culling/ICamera;F)V", method -> {
                AbstractInsnNode targetNode1 = method.instructions.get(297);
                AbstractInsnNode popNode1 = method.instructions.get(691);
                AbstractInsnNode targetNode2 = method.instructions.get(706);
                AbstractInsnNode popNode2 = method.instructions.get(835);
                method.instructions.insertBefore(targetNode1, (AbstractInsnNode)new MethodInsnNode(184, "meldexun/entityculling/plugin/Hook", "renderEntities", "()Z", false));
                method.instructions.insertBefore(targetNode1, (AbstractInsnNode)new JumpInsnNode(154, (LabelNode)popNode1));
                method.instructions.insertBefore(targetNode2, (AbstractInsnNode)new MethodInsnNode(184, "meldexun/entityculling/plugin/Hook", "renderTileEntities", "()Z", false));
                method.instructions.insertBefore(targetNode2, (AbstractInsnNode)new JumpInsnNode(154, (LabelNode)popNode2));
            }));
        } else {
            EntityCullingTransformer.registerMethodTransformer(new MethodTransformer("buw", "net.minecraft.client.renderer.RenderGlobal", "a", "renderEntities", "(Lvg;Lbxy;F)V", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/client/renderer/culling/ICamera;F)V", method -> {
                AbstractInsnNode targetNode1 = method.instructions.get(374);
                AbstractInsnNode popNode1 = method.instructions.get(1039);
                AbstractInsnNode targetNode2 = method.instructions.get(1074);
                AbstractInsnNode popNode2 = method.instructions.get(1269);
                method.instructions.insertBefore(targetNode1, (AbstractInsnNode)new MethodInsnNode(184, "meldexun/entityculling/plugin/Hook", "renderEntities", "()Z", false));
                method.instructions.insertBefore(targetNode1, (AbstractInsnNode)new JumpInsnNode(154, (LabelNode)popNode1));
                method.instructions.insertBefore(targetNode2, (AbstractInsnNode)new MethodInsnNode(184, "meldexun/entityculling/plugin/Hook", "renderTileEntities", "()Z", false));
                method.instructions.insertBefore(targetNode2, (AbstractInsnNode)new JumpInsnNode(154, (LabelNode)popNode2));
            }));
            EntityCullingTransformer.registerMethodTransformer(new MethodTransformer("buw", "net.minecraft.client.renderer.RenderGlobal", "a", "setupTerrain", "(Lvg;DLbxy;IZ)V", "(Lnet/minecraft/entity/Entity;DLnet/minecraft/client/renderer/culling/ICamera;IZ)V", method -> {
                AbstractInsnNode targetNode1 = method.instructions.get(558);
                AbstractInsnNode popNode1 = method.instructions.get(565);
                method.instructions.insertBefore(targetNode1, (AbstractInsnNode)new VarInsnNode(25, 28));
                method.instructions.insertBefore(targetNode1, (AbstractInsnNode)new MethodInsnNode(184, "meldexun/entityculling/plugin/Hook", "shouldRenderChunkShadow", "(Ljava/lang/Object;)Z", false));
                method.instructions.insertBefore(targetNode1, (AbstractInsnNode)new JumpInsnNode(153, (LabelNode)popNode1));
            }));
        }
        EntityCullingTransformer.registerMethodTransformer(new MethodTransformer("bze", "net.minecraft.client.renderer.entity.Render", "a", "shouldRender", "(Lvg;Lbxy;DDD)Z", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/client/renderer/culling/ICamera;DDD)Z", method -> {
            AbstractInsnNode targetNode = method.instructions.get(0);
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new FieldInsnNode(178, "meldexun/entityculling/EntityCullingConfig", "enabled", "Z"));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new JumpInsnNode(153, (LabelNode)targetNode));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(25, 1));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(25, 2));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(24, 3));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(24, 5));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(24, 7));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new MethodInsnNode(184, "meldexun/entityculling/plugin/Hook", "shouldRender", "(Lnet/minecraft/client/renderer/entity/Render;Lnet/minecraft/entity/Entity;Lnet/minecraft/client/renderer/culling/ICamera;DDD)Z", false));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new InsnNode(172));
        }));
        EntityCullingTransformer.registerMethodTransformer(new MethodTransformer("bwv", "net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher", "a", "render", "(Lavj;FI)V", "(Lnet/minecraft/tileentity/TileEntity;FI)V", method -> {
            AbstractInsnNode targetNode = method.instructions.get(0);
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(25, 1));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(21, 3));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/renderer/tileentity/TileEntityRendererDispatcher", "drawingBatch", "Z"));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new MethodInsnNode(184, "meldexun/entityculling/plugin/Hook", "render", "(Lnet/minecraft/tileentity/TileEntity;IZ)Z", false));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new JumpInsnNode(153, (LabelNode)targetNode));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new InsnNode(177));
        }));
        EntityCullingTransformer.registerMethodTransformer(new MethodTransformer("bhz", "net.minecraft.client.Minecraft", "k", "getLimitFramerate", "()I", "()I", method -> {
            AbstractInsnNode targetNode1 = method.instructions.get(0);
            AbstractInsnNode popNode1 = method.instructions.get(15);
            method.instructions.insertBefore(targetNode1, (AbstractInsnNode)new MethodInsnNode(184, "meldexun/entityculling/plugin/Hook", "getLimitFramerate", "()I", false));
            method.instructions.insertBefore(targetNode1, (AbstractInsnNode)new JumpInsnNode(167, (LabelNode)popNode1));
        }));
        EntityCullingTransformer.registerMethodTransformer(new MethodTransformer("bxz", "net.minecraft.client.renderer.culling.ClippingHelper", "b", "isBoxInFrustum", "(DDDDDD)Z", "(DDDDDD)Z", method -> {
            AbstractInsnNode targetNode = method.instructions.get(0);
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(25, 0));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/renderer/culling/ClippingHelper", IS_WORKSPACE_ENVIRONMENT ? "frustum" : "field_78557_a", "[[F"));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(24, 1));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(24, 3));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(24, 5));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(24, 7));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(24, 9));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new VarInsnNode(24, 11));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new MethodInsnNode(184, "meldexun/entityculling/plugin/Hook", "isBoxInFrustum", "([[FDDDDDD)Z", false));
            method.instructions.insertBefore(targetNode, (AbstractInsnNode)new InsnNode(172));
        }));
    }
}

