/*
 * Decompiled with CFR 0.152.
 */
package meldexun.entityculling.plugin;

import meldexun.entityculling.EntityCullingConfig;
import meldexun.entityculling.plugin.EntityCullingRenderer;
import meldexun.entityculling.plugin.EntityCullingRendererOptifine;
import meldexun.entityculling.plugin.EntityCullingTransformer;
import meldexun.entityculling.reflection.ReflectionField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public final class Hook {
    private static final ReflectionField<RenderChunk> FIELD_RENDER_CHUNK = new ReflectionField("net.minecraft.client.renderer.RenderGlobal$ContainerLocalRenderInformation", "field_178036_a", "renderChunk");
    private static EntityCullingRenderer renderer;

    private Hook() {
    }

    public static EntityCullingRenderer getRenderer() {
        if (renderer == null) {
            renderer = EntityCullingTransformer.IS_OPTIFINE_DETECTED ? new EntityCullingRendererOptifine() : new EntityCullingRenderer();
        }
        return renderer;
    }

    public static int getLimitFramerate() {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71441_e == null ? MathHelper.func_76125_a((int)mc.field_71474_y.field_74350_i, (int)30, (int)240) : mc.field_71474_y.field_74350_i;
    }

    public static boolean renderEntities() {
        return Hook.getRenderer().renderEntities();
    }

    public static boolean renderTileEntities() {
        return Hook.getRenderer().renderTileEntities();
    }

    public static boolean shouldRender(Render<?> render, Entity entity, ICamera camera, double camX, double camY, double camZ) {
        if (!entity.func_145770_h(camX, camY, camZ)) {
            return false;
        }
        if (entity.field_70158_ak) {
            return true;
        }
        AxisAlignedBB aabb = entity.func_184177_bl();
        if (aabb.func_181656_b()) {
            if (camera instanceof Frustum) {
                return ((Frustum)camera).func_78548_b(entity.field_70165_t - 2.0, entity.field_70163_u - 2.0, entity.field_70161_v - 2.0, entity.field_70165_t + 2.0, entity.field_70163_u + 2.0, entity.field_70161_v + 2.0);
            }
            return camera.func_78546_a(new AxisAlignedBB(entity.field_70165_t - 2.0, entity.field_70163_u - 2.0, entity.field_70161_v - 2.0, entity.field_70165_t + 2.0, entity.field_70163_u + 2.0, entity.field_70161_v + 2.0));
        }
        if (camera instanceof Frustum) {
            return ((Frustum)camera).func_78548_b(aabb.field_72340_a - 0.5, aabb.field_72338_b - 0.5, aabb.field_72339_c - 0.5, aabb.field_72336_d + 0.5, aabb.field_72337_e + 0.5, aabb.field_72334_f + 0.5);
        }
        return camera.func_78546_a(new AxisAlignedBB(aabb.field_72340_a - 0.5, aabb.field_72338_b - 0.5, aabb.field_72339_c - 0.5, aabb.field_72336_d + 0.5, aabb.field_72337_e + 0.5, aabb.field_72334_f + 0.5));
    }

    public static boolean render(TileEntity tileEntity, int destroyStage, boolean drawingBatch) {
        if (!EntityCullingConfig.enabled) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        float partialTicks = mc.func_184121_ak();
        if (!drawingBatch || !tileEntity.hasFastRenderer()) {
            RenderHelper.func_74519_b();
            int i = mc.field_71441_e.func_175626_b(tileEntity.func_174877_v(), 0);
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        BlockPos blockpos = tileEntity.func_174877_v();
        double x1 = (double)blockpos.func_177958_n() - TileEntityRendererDispatcher.field_147554_b;
        double y1 = (double)blockpos.func_177956_o() - TileEntityRendererDispatcher.field_147555_c;
        double z1 = (double)blockpos.func_177952_p() - TileEntityRendererDispatcher.field_147552_d;
        TileEntityRendererDispatcher.field_147556_a.func_192854_a(tileEntity, x1, y1, z1, partialTicks, destroyStage, 1.0f);
        return true;
    }

    public static boolean shouldRenderChunkShadow(Object containerLocalRenderInformation) {
        if (!EntityCullingConfig.enabled) {
            return true;
        }
        if (!EntityCullingConfig.optifineShaderOptions.terrainShadowsEnabled) {
            return false;
        }
        if (!EntityCullingConfig.optifineShaderOptions.terrainShadowsDistanceLimited) {
            return true;
        }
        RenderChunk renderChunk = FIELD_RENDER_CHUNK.get(containerLocalRenderInformation);
        BlockPos pos = renderChunk.func_178568_j();
        Minecraft mc = Minecraft.func_71410_x();
        Entity entity = mc.func_175606_aa();
        float partialTicks = mc.func_184121_ak();
        double x = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        if (Math.abs((double)pos.func_177958_n() + 8.0 - x) > EntityCullingConfig.optifineShaderOptions.terrainShadowsMaxHorizontalDistance * 16.0) {
            return false;
        }
        double y = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks + (double)entity.func_70047_e();
        if (Math.abs((double)pos.func_177956_o() + 8.0 - y) > EntityCullingConfig.optifineShaderOptions.terrainShadowsMaxVerticalDistance * 16.0) {
            return false;
        }
        double z = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        return Math.abs((double)pos.func_177952_p() + 8.0 - z) <= EntityCullingConfig.optifineShaderOptions.terrainShadowsMaxHorizontalDistance * 16.0;
    }

    public static boolean isBoxInFrustum(float[][] frustumData, double x0, double y0, double z0, double x1, double y1, double z1) {
        for (int i = 0; i < frustumData.length; ++i) {
            float[] v = frustumData[i];
            float f = v[0];
            float f2 = v[1];
            float f3 = v[2];
            float f4 = v[3];
            double d = v[0] >= 0.0f ? x1 : x0;
            double d2 = v[1] >= 0.0f ? y1 : y0;
            double d3 = v[2] >= 0.0f ? z1 : z0;
            if (!(Hook.dist(f, f2, f3, f4, d, d2, d3) <= 0.0)) continue;
            return false;
        }
        return true;
    }

    private static double dist(float planeX, float planeY, float planeZ, float planeW, double x, double y, double z) {
        return (double)planeX * x + (double)planeY * y + (double)planeZ * z + (double)planeW;
    }
}

