/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.InvalidInputDataException;
import buildcraft.api.enums.EnumSnapshotType;
import buildcraft.api.schematics.ISchematicBlock;
import buildcraft.builders.BCBuildersItems;
import buildcraft.builders.item.ItemSchematicSingle;
import buildcraft.builders.item.ItemSnapshot;
import buildcraft.builders.snapshot.Blueprint;
import buildcraft.builders.snapshot.GlobalSavedDataSnapshots;
import buildcraft.builders.snapshot.SchematicBlockManager;
import buildcraft.builders.snapshot.Snapshot;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.lib.tile.item.ItemHandlerManager;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import java.util.Date;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ITickable;

public class TileReplacer
extends TileBC_Neptune
implements ITickable {
    public static final IdAllocator IDS = TileBC_Neptune.IDS.makeChild("replacer");
    public final ItemHandlerSimple invSnapshot;
    public final ItemHandlerSimple invSchematicFrom;
    public final ItemHandlerSimple invSchematicTo;

    public TileReplacer() {
        this.invSnapshot = this.itemManager.addInvHandler("snapshot", 1, (slot, stack) -> stack.func_77973_b() instanceof ItemSnapshot && ItemSnapshot.EnumItemSnapshotType.getFromStack(stack) == ItemSnapshot.EnumItemSnapshotType.BLUEPRINT_USED, ItemHandlerManager.EnumAccess.NONE, new EnumPipePart[0]);
        this.invSchematicFrom = this.itemManager.addInvHandler("schematicFrom", 1, (slot, stack) -> stack.func_77973_b() instanceof ItemSchematicSingle && stack.func_77952_i() == 1, ItemHandlerManager.EnumAccess.NONE, new EnumPipePart[0]);
        this.invSchematicTo = this.itemManager.addInvHandler("schematicTo", 1, (slot, stack) -> stack.func_77973_b() instanceof ItemSchematicSingle && stack.func_77952_i() == 1, ItemHandlerManager.EnumAccess.NONE, new EnumPipePart[0]);
    }

    public void func_73660_a() {
        Snapshot snapshot;
        Snapshot.Header header;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.invSnapshot.getStackInSlot(0).func_190926_b() && !this.invSchematicFrom.getStackInSlot(0).func_190926_b() && !this.invSchematicTo.getStackInSlot(0).func_190926_b() && (header = BCBuildersItems.snapshot.getHeader(this.invSnapshot.getStackInSlot(0))) != null && (snapshot = GlobalSavedDataSnapshots.get(this.field_145850_b).getSnapshot(header.key)) instanceof Blueprint) {
            Blueprint blueprint = (Blueprint)snapshot;
            try {
                ISchematicBlock from = SchematicBlockManager.readFromNBT(NBTUtilBC.getItemData(this.invSchematicFrom.getStackInSlot(0)).func_74775_l("schematic"));
                ISchematicBlock to = SchematicBlockManager.readFromNBT(NBTUtilBC.getItemData(this.invSchematicTo.getStackInSlot(0)).func_74775_l("schematic"));
                Blueprint newBlueprint = blueprint.copy();
                newBlueprint.replace(from, to);
                newBlueprint.computeKey();
                GlobalSavedDataSnapshots.get(this.field_145850_b).addSnapshot(newBlueprint);
                this.invSnapshot.setStackInSlot(0, BCBuildersItems.snapshot.getUsed(EnumSnapshotType.BLUEPRINT, new Snapshot.Header(blueprint.key, this.getOwner().getId(), new Date(), header.name)));
                this.invSchematicFrom.setStackInSlot(0, ItemStack.field_190927_a);
                this.invSchematicTo.setStackInSlot(0, ItemStack.field_190927_a);
            }
            catch (InvalidInputDataException e) {
                e.printStackTrace();
            }
        }
    }
}

