/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.registry;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TagManager {
    private static final Map<String, TagEntry> idsToEntry = new HashMap<String, TagEntry>();
    private static final Deque<List<TagEntry>> batchTasks = new ArrayDeque<List<TagEntry>>();

    public static Item getItem(String id) {
        String regTag = TagManager.getTag(id, EnumTagType.REGISTRY_NAME);
        ResourceLocation loc = new ResourceLocation(regTag);
        if (ForgeRegistries.ITEMS.containsKey(loc)) {
            return (Item)ForgeRegistries.ITEMS.getValue(loc);
        }
        return null;
    }

    public static String getTag(String id, EnumTagType type) {
        if (idsToEntry.containsKey(id)) {
            TagEntry entry = idsToEntry.get(id);
            return entry.getSingleTag(type);
        }
        throw new IllegalArgumentException("Unknown id " + id);
    }

    public static boolean hasTag(String id, EnumTagType type) {
        if (idsToEntry.containsKey(id)) {
            TagEntry entry = idsToEntry.get(id);
            return entry.tags.containsKey((Object)type);
        }
        throw new IllegalArgumentException("Unknown id " + id);
    }

    public static String[] getMultiTag(String id, EnumTagTypeMulti type) {
        if (idsToEntry.containsKey(id)) {
            TagEntry entry = idsToEntry.get(id);
            return entry.getMultiTag(type);
        }
        throw new IllegalArgumentException("Unknown id " + id);
    }

    public static TagEntry getTag(String id) {
        return idsToEntry.get(id);
    }

    public static TagEntry registerTag(String id) {
        TagEntry entry = new TagEntry(id);
        idsToEntry.put(id, entry);
        for (List<TagEntry> list : batchTasks) {
            list.add(entry);
        }
        return entry;
    }

    public static void startBatch() {
        batchTasks.push(new ArrayList());
    }

    public static void endBatch(Consumer<TagEntry> consumer) {
        batchTasks.pop().forEach(consumer);
    }

    public static Consumer<TagEntry> prependTag(EnumTagType type, String prefix) {
        return tag -> {
            if (tag.hasSingleTag(type)) {
                tag.setSingleTag(type, prefix + tag.getSingleTag(type));
            }
        };
    }

    public static Consumer<TagEntry> prependTags(String prefix, EnumTagType ... tags) {
        Consumer<TagEntry> consumer = tag -> {};
        for (EnumTagType type : tags) {
            consumer = consumer.andThen(TagManager.prependTag(type, prefix));
        }
        return consumer;
    }

    public static Consumer<TagEntry> set(EnumTagType type, String value) {
        return tag -> tag.setSingleTag(type, value);
    }

    public static Consumer<TagEntry> setTab(String creativeTab) {
        return tag -> {
            if (tag.hasSingleTag(EnumTagType.REGISTRY_NAME) && !tag.hasSingleTag(EnumTagType.CREATIVE_TAB)) {
                tag.tab(creativeTab);
            }
        };
    }

    public static class TagEntry {
        public final String id;
        private final Map<EnumTagType, String> tags = new EnumMap<EnumTagType, String>(EnumTagType.class);
        private final Map<EnumTagTypeMulti, List<String>> multiTags = new EnumMap<EnumTagTypeMulti, List<String>>(EnumTagTypeMulti.class);

        public TagEntry(String id) {
            this.id = id;
        }

        public String getSingleTag(EnumTagType type) {
            if (!this.tags.containsKey((Object)type)) {
                throw new IllegalArgumentException("Unknown tag type " + (Object)((Object)type) + " for the entry " + this.id);
            }
            return this.tags.get((Object)type);
        }

        public boolean hasSingleTag(EnumTagType type) {
            return this.tags.containsKey((Object)type);
        }

        public String[] getMultiTag(EnumTagTypeMulti type) {
            List<String> ts = this.multiTags.get((Object)type);
            if (ts == null) {
                return new String[0];
            }
            return ts.toArray(new String[ts.size()]);
        }

        public TagEntry setSingleTag(EnumTagType type, String tag) {
            this.tags.put(type, tag);
            return this;
        }

        public TagEntry reg(String name) {
            return this.setSingleTag(EnumTagType.REGISTRY_NAME, name);
        }

        public TagEntry locale(String name) {
            return this.setSingleTag(EnumTagType.UNLOCALIZED_NAME, name);
        }

        public TagEntry oreDict(String name) {
            return this.setSingleTag(EnumTagType.OREDICT_NAME, name);
        }

        public TagEntry tab(String creativeTab) {
            return this.setSingleTag(EnumTagType.CREATIVE_TAB, creativeTab);
        }

        public TagEntry model(String modelLocation) {
            return this.setSingleTag(EnumTagType.MODEL_LOCATION, modelLocation);
        }

        public TagEntry addMultiTag(EnumTagTypeMulti type, String ... tags) {
            if (!this.multiTags.containsKey((Object)type)) {
                this.multiTags.put(type, new LinkedList());
            }
            for (String tag : tags) {
                this.multiTags.get((Object)type).add(tag);
            }
            return this;
        }

        public TagEntry oldReg(String ... tags) {
            return this.addMultiTag(EnumTagTypeMulti.OLD_REGISTRY_NAME, tags);
        }
    }

    public static enum EnumTagTypeMulti {
        OLD_REGISTRY_NAME;

    }

    public static enum EnumTagType {
        UNLOCALIZED_NAME,
        OREDICT_NAME,
        REGISTRY_NAME,
        CREATIVE_TAB,
        MODEL_LOCATION;

    }
}

