/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.client.render;

import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.core.client.BuildCraftLaserManager;
import buildcraft.core.item.ItemGoggles;
import buildcraft.lib.client.render.laser.LaserData_BC8;
import buildcraft.lib.client.render.laser.LaserRenderer_BC8;
import buildcraft.silicon.BCSiliconConfig;
import buildcraft.silicon.tile.TileLaser;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.model.animation.FastTESR;

public class RenderLaser
extends FastTESR<TileLaser> {
    private static final int MAX_POWER = BuildCraftLaserManager.POWERS.length - 1;

    public void renderTileEntityFast(@Nonnull TileLaser tile, double x, double y, double z, float partialTicks, int destroyStage, float partial, @Nonnull BufferBuilder buffer) {
        if (BCSiliconConfig.renderLaserBeams || this.isPlayerWearingGoggles()) {
            long avg;
            Minecraft.func_71410_x().field_71424_I.func_76320_a("bc");
            Minecraft.func_71410_x().field_71424_I.func_76320_a("laser");
            buffer.func_178969_c(x - (double)tile.func_174877_v().func_177958_n(), y - (double)tile.func_174877_v().func_177956_o(), z - (double)tile.func_174877_v().func_177952_p());
            if (tile.laserPos != null && (avg = tile.getAverageClient()) > 200000L) {
                EnumFacing side = (EnumFacing)tile.func_145831_w().func_180495_p(tile.func_174877_v()).func_177229_b(BuildCraftProperties.BLOCK_FACING_6);
                Vec3d offset = new Vec3d(0.5, 0.5, 0.5).func_178787_e(new Vec3d(side.func_176730_m()).func_186678_a(0.25));
                int index = (int)((avg += 200000L) * (long)MAX_POWER / tile.getMaxPowerPerTick());
                if (index > MAX_POWER) {
                    index = MAX_POWER;
                }
                LaserData_BC8 laser = new LaserData_BC8(BuildCraftLaserManager.POWERS[index], new Vec3d((Vec3i)tile.func_174877_v()).func_178787_e(offset), tile.laserPos, 0.0625);
                LaserRenderer_BC8.renderLaserDynamic(laser, buffer);
            }
            buffer.func_178969_c(0.0, 0.0, 0.0);
            Minecraft.func_71410_x().field_71424_I.func_76319_b();
            Minecraft.func_71410_x().field_71424_I.func_76319_b();
        }
    }

    private boolean isPlayerWearingGoggles() {
        Item headArmor = Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b();
        return headArmor instanceof ItemGoggles;
    }
}

