/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.blocks;

import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.blocks.MimicProperty;
import com.ferreusveritas.dynamictrees.tileentity.TileEntitySpecies;
import dynamictreesbop.blocks.properties.UnlistedPropertyBool;
import dynamictreesbop.blocks.properties.UnlistedPropertyFloat;
import dynamictreesbop.blocks.properties.UnlistedPropertyInt;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRootyWater
extends BlockRooty {
    public static final UnlistedPropertyBool[] RENDER_SIDES = new UnlistedPropertyBool[]{new UnlistedPropertyBool("render_d"), new UnlistedPropertyBool("render_u"), new UnlistedPropertyBool("render_n"), new UnlistedPropertyBool("render_s"), new UnlistedPropertyBool("render_w"), new UnlistedPropertyBool("render_e")};
    public static final UnlistedPropertyFloat[] CORNER_HEIGHTS = new UnlistedPropertyFloat[]{new UnlistedPropertyFloat("level_nw"), new UnlistedPropertyFloat("level_sw"), new UnlistedPropertyFloat("level_se"), new UnlistedPropertyFloat("level_ne")};
    public static final UnlistedPropertyInt COLOR = new UnlistedPropertyInt("color");
    private static final Vec3d acceleration_modifier = new Vec3d(0.0, 0.0, 0.0);

    public BlockRootyWater(boolean isTileEntity) {
        super("rootywater", Material.field_151586_h, isTileEntity);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(super.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(15)));
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{LIFE, BlockLiquid.field_176367_b}, new IUnlistedProperty[]{MimicProperty.MIMIC, RENDER_SIDES[0], RENDER_SIDES[1], RENDER_SIDES[2], RENDER_SIDES[3], RENDER_SIDES[4], RENDER_SIDES[5], CORNER_HEIGHTS[0], CORNER_HEIGHTS[1], CORNER_HEIGHTS[2], CORNER_HEIGHTS[3], COLOR});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess access, BlockPos pos) {
        int i = 0;
        float avg = 0.0f;
        avg += BlockLiquid.func_149801_b((int)7);
        ++i;
        float h = this.getFluidHeight(access, pos.func_177976_e(), Material.field_151586_h);
        if (h != 0.0f) {
            ++i;
        }
        avg += h;
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState extState = (IExtendedBlockState)state;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                extState = extState.withProperty((IUnlistedProperty)RENDER_SIDES[dir.ordinal()], (Object)Blocks.field_150355_j.func_176225_a(state, access, pos, dir));
            }
            extState = extState.withProperty((IUnlistedProperty)CORNER_HEIGHTS[0], (Object)Float.valueOf(avg / (float)i));
            extState = extState.withProperty((IUnlistedProperty)CORNER_HEIGHTS[1], (Object)Float.valueOf(this.getFluidHeight(access, pos.func_177968_d(), Material.field_151586_h)));
            extState = extState.withProperty((IUnlistedProperty)CORNER_HEIGHTS[2], (Object)Float.valueOf(this.getFluidHeight(access, pos.func_177974_f().func_177968_d(), Material.field_151586_h)));
            extState = extState.withProperty((IUnlistedProperty)CORNER_HEIGHTS[3], (Object)Float.valueOf(this.getFluidHeight(access, pos.func_177974_f(), Material.field_151586_h)));
            extState = extState.withProperty((IUnlistedProperty)COLOR, (Object)Minecraft.func_71410_x().func_184125_al().func_186724_a(Blocks.field_150355_j.func_176223_P(), access, pos, 0));
            return extState;
        }
        return state;
    }

    private float getFluidHeight(IBlockAccess blockAccess, BlockPos blockPosIn, Material blockMaterial) {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < 4; ++j) {
            BlockPos blockpos = blockPosIn.func_177982_a(-(j & 1), 0, -(j >> 1 & 1));
            if (blockAccess.func_180495_p(blockpos.func_177984_a()).func_185904_a() == blockMaterial) {
                return 1.0f;
            }
            IBlockState iblockstate = blockAccess.func_180495_p(blockpos);
            Material material = iblockstate.func_185904_a();
            if (material != blockMaterial) {
                if (material.func_76220_a()) continue;
                f += 1.0f;
                ++i;
                continue;
            }
            int k = (Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b);
            if (k >= 8 || k == 0) {
                f += BlockLiquid.func_149801_b((int)k) * 10.0f;
                i += 10;
            }
            f += BlockLiquid.func_149801_b((int)k);
            ++i;
        }
        return 1.0f - f / (float)i;
    }

    public IBlockState getMimic(IBlockAccess access, BlockPos pos) {
        return Blocks.field_150355_j.func_176223_P();
    }

    public IBlockState getDecayBlockState(IBlockAccess access, BlockPos pos) {
        return Blocks.field_150355_j.func_176223_P();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (blockAccess.func_180495_p(pos.func_177972_a(side)).func_185904_a() == this.field_149764_J) {
            return false;
        }
        return side == EnumFacing.UP ? true : super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return this.field_149758_A ? new TileEntitySpecies() : null;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public Vec3d func_176197_a(World worldIn, BlockPos pos, Entity entityIn, Vec3d motion) {
        return motion.func_178787_e(acceleration_modifier);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(IBlockState state, IBlockAccess source, BlockPos pos) {
        int i = source.func_175626_b(pos, 0);
        int j = source.func_175626_b(pos.func_177984_a(), 0);
        int k = i & 0xFF;
        int l = j & 0xFF;
        int i1 = i >> 16 & 0xFF;
        int j1 = j >> 16 & 0xFF;
        return (k > l ? k : l) | (i1 > j1 ? i1 : j1) << 16;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getFogColor(World world, BlockPos pos, IBlockState state, Entity entity, Vec3d originalColor, float partialTicks) {
        return super.getFogColor(world, pos, Blocks.field_150355_j.func_176223_P(), entity, originalColor, partialTicks);
    }
}

