/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.block.BlockBOPLog;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.SpeciesRare;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dynamictreesbop.ModContent;
import dynamictreesbop.dropcreators.DropCreatorInvoluntarySeed;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TreeEbony
extends TreeFamily {
    Species twigletSpecies;

    public TreeEbony() {
        super(new ResourceLocation("dynamictreesbop", "ebony"));
        IBlockState primLog = BlockBOPLog.paging.getVariantState((Enum)BOPWoods.EBONY);
        this.setPrimitiveLog(primLog, BlockBOPLog.paging.getVariantItem((Enum)BOPWoods.EBONY));
        ModContent.leaves.get("ebony").setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockBOPLeaves && state.func_177229_b(((BlockBOPLeaves)state.func_177230_c()).variantProperty) == BOPTrees.EBONY);
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesEbony(this));
        this.twigletSpecies = new SpeciesEbonyTwiglet(this);
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
        speciesRegistry.register((IForgeRegistryEntry)this.twigletSpecies);
    }

    public class SpeciesEbonyTwiglet
    extends SpeciesRare {
        public SpeciesEbonyTwiglet(TreeFamily treeFamily) {
            super(new ResourceLocation("dynamictreesbop", "ebonytwiglet"), treeFamily, ModContent.leaves.get("ebony"));
            this.setBasicGrowingParameters(0.3f, 2.5f, 1, 2, 1.0f);
            this.envFactor(BiomeDictionary.Type.WET, 0.5f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.5f);
            this.envFactor(BiomeDictionary.Type.SAVANNA, 1.05f);
            this.addAcceptableSoil(new Block[]{BOPBlocks.grass, BOPBlocks.dirt});
            this.addDropCreator((IDropCreator)new DropCreatorInvoluntarySeed());
            this.remDropCreator(new ResourceLocation("dynamictrees", "logs"));
        }

        public Species.LogsAndSticks getLogsAndSticks(float volume) {
            return super.getLogsAndSticks(volume * 16.0f);
        }

        public boolean isBiomePerfect(Biome biome) {
            return SpeciesEbonyTwiglet.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{(Biome)BOPBiomes.brushland.orNull()});
        }

        public ItemStack getSeedStack(int qty) {
            return this.getFamily().getCommonSpecies().getSeedStack(qty);
        }

        public Seed getSeed() {
            return this.getFamily().getCommonSpecies().getSeed();
        }
    }

    public class SpeciesEbony
    extends Species {
        public SpeciesEbony(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.leaves.get("ebony"));
            this.setBasicGrowingParameters(0.3f, 12.0f, this.upProbability, this.lowestBranchHeight, 1.0f);
            this.envFactor(BiomeDictionary.Type.WET, 0.5f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.5f);
            this.envFactor(BiomeDictionary.Type.SAVANNA, 1.05f);
            this.addAcceptableSoil(new Block[]{BOPBlocks.grass, BOPBlocks.dirt});
            this.generateSeed();
            this.setupStandardSeedDropping();
        }

        public boolean isBiomePerfect(Biome biome) {
            return SpeciesEbony.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{(Biome)BOPBiomes.brushland.orNull()});
        }
    }
}

