/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.block.BlockBOPLog;
import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dynamictreesbop.ModContent;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TreeHellbark
extends TreeFamily {
    public TreeHellbark() {
        super(new ResourceLocation("dynamictreesbop", "hellbark"));
        IBlockState primLog = BlockBOPLog.paging.getVariantState((Enum)BOPWoods.HELLBARK);
        this.setPrimitiveLog(primLog, BlockBOPLog.paging.getVariantItem((Enum)BOPWoods.HELLBARK));
        ModContent.leaves.get("hellbark").setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockBOPLeaves && state.func_177229_b(((BlockBOPLeaves)state.func_177230_c()).variantProperty) == BOPTrees.HELLBARK);
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesHellbark(this));
    }

    public class SpeciesHellbark
    extends Species {
        SpeciesHellbark(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.leaves.get("hellbark"));
            this.setBasicGrowingParameters(0.3f, 2.5f, 1, 2, 1.0f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.25f);
            this.envFactor(BiomeDictionary.Type.NETHER, 1.05f);
            this.addAcceptableSoil(new Block[]{BOPBlocks.grass, BOPBlocks.dirt});
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.remDropCreator(new ResourceLocation("dynamictrees", "logs"));
        }

        public Species.LogsAndSticks getLogsAndSticks(float volume) {
            return super.getLogsAndSticks(volume * 16.0f);
        }

        public boolean isBiomePerfect(Biome biome) {
            return SpeciesHellbark.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{(Biome)BOPBiomes.undergarden.orNull()});
        }

        public boolean isAcceptableSoilForWorldgen(World world, BlockPos pos, IBlockState soilBlockState) {
            return super.isAcceptableSoilForWorldgen(world, pos, soilBlockState) || soilBlockState.func_177230_c() == Blocks.field_150424_aL;
        }

        public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
            if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
                if (radius > 4 && TreeHelper.isRooty((IBlockState)world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                    world.func_175656_a(pos, random.nextInt(3) == 0 ? ModBlocks.blockStates.redMushroom : ModBlocks.blockStates.brownMushroom);
                }
                return true;
            }
            return false;
        }
    }
}

