/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.block.BlockBOPLog;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchThick;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenClearVolume;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFlareBottom;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenMound;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenRoots;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import dynamictreesbop.ModContent;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TreeRedwood
extends TreeFamily {
    BlockSurfaceRoot surfaceRootBlock;

    public TreeRedwood() {
        super(new ResourceLocation("dynamictreesbop", "redwood"));
        IBlockState primLog = BlockBOPLog.paging.getVariantState((Enum)BOPWoods.REDWOOD);
        this.setPrimitiveLog(primLog, BlockBOPLog.paging.getVariantItem((Enum)BOPWoods.REDWOOD));
        ModContent.leaves.get("redwood").setTree((TreeFamily)this);
        this.surfaceRootBlock = new BlockSurfaceRoot(Material.field_151575_d, this.getName() + "root");
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockBOPLeaves && state.func_177229_b(((BlockBOPLeaves)state.func_177230_c()).variantProperty) == BOPTrees.REDWOOD);
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesRedwood(this));
    }

    public boolean isThick() {
        return true;
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList = super.getRegisterableBlocks(blockList);
        blockList.add(this.surfaceRootBlock);
        return blockList;
    }

    public BlockSurfaceRoot getSurfaceRoots() {
        return this.surfaceRootBlock;
    }

    public BlockBranch createBranch() {
        String branchName = this.getName() + "branch";
        return new BlockBranchRedwood(branchName);
    }

    protected class BlockBranchRedwood
    extends BlockBranchThick {
        public BlockBranchRedwood(String name) {
            this(Material.field_151575_d, name);
        }

        public BlockBranchRedwood(Material material, String name) {
            super(material, name, false);
            this.otherBlock = new BlockBranchRedwood(material, name + "x", true);
            this.otherBlock.otherBlock = this;
            this.cacheBranchThickStates();
        }

        protected BlockBranchRedwood(Material material, String name, boolean extended) {
            super(material, name, extended);
        }

        protected int getMaxSignalDepth() {
            return 64;
        }
    }

    public class SpeciesRedwood
    extends Species {
        SpeciesRedwood(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.leaves.get("redwood"));
            this.setBasicGrowingParameters(0.27f, 38.0f, 24, 22, 1.33f);
            this.setSoilLongevity(53);
            this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.25f);
            this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
            this.addAcceptableSoil(new Block[]{BOPBlocks.grass, BOPBlocks.dirt});
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenClearVolume(32));
            this.addGenFeature((IGenFeature)new FeatureGenMound(6));
            this.addGenFeature((IGenFeature)new FeatureGenFlareBottom());
            this.addGenFeature((IGenFeature)new FeatureGenRoots(15).setScaler(this.getRootScaler()));
        }

        protected BiFunction<Integer, Integer, Integer> getRootScaler() {
            return (inRadius, trunkRadius) -> {
                float scale = MathHelper.func_76131_a((float)(trunkRadius >= 15 ? (float)trunkRadius.intValue() / 24.0f : 0.0f), (float)0.0f, (float)1.0f);
                return (int)((float)inRadius.intValue() * scale);
            };
        }

        public boolean isBiomePerfect(Biome biome) {
            return SpeciesRedwood.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{(Biome)BOPBiomes.redwood_forest.orNull()});
        }

        public EnumFacing selectNewDirection(World world, BlockPos pos, BlockBranch branch, GrowSignal signal) {
            EnumFacing originDir = signal.dir.func_176734_d();
            int signalY = signal.delta.func_177956_o();
            if (signalY <= 2) {
                return EnumFacing.UP;
            }
            int[] probMap = new int[6];
            probMap[EnumFacing.UP.ordinal()] = signal.dir != EnumFacing.DOWN ? this.getUpProbability() : 0;
            int n = signal.dir.ordinal();
            probMap[n] = probMap[n] + this.getReinfTravel();
            int radius = branch.getRadius(world.func_180495_p(pos));
            if (signal.delta.func_177956_o() < this.getLowestBranchHeight() - 3) {
                boolean sideTurn;
                long day = world.func_72820_D() / 24000L;
                int month = (int)day / 30;
                int treeHash = CoordUtils.coordHashCode((BlockPos)signal.rootPos.func_177981_b(month), (int)3);
                int posHash = CoordUtils.coordHashCode((BlockPos)pos.func_177981_b(month), (int)2);
                int hashMod = signalY < 7 ? 3 : 11;
                boolean bl = sideTurn = !signal.isInTrunk() || signal.isInTrunk() && (signal.numSteps + treeHash) % hashMod == 0 && radius > 1;
                if (!sideTurn) {
                    return EnumFacing.UP;
                }
                probMap[2 + posHash % 4] = 1;
            }
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (dir.equals((Object)originDir)) continue;
                BlockPos deltaPos = pos.func_177972_a(dir);
                if (signalY < this.getLowestBranchHeight()) continue;
                IBlockState deltaBlockState = world.func_180495_p(deltaPos);
                ITreePart treePart = TreeHelper.getTreePart((IBlockState)deltaBlockState);
                int n2 = dir.func_176745_a();
                probMap[n2] = probMap[n2] + treePart.probabilityForBlock(deltaBlockState, (IBlockAccess)world, deltaPos, branch);
            }
            int choice = com.ferreusveritas.dynamictrees.util.MathHelper.selectRandomFromDistribution((Random)signal.rand, (int[])(probMap = this.customDirectionManipulation(world, pos, radius, signal, probMap)));
            return this.newDirectionSelected(EnumFacing.func_82600_a((int)(choice != -1 ? choice : 1)), signal);
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            EnumFacing originDir = signal.dir.func_176734_d();
            probMap[0] = 0;
            probMap[1] = signal.isInTrunk() || signal.delta.func_177956_o() >= this.getLowestBranchHeight() ? this.getUpProbability() : 1;
            probMap[originDir.ordinal()] = 0;
            return probMap;
        }

        protected EnumFacing newDirectionSelected(EnumFacing newDir, GrowSignal signal) {
            if (signal.isInTrunk() && newDir != EnumFacing.UP) {
                int signalY = signal.delta.func_177956_o();
                if (signalY < this.getLowestBranchHeight()) {
                    signal.energy = 0.9f + (1.0f - (float)signalY / (float)this.getLowestBranchHeight()) * 3.7f;
                } else {
                    signal.energy += 5.0f;
                    signal.energy /= 4.8f;
                    if (signal.energy > 5.8f) {
                        signal.energy = 5.8f;
                    }
                }
            }
            return newDir;
        }

        public float getEnergy(World world, BlockPos pos) {
            long day = world.func_72820_D() / 24000L;
            int month = (int)day / 30;
            return super.getEnergy(world, pos) * this.biomeSuitability(world, pos) + (float)(this.coordHashCode(pos.func_177981_b(month)) % 16);
        }

        public int getLowestBranchHeight(World world, BlockPos pos) {
            long day = world.func_72820_D() / 24000L;
            int month = (int)day / 30;
            return (int)(((float)this.getLowestBranchHeight() + (float)(this.coordHashCode(pos.func_177981_b(month)) % 16) * 0.5f) * this.biomeSuitability(world, pos));
        }

        public int getWorldGenLeafMapHeight() {
            return 60;
        }

        public boolean isThick() {
            return true;
        }
    }
}

