/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.common.block.BlockBOPDirt;
import biomesoplenty.common.block.BlockBOPLeaves;
import biomesoplenty.common.block.BlockBOPLog;
import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.growthlogic.ConiferLogic;
import com.ferreusveritas.dynamictrees.growthlogic.IGrowthLogicKit;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenClearVolume;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenConiferTopper;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFlareBottom;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenMound;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenVine;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.SpeciesRare;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dynamictreesbop.ModContent;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TreeUmbran
extends TreeFamily {
    public Species coniferSpecies;
    public Species megaConiferSpecies;

    public TreeUmbran() {
        super(new ResourceLocation("dynamictreesbop", "umbran"));
        IBlockState primLog = BlockBOPLog.paging.getVariantState((Enum)BOPWoods.UMBRAN);
        this.setPrimitiveLog(primLog, BlockBOPLog.paging.getVariantItem((Enum)BOPWoods.UMBRAN));
        ModContent.leaves.get("umbran").setTree((TreeFamily)this);
        ModContent.leaves.get("umbranconifer").setTree((TreeFamily)this);
        this.hasConiferVariants = true;
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() instanceof BlockBOPLeaves && state.func_177229_b(((BlockBOPLeaves)state.func_177230_c()).variantProperty) == BOPTrees.UMBRAN);
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesUmbran(this));
        this.coniferSpecies = new SpeciesUmbranConifer(this);
        this.megaConiferSpecies = new SpeciesMegaUmbranConifer(this);
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
        speciesRegistry.register((IForgeRegistryEntry)this.coniferSpecies);
        speciesRegistry.register((IForgeRegistryEntry)this.megaConiferSpecies);
    }

    public boolean isThick() {
        return true;
    }

    public List<Item> getRegisterableItems(List<Item> itemList) {
        itemList.add((Item)this.coniferSpecies.getSeed());
        return super.getRegisterableItems(itemList);
    }

    public class SpeciesMegaUmbranConifer
    extends SpeciesRare {
        SpeciesMegaUmbranConifer(TreeFamily treeFamily) {
            super(new ResourceLocation(treeFamily.getName().func_110624_b(), "umbranconifermega"), treeFamily, ModContent.leaves.get("umbranconifer"));
            this.setBasicGrowingParameters(0.3f, 32.0f, 7, 7, 1.0f);
            this.setGrowthLogicKit((IGrowthLogicKit)new ConiferLogic().setHeightVariation(8));
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
            this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
            this.envFactor(BiomeDictionary.Type.SPOOKY, 1.1f);
            this.envFactor(BiomeDictionary.Type.DEAD, 1.1f);
            this.envFactor(BiomeDictionary.Type.MAGICAL, 1.1f);
            this.addAcceptableSoil(new Block[]{BOPBlocks.grass, BOPBlocks.dirt});
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenClearVolume(6));
            this.addGenFeature((IGenFeature)new FeatureGenConiferTopper(this.getLeavesProperties()));
            this.addGenFeature((IGenFeature)new FeatureGenMound(999));
            this.addGenFeature((IGenFeature)new FeatureGenFlareBottom());
        }

        public boolean isBiomePerfect(Biome biome) {
            return SpeciesMegaUmbranConifer.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{(Biome)BOPBiomes.ominous_woods.orNull()});
        }

        public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
            if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
                if (radius > 4 && TreeHelper.isRooty((IBlockState)world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                    world.func_175656_a(pos, random.nextInt(3) == 0 ? ModBlocks.blockStates.redMushroom : ModBlocks.blockStates.brownMushroom);
                    world.func_175656_a(pos.func_177977_b(), BOPBlocks.dirt.func_176223_P().func_177226_a((IProperty)BlockBOPDirt.VARIANT, (Comparable)BlockBOPDirt.BOPDirtType.LOAMY));
                }
                return true;
            }
            return false;
        }

        public ItemStack getSeedStack(int qty) {
            return TreeUmbran.this.coniferSpecies.getSeedStack(qty);
        }

        public Seed getSeed() {
            return TreeUmbran.this.coniferSpecies.getSeed();
        }

        public boolean isThick() {
            return true;
        }
    }

    public class SpeciesUmbranConifer
    extends SpeciesRare {
        SpeciesUmbranConifer(TreeFamily treeFamily) {
            super(new ResourceLocation(treeFamily.getName().func_110624_b(), "umbranconifer"), treeFamily, ModContent.leaves.get("umbranconifer"));
            this.setBasicGrowingParameters(0.25f, 16.0f, 3, 3, 0.8f);
            this.setGrowthLogicKit(TreeRegistry.findGrowthLogicKit((String)"conifer"));
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
            this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
            this.envFactor(BiomeDictionary.Type.SPOOKY, 1.1f);
            this.envFactor(BiomeDictionary.Type.DEAD, 1.1f);
            this.envFactor(BiomeDictionary.Type.MAGICAL, 1.1f);
            this.addAcceptableSoil(new Block[]{BOPBlocks.grass, BOPBlocks.dirt});
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenConiferTopper(this.getLeavesProperties()));
        }

        public boolean isBiomePerfect(Biome biome) {
            return SpeciesUmbranConifer.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{(Biome)BOPBiomes.ominous_woods.orNull()});
        }

        public int maxBranchRadius() {
            return 8;
        }

        public boolean isThick() {
            return false;
        }

        public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
            if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
                if (radius > 4 && TreeHelper.isRooty((IBlockState)world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                    world.func_175656_a(pos, random.nextInt(3) == 0 ? ModBlocks.blockStates.redMushroom : ModBlocks.blockStates.brownMushroom);
                    world.func_175656_a(pos.func_177977_b(), BOPBlocks.dirt.func_176223_P().func_177226_a((IProperty)BlockBOPDirt.VARIANT, (Comparable)BlockBOPDirt.BOPDirtType.LOAMY));
                }
                return true;
            }
            return false;
        }
    }

    public class SpeciesUmbran
    extends Species {
        SpeciesUmbran(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.leaves.get("umbran"));
            this.setBasicGrowingParameters(0.3f, 12.0f, this.upProbability, this.lowestBranchHeight, 0.7f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
            this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
            this.envFactor(BiomeDictionary.Type.SPOOKY, 1.1f);
            this.envFactor(BiomeDictionary.Type.DEAD, 1.1f);
            this.envFactor(BiomeDictionary.Type.MAGICAL, 1.1f);
            this.addAcceptableSoil(new Block[]{BOPBlocks.grass, BOPBlocks.dirt});
            this.generateSeed();
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenVine().setQuantity(7).setMaxLength(6).setRayDistance(6.0f).setVineBlock(BOPBlocks.willow_vine));
        }

        public boolean isBiomePerfect(Biome biome) {
            return SpeciesUmbran.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{(Biome)BOPBiomes.ominous_woods.orNull()});
        }

        public int maxBranchRadius() {
            return 8;
        }

        public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random, boolean rapid) {
            if (super.rot(world, pos, neighborCount, radius, random, rapid)) {
                if (radius > 4 && TreeHelper.isRooty((IBlockState)world.func_180495_p(pos.func_177977_b())) && world.func_175642_b(EnumSkyBlock.SKY, pos) < 4) {
                    world.func_175656_a(pos, random.nextInt(3) == 0 ? ModBlocks.blockStates.redMushroom : ModBlocks.blockStates.brownMushroom);
                    world.func_175656_a(pos.func_177977_b(), BOPBlocks.dirt.func_176223_P().func_177226_a((IProperty)BlockBOPDirt.VARIANT, (Comparable)BlockBOPDirt.BOPDirtType.LOAMY));
                }
                return true;
            }
            return false;
        }
    }
}

