/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees.species;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenBush;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.SpeciesRare;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import dynamictreesbop.ModContent;
import dynamictreesbop.dropcreators.DropCreatorInvoluntarySeed;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class SpeciesAcaciaTwiglet
extends SpeciesRare {
    FeatureGenBush bushGen;

    public SpeciesAcaciaTwiglet(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreesbop", "acaciatwiglet"), treeFamily, ModContent.leaves.get("acaciatwiglet"));
        this.setBasicGrowingParameters(0.3f, 2.5f, 1, 2, 1.0f);
        this.envFactor(BiomeDictionary.Type.SNOWY, 0.25f);
        this.envFactor(BiomeDictionary.Type.DRY, 0.75f);
        this.envFactor(BiomeDictionary.Type.HOT, 1.05f);
        this.addAcceptableSoil(new Block[]{BOPBlocks.grass, BOPBlocks.dirt, Blocks.field_150354_m});
        this.addDropCreator((IDropCreator)new DropCreatorInvoluntarySeed());
        this.remDropCreator(new ResourceLocation("dynamictrees", "logs"));
        this.bushGen = new FeatureGenBush();
        this.leavesProperties.setTree(treeFamily);
    }

    public Species.LogsAndSticks getLogsAndSticks(float volume) {
        return super.getLogsAndSticks(volume * 16.0f);
    }

    public boolean isBiomePerfect(Biome biome) {
        return SpeciesAcaciaTwiglet.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{(Biome)BOPBiomes.xeric_shrubland.orNull(), (Biome)BOPBiomes.outback.orNull()});
    }

    public ItemStack getSeedStack(int qty) {
        return this.getFamily().getCommonSpecies().getSeedStack(qty);
    }

    public Seed getSeed() {
        return this.getFamily().getCommonSpecies().getSeed();
    }

    public boolean generate(World world, BlockPos rootPos, Biome biome, Random random, int radius, SafeChunkBounds safeBounds) {
        if (biome == BOPBiomes.xeric_shrubland.orNull() && world.func_180495_p(rootPos).func_177230_c() instanceof BlockGrass) {
            return this.bushGen.generate(world, rootPos, (Species)this, biome, random, radius, safeBounds);
        }
        return super.generate(world, rootPos, biome, random, radius, safeBounds);
    }
}

