/*
 * Decompiled with CFR 0.152.
 */
package dynamictreesbop.trees.species;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.dropcreators.DropCreatorApple;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenVine;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class SpeciesOakFloweringVine
extends Species {
    Species baseSpecies = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "oak"));

    public SpeciesOakFloweringVine(TreeFamily treeFamily) {
        super(new ResourceLocation("dynamictreesbop", "oakfloweringvine"), treeFamily);
        this.setBasicGrowingParameters(0.3f, 12.0f, this.upProbability, this.lowestBranchHeight, 0.8f);
        this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
        this.envFactor(BiomeDictionary.Type.HOT, 0.75f);
        this.envFactor(BiomeDictionary.Type.DRY, 0.625f);
        this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
        this.addAcceptableSoil(new Block[]{BOPBlocks.grass, BOPBlocks.dirt});
        if (ModConfigs.worldGen && !ModConfigs.enableAppleTrees) {
            this.addDropCreator((IDropCreator)new DropCreatorApple());
        }
        this.setupStandardSeedDropping();
        this.addGenFeature((IGenFeature)new FeatureGenVine().setQuantity(20).setMaxLength(7).setRayDistance(6.0f).setVineBlock(BOPBlocks.ivy));
    }

    public boolean isBiomePerfect(Biome biome) {
        return SpeciesOakFloweringVine.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{(Biome)BOPBiomes.mystic_grove.orNull()});
    }

    public ItemStack getSeedStack(int qty) {
        return this.baseSpecies.getSeedStack(qty);
    }

    public Seed getSeed() {
        return this.baseSpecies.getSeed();
    }

    public int maxBranchRadius() {
        return 8;
    }
}

