/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.containers;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.items.ItemAtlas;
import jds.bibliocraft.items.ItemWaypointCompass;
import jds.bibliocraft.slots.SlotAtlas;
import jds.bibliocraft.slots.SlotAtlasMap;
import jds.bibliocraft.slots.SlotLocked;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public class ContainerAtlas
extends Container {
    private InventoryBasic atlasInventory = new InventoryBasic("AtlasInventory", true, 48);
    private ItemStack atlasStack;
    private int mapSlot;
    protected SlotAtlas atlasSlot;
    protected SlotAtlasMap atlasMapSlot;
    private World world;
    public boolean updatedSlots = false;
    private boolean initalLoad = false;
    EntityPlayer player;
    private int mapsPage = 0;

    public ContainerAtlas(InventoryPlayer inventoryPlayer, World myworld) {
        this.atlasStack = inventoryPlayer.func_70448_g();
        this.world = myworld;
        this.player = inventoryPlayer.field_70458_d;
        this.updateInventory();
        this.resetSlots();
        this.bindPlayerInventory(inventoryPlayer);
    }

    private void resetSlots() {
        int i;
        this.field_75151_b = new ArrayList();
        this.field_75153_a = NonNullList.func_191196_a();
        for (i = 0; i < 6; ++i) {
            this.atlasSlot = new SlotAtlas(this, (IInventory)this.atlasInventory, i, 11 + i * 18, 123);
            this.func_75146_a(this.atlasSlot);
        }
        for (i = 0; i < 7; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.atlasMapSlot = new SlotAtlasMap(this, (IInventory)this.atlasInventory, j + i * 6 + 6 + 42 * this.mapsPage, 138 + j * 18, 15 + i * 18);
                this.func_75146_a(this.atlasMapSlot);
            }
        }
    }

    public void updateInventory() {
        if (this.atlasStack != ItemStack.field_190927_a && this.atlasStack.func_77973_b() instanceof ItemAtlas) {
            NBTTagCompound tags = this.atlasStack.func_77978_p();
            if (tags != null) {
                this.mapSlot = tags.func_74762_e("mapSlot");
                NBTTagList tagList = tags.func_150295_c("Inventory", 10);
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound tag = tagList.func_150305_b(i);
                    byte slot = tag.func_74771_c("Slot");
                    if (slot < 0 || slot >= this.atlasInventory.func_70302_i_()) continue;
                    ItemStack invStack = new ItemStack(tag);
                    this.atlasInventory.func_70299_a((int)slot, invStack);
                }
            }
            this.initalLoad = true;
        }
    }

    public void func_75142_b() {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            ItemStack itemstack = ((Slot)this.field_75151_b.get(i)).func_75211_c();
            ItemStack itemstack1 = (ItemStack)this.field_75153_a.get(i);
            if (ItemStack.func_77989_b((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            itemstack1 = itemstack == ItemStack.field_190927_a ? ItemStack.field_190927_a : itemstack.func_77946_l();
            this.field_75153_a.set(i, (Object)itemstack1);
            for (int j = 0; j < this.field_75149_d.size(); ++j) {
                ((IContainerListener)this.field_75149_d.get(j)).func_71111_a((Container)this, i, itemstack1);
                if (i >= 48) continue;
                this.updatedSlots = true;
            }
        }
        if (this.updatedSlots && this.initalLoad) {
            this.updateClientInventoryAndData();
            this.updatedSlots = false;
        }
    }

    private void updateClientInventoryAndData() {
        NBTTagCompound tags = this.atlasStack.func_77978_p();
        boolean foundCompass = false;
        if (tags != null) {
            if (tags.func_74764_b("savedCompass")) {
                int comp = tags.func_74762_e("savedCompass");
                int xcoord = tags.func_74762_e("compassX");
                int zcoord = tags.func_74762_e("compassZ");
                for (int n = 0; n < 6; ++n) {
                    NBTTagCompound compassTags;
                    ItemStack compStack = (ItemStack)this.field_75153_a.get(n);
                    if (compStack == ItemStack.field_190927_a || !(compStack.func_77973_b() instanceof ItemWaypointCompass) || (compassTags = compStack.func_77978_p()) == null || xcoord != compassTags.func_74762_e("XCoord") || zcoord != compassTags.func_74762_e("ZCoord")) continue;
                    if (n != comp) {
                        tags.func_74768_a("savedCompass", n);
                    }
                    foundCompass = true;
                }
                if (!foundCompass && comp >= 0) {
                    tags.func_74768_a("savedCompass", -1);
                }
            }
            tags.func_74782_a("maps", (NBTBase)this.getUpdatedMapTagList(tags));
            NBTTagList itemList = new NBTTagList();
            for (int i = 0; i < this.atlasInventory.func_70302_i_(); ++i) {
                ItemStack stack = this.atlasInventory.func_70301_a(i);
                if (stack == ItemStack.field_190927_a) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)i);
                stack.func_77955_b(tag);
                itemList.func_74742_a((NBTBase)tag);
            }
            tags.func_74782_a("Inventory", (NBTBase)itemList);
            tags.func_74757_a("containerUpdate", true);
            this.atlasStack.func_77982_d(tags);
            if (!this.world.field_72995_K && this.player instanceof EntityPlayerMP) {
                ByteBuf buffer = Unpooled.buffer();
                ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.atlasStack);
                BiblioCraft.ch_BiblioAtlas.sendTo(new FMLProxyPacket(new PacketBuffer(buffer), "BiblioAtlas"), (EntityPlayerMP)this.player);
            }
            tags.func_74757_a("containerUpdate", false);
            this.atlasStack.func_77982_d(tags);
        }
    }

    public boolean func_75145_c(EntityPlayer entityPlayer) {
        return true;
    }

    public void func_75134_a(EntityPlayer player) {
        this.updateStackOnPlayer(player);
    }

    private void updateStackOnPlayer(EntityPlayer player) {
        ItemStack atlas = player.func_184586_b(EnumHand.MAIN_HAND);
        if (atlas != ItemStack.field_190927_a && atlas.func_77973_b() instanceof ItemAtlas) {
            NBTTagCompound tags = atlas.func_77978_p();
            if (tags == null) {
                tags = new NBTTagCompound();
            }
            if (tags.func_74764_b("savedCompass")) {
                int comp = tags.func_74762_e("savedCompass");
                int xcoord = tags.func_74762_e("compassX");
                int zcoord = tags.func_74762_e("compassZ");
                boolean foundCompass = false;
                for (int n = 0; n < 6; ++n) {
                    NBTTagCompound compassTags;
                    ItemStack compStack = (ItemStack)this.field_75153_a.get(n);
                    if (compStack == ItemStack.field_190927_a || !(compStack.func_77973_b() instanceof ItemWaypointCompass) || (compassTags = compStack.func_77978_p()) == null || xcoord != compassTags.func_74762_e("XCoord") || zcoord != compassTags.func_74762_e("ZCoord")) continue;
                    if (n != comp) {
                        tags.func_74768_a("savedCompass", n);
                    }
                    foundCompass = true;
                }
                if (!foundCompass && comp >= 0) {
                    tags.func_74768_a("savedCompass", -1);
                }
            }
            NBTTagList itemList = new NBTTagList();
            for (int i = 0; i < this.atlasInventory.func_70302_i_(); ++i) {
                ItemStack stack = this.atlasInventory.func_70301_a(i);
                if (stack == ItemStack.field_190927_a) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)i);
                stack.func_77955_b(tag);
                itemList.func_74742_a((NBTBase)tag);
            }
            tags.func_74782_a("Inventory", (NBTBase)itemList);
            if (!tags.func_74764_b("autoCenter") || tags.func_74767_n("autoCenter")) {
                // empty if block
            }
            tags.func_74782_a("maps", (NBTBase)this.getUpdatedMapTagList(tags));
            atlas.func_77982_d(tags);
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, atlas);
        }
    }

    private NBTTagList getUpdatedMapTagList(NBTTagCompound tags) {
        NBTTagList maps = null;
        NBTTagList newMaps = new NBTTagList();
        if (tags != null && tags.func_74764_b("maps")) {
            newMaps = maps = tags.func_150295_c("maps", 10);
        }
        if (this.atlasInventory == null) {
            return newMaps;
        }
        for (int i = 6; i < this.atlasInventory.func_70302_i_(); ++i) {
            MapData mapdata;
            ItemStack currentMap = this.atlasInventory.func_70301_a(i);
            if (currentMap == ItemStack.field_190927_a) continue;
            String mapName = "Map_" + currentMap.func_77952_i();
            boolean foundMap = false;
            NBTTagCompound mapTag = new NBTTagCompound();
            if (maps != null) {
                for (int n = 0; n < maps.func_74745_c(); ++n) {
                    mapTag = maps.func_150305_b(n);
                    if (mapTag == null || !mapTag.func_74764_b("mapName") || !mapTag.func_74779_i("mapName").contentEquals(mapName)) continue;
                    foundMap = true;
                    break;
                }
            }
            if (foundMap || (mapdata = this.getMapData(currentMap)) == null) continue;
            foundMap = true;
            mapTag = new NBTTagCompound();
            mapTag.func_74778_a("mapName", mapName);
            mapTag.func_74768_a("xCenter", mapdata.field_76201_a);
            mapTag.func_74768_a("zCenter", mapdata.field_76199_b);
            mapTag.func_74768_a("mapScale", (int)mapdata.field_76197_d);
            newMaps.func_74742_a((NBTBase)mapTag);
        }
        return newMaps;
    }

    private MapData getMapData(ItemStack stack) {
        MapData mapdata;
        if (stack != ItemStack.field_190927_a && stack.func_77973_b() instanceof ItemMap && (mapdata = Items.field_151098_aY.func_77873_a(stack, this.world)) != null) {
            return mapdata;
        }
        return null;
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        int heldSlot = inventoryPlayer.field_70461_c;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 48 + j * 18, 159 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (i == heldSlot) {
                this.func_75146_a(new SlotLocked((IInventory)inventoryPlayer, i, 48 + i * 18, 217));
                continue;
            }
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 48 + i * 18, 217));
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slot) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slotObject = (Slot)this.field_75151_b.get(slot);
        if (slotObject != null && slotObject.func_75216_d()) {
            ItemStack stackInSlot = slotObject.func_75211_c();
            stack = stackInSlot.func_77946_l();
            Item toolTest = stack.func_77973_b();
            if (slot < 48) {
                if (!this.func_75135_a(stackInSlot, 48, 84, true)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                if (this.atlasSlot.isAtlasItemValid(stackInSlot) && !this.func_75135_a(stackInSlot, 0, 6, false)) {
                    return ItemStack.field_190927_a;
                }
                if (stack.func_190916_E() == 1 && this.atlasMapSlot.isAtlasMapItemValid(stack) && !this.func_75135_a(stackInSlot, 6, 48, false)) {
                    return ItemStack.field_190927_a;
                }
            }
            if (stackInSlot.func_190916_E() == 0) {
                slotObject.func_75215_d(ItemStack.field_190927_a);
            } else {
                slotObject.func_75218_e();
            }
            if (stackInSlot.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slotObject.func_190901_a(player, stackInSlot);
        }
        return stack;
    }

    public ItemStack func_184996_a(int slot, int dragType, ClickType modifier, EntityPlayer player) {
        if (slot == -999) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slot, dragType, modifier, player);
    }
}

