/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.gui;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.containers.ContainerPainting;
import jds.bibliocraft.gui.GuiButtonAddSubtract;
import jds.bibliocraft.gui.GuiButtonClipboard;
import jds.bibliocraft.helpers.BiblioEnums;
import jds.bibliocraft.helpers.EnumPaintingFrame;
import jds.bibliocraft.helpers.PaintingUtil;
import jds.bibliocraft.tileentities.TileEntityPainting;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import org.lwjgl.opengl.GL11;

public class GuiPainting
extends GuiContainer {
    private static int guiWidth = 176;
    private static int guiHeight = 192;
    TileEntityPainting painting;
    private EntityPainting.EnumArt[] vanillaArtList = EntityPainting.EnumArt.values();
    private BiblioEnums.EnumBiblioPaintings[] biblioArtList = BiblioEnums.EnumBiblioPaintings.values();
    private String sScale = I18n.func_74838_a((String)"gui.painting.scale");
    private String sResolution = I18n.func_74838_a((String)"gui.painting.resolution");
    private String sSizeTitle = I18n.func_74838_a((String)"gui.painting.aspectRatio");
    private String sPaintingFinalSize = I18n.func_74838_a((String)"gui.painting.size");
    private String sPaintingRotation = I18n.func_74838_a((String)"gui.painting.rotation");
    private String sCanvasCorner = I18n.func_74838_a((String)"gui.painting.corner");
    private int canvasScale = 1;
    private int canvasResolution = 0;
    private int canvasSize = 0;
    private int canvasCorner = 0;
    private int canvasRotation = 0;
    private GuiButtonAddSubtract bScalePos;
    private GuiButtonAddSubtract bScaleNeg;
    private GuiButtonAddSubtract bResPos;
    private GuiButtonAddSubtract bResNeg;
    private GuiButtonAddSubtract bSizePos;
    private GuiButtonAddSubtract bSizeNeg;
    private GuiButtonAddSubtract bRotPos;
    private GuiButtonAddSubtract bRotNeg;
    private GuiButtonAddSubtract bAspectXPos;
    private GuiButtonAddSubtract bAspectXNeg;
    private GuiButtonAddSubtract bAspectYPos;
    private GuiButtonAddSubtract bAspectYNeg;
    private GuiButton hideFrameButton;
    private String paintingTitle = "";
    private int paintingType = 0;
    private int paintingNumber = 0;
    private int resx = 0;
    private int resy = 0;
    private String rsScale = "";
    private String rsPixelSize = "";
    private String rsAspectRatio = "";
    private String rsFinalSize = "";
    private String[] customArtNames = null;
    private int[] customArtHeights = null;
    private int[] customArtWidths = null;
    private ResourceLocation[] customArtResources = null;
    private int customPaintingAspectX = 1;
    private int customPaintingAspectY = 1;
    private boolean hideFrame = false;
    private EnumPaintingFrame frameType;
    private String hideFrameButtonText = I18n.func_74838_a((String)"gui.painting.hideFrame");

    public GuiPainting(InventoryPlayer inventoryPlayer, TileEntityPainting tile) {
        super((Container)new ContainerPainting(inventoryPlayer, tile));
        this.field_146999_f = guiWidth;
        this.field_147000_g = guiHeight;
        this.painting = tile;
        this.frameType = tile.getFrameStyle();
        this.hideFrame = tile.getHideFrame();
        if (this.hideFrame) {
            this.hideFrameButtonText = I18n.func_74838_a((String)"gui.painting.showFrame");
        }
        this.customArtNames = PaintingUtil.customArtNames;
        if (this.customArtNames != null) {
            this.customArtResources = PaintingUtil.customArtResources;
            this.customArtHeights = PaintingUtil.customArtHeights;
            this.customArtWidths = PaintingUtil.customArtWidths;
        }
        this.initData();
    }

    public void initData() {
        if (this.painting.func_70301_a(0) == ItemStack.field_190927_a) {
            this.paintingTitle = "blank";
            this.paintingType = 0;
            this.canvasCorner = 0;
            this.canvasResolution = 0;
            this.canvasSize = 0;
            this.canvasRotation = 0;
            this.customPaintingAspectX = 1;
            this.customPaintingAspectY = 1;
        } else {
            this.paintingTitle = this.painting.getPaintingTitle();
            this.paintingType = this.painting.getPaintingType();
            this.canvasCorner = this.painting.getPaintingCorner();
            this.canvasScale = this.painting.getPaintingScale();
            this.canvasResolution = this.painting.getPaintingRes();
            this.canvasSize = this.painting.getPaintingAspectRatio();
            this.canvasRotation = this.painting.getPaintingRotation();
            this.customPaintingAspectX = this.painting.getCustomPaintingAspectX();
            this.customPaintingAspectY = this.painting.getCustomPaintingAspectY();
            this.getPaintingNumber();
        }
    }

    private void resetData() {
        this.paintingTitle = "blank";
        this.paintingType = 0;
        this.canvasCorner = 0;
        this.canvasResolution = 0;
        this.canvasSize = 0;
        this.canvasRotation = 0;
        this.customPaintingAspectX = 1;
        this.customPaintingAspectY = 1;
    }

    public void getPaintingNumber() {
        block3: {
            block5: {
                block4: {
                    if (this.paintingType != 0) break block4;
                    for (int i = 0; i < this.biblioArtList.length; ++i) {
                        if (!this.paintingTitle.contentEquals(this.biblioArtList[i].title)) continue;
                        this.paintingNumber = i;
                        break block3;
                    }
                    break block3;
                }
                if (this.paintingType != 1) break block5;
                for (int i = 0; i < this.vanillaArtList.length; ++i) {
                    if (!this.paintingTitle.contentEquals(this.vanillaArtList[i].field_75702_A)) continue;
                    this.paintingNumber = i;
                    break block3;
                }
                break block3;
            }
            if (this.paintingType != 2 || this.customArtNames == null || this.customArtNames.length <= 0) break block3;
            for (int i = 0; i < this.customArtNames.length; ++i) {
                if (!this.paintingTitle.contentEquals(this.customArtNames[i])) continue;
                this.paintingNumber = i;
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int w = (this.field_146294_l - guiWidth) / 2;
        int h = (this.field_146295_m - guiHeight) / 2;
        this.field_146292_n.clear();
        this.bScalePos = new GuiButtonAddSubtract(0, w + 71, h + 14, 0, 1.0f);
        this.field_146292_n.add(this.bScalePos);
        this.bScaleNeg = new GuiButtonAddSubtract(1, w + 6, h + 14, 1, 1.0f);
        this.field_146292_n.add(this.bScaleNeg);
        this.bResPos = new GuiButtonAddSubtract(2, w + 71, h + 40, 0, 1.0f);
        this.field_146292_n.add(this.bResPos);
        this.bResNeg = new GuiButtonAddSubtract(3, w + 6, h + 40, 1, 1.0f);
        this.field_146292_n.add(this.bResNeg);
        this.bSizePos = new GuiButtonAddSubtract(4, w + 71, h + 66, 0, 1.0f);
        this.field_146292_n.add(this.bSizePos);
        this.bSizeNeg = new GuiButtonAddSubtract(5, w + 6, h + 66, 1, 1.0f);
        this.field_146292_n.add(this.bSizeNeg);
        this.bRotPos = new GuiButtonAddSubtract(6, w + 144, h + 92, 0, 1.0f);
        this.field_146292_n.add(this.bRotPos);
        this.bRotNeg = new GuiButtonAddSubtract(7, w + 114, h + 92, 1, 1.0f);
        this.field_146292_n.add(this.bRotNeg);
        this.bAspectXPos = new GuiButtonAddSubtract(8, w + 10, h + 65, 0, 0.7f);
        this.field_146292_n.add(this.bAspectXPos);
        this.bAspectXNeg = new GuiButtonAddSubtract(9, w + 10, h + 73, 1, 0.7f);
        this.field_146292_n.add(this.bAspectXNeg);
        this.bAspectYPos = new GuiButtonAddSubtract(10, w + 71, h + 65, 0, 0.75f);
        this.field_146292_n.add(this.bAspectYPos);
        this.bAspectYNeg = new GuiButtonAddSubtract(11, w + 71, h + 73, 1, 0.75f);
        this.field_146292_n.add(this.bAspectYNeg);
        this.field_146292_n.add(new GuiButtonClipboard(100, w + 106, h + 58, 17, 17, "", false));
        this.field_146292_n.add(new GuiButtonClipboard(100, w + 106, h + 16, 17, 17, "", false));
        this.field_146292_n.add(new GuiButtonClipboard(100, w + 148, h + 58, 17, 17, "", false));
        this.field_146292_n.add(new GuiButtonClipboard(100, w + 148, h + 16, 17, 17, "", false));
        if (this.frameType == EnumPaintingFrame.BORDERLESS) {
            this.hideFrameButton = new GuiButton(12, w + 45, h - 20, 80, 20, this.hideFrameButtonText);
            this.field_146292_n.add(this.hideFrameButton);
        }
    }

    public void func_146281_b() {
        this.sendPacket();
    }

    public void sendPacket() {
        ByteBuf buffer = Unpooled.buffer();
        buffer.writeInt(this.painting.func_174877_v().func_177958_n());
        buffer.writeInt(this.painting.func_174877_v().func_177956_o());
        buffer.writeInt(this.painting.func_174877_v().func_177952_p());
        buffer.writeInt(this.canvasCorner);
        buffer.writeInt(this.canvasScale);
        buffer.writeInt(this.canvasResolution);
        buffer.writeInt(this.canvasSize);
        buffer.writeInt(this.canvasRotation);
        buffer.writeInt(this.customPaintingAspectX);
        buffer.writeInt(this.customPaintingAspectY);
        buffer.writeBoolean(this.hideFrame);
        BiblioCraft.ch_BiblioPainting.sendToServer(new FMLProxyPacket(new PacketBuffer(buffer), "BiblioPainting"));
    }

    protected void func_146284_a(GuiButton click) {
        switch (click.field_146127_k) {
            case 0: {
                this.bScalePos.pressed = true;
                if (this.canvasScale >= 10) break;
                ++this.canvasScale;
                break;
            }
            case 1: {
                this.bScaleNeg.pressed = true;
                if (this.canvasScale <= 1) break;
                --this.canvasScale;
                break;
            }
            case 2: {
                this.bResPos.pressed = true;
                if (this.paintingType == 0) {
                    if (this.canvasResolution >= this.biblioArtList[this.paintingNumber].resolution.length - 1) break;
                    ++this.canvasResolution;
                    break;
                }
                if (this.paintingType == 1 || this.paintingType != 2) break;
                break;
            }
            case 3: {
                this.bResNeg.pressed = true;
                if (this.canvasResolution <= 0) break;
                --this.canvasResolution;
                break;
            }
            case 4: {
                this.bSizePos.pressed = true;
                if (this.paintingType == 0) {
                    if (this.canvasSize >= this.biblioArtList[this.paintingNumber].sizeX.length - 1) break;
                    ++this.canvasSize;
                    break;
                }
                if (this.paintingType == 1 || this.paintingType != 2) break;
                break;
            }
            case 5: {
                this.bSizeNeg.pressed = true;
                if (this.canvasSize <= 0) break;
                --this.canvasSize;
                break;
            }
            case 6: {
                this.bRotPos.pressed = true;
                if (this.canvasRotation < 3) {
                    ++this.canvasRotation;
                    break;
                }
                this.canvasRotation = 0;
                break;
            }
            case 7: {
                this.bRotNeg.pressed = true;
                if (this.canvasRotation > 0) {
                    --this.canvasRotation;
                    break;
                }
                this.canvasRotation = 3;
                break;
            }
            case 8: {
                ++this.customPaintingAspectX;
                break;
            }
            case 9: {
                if (this.customPaintingAspectX <= 1) break;
                --this.customPaintingAspectX;
                break;
            }
            case 10: {
                ++this.customPaintingAspectY;
                break;
            }
            case 11: {
                if (this.customPaintingAspectY <= 1) break;
                --this.customPaintingAspectY;
                break;
            }
            case 12: {
                if (this.hideFrame) {
                    this.hideFrame = false;
                    this.hideFrameButtonText = I18n.func_74838_a((String)"gui.painting.hideFrame");
                } else {
                    this.hideFrame = true;
                    this.hideFrameButtonText = I18n.func_74838_a((String)"gui.painting.showFrame");
                }
                this.func_73866_w_();
            }
        }
    }

    protected void func_73864_a(int mousex, int mousey, int click) {
        try {
            super.func_73864_a(mousex, mousey, click);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int w = (this.field_146294_l - guiWidth) / 2;
        int h = (this.field_146295_m - guiHeight) / 2;
        if (mousex > w + 106 && mousex <= w + 106 + 16 && mousey > h + 59 && mousey <= h + 59 + 16) {
            this.canvasCorner = 0;
        }
        if (mousex > w + 106 && mousex <= w + 106 + 16 && mousey > h + 17 && mousey <= h + 17 + 16) {
            this.canvasCorner = 1;
        }
        if (mousex > w + 148 && mousex <= w + 148 + 16 && mousey > h + 17 && mousey <= h + 17 + 16) {
            this.canvasCorner = 2;
        }
        if (mousex > w + 148 && mousex <= w + 148 + 16 && mousey > h + 59 && mousey <= h + 59 + 16) {
            this.canvasCorner = 3;
        }
        if (mousex > w + 78 && mousex <= w + 80 + 16 && mousey > h + 87 && mousey <= h + 89 + 16) {
            this.resetData();
            this.sendPacket();
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    protected void func_73869_a(char par1, int key) {
        if (key == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    protected void func_146979_b(int var1, int var2) {
        int x = (this.field_146294_l - guiWidth) / 2;
        int y = (this.field_146295_m - guiHeight) / 2;
        if (this.painting.getContainerUpdate()) {
            boolean before = this.paintingTitle.contentEquals("blank");
            this.initData();
            boolean after = this.paintingTitle.contentEquals("blank");
            if (before && !after && this.paintingType == 2) {
                this.resx = this.customArtWidths[this.paintingNumber];
                this.resy = this.customArtHeights[this.paintingNumber];
                if (this.resx <= this.resy) {
                    this.customPaintingAspectX = this.roundNum((float)this.resx * 1.0f / (float)this.resx * 1.0f);
                    this.customPaintingAspectY = this.roundNum((float)this.resy * 1.0f / (float)this.resx * 1.0f);
                } else {
                    this.customPaintingAspectX = this.roundNum((float)this.resx * 1.0f / (float)this.resy * 1.0f);
                    this.customPaintingAspectY = this.roundNum((float)this.resy * 1.0f / (float)this.resy * 1.0f);
                }
            }
            this.painting.setContainterUpdate(false);
        }
    }

    protected void func_146976_a(float floaty, int mousex, int mousey) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.PAINTINGGUI);
        int x = (this.field_146294_l - guiWidth) / 2;
        int y = (this.field_146295_m - guiHeight) / 2;
        this.func_73729_b(x, y, 0, 0, guiWidth, guiHeight);
        switch (this.canvasCorner) {
            case 0: {
                this.func_73729_b(x + 106, y + 59, 0, 211, 16, 16);
                this.func_73729_b(x + 111, y + 48, 20, 218, 22, 22);
                break;
            }
            case 1: {
                this.func_73729_b(x + 106, y + 17, 0, 211, 16, 16);
                this.func_73729_b(x + 111, y + 22, 20, 192, 22, 22);
                break;
            }
            case 2: {
                this.func_73729_b(x + 148, y + 17, 0, 211, 16, 16);
                this.func_73729_b(x + 137, y + 22, 46, 192, 22, 22);
                break;
            }
            case 3: {
                this.func_73729_b(x + 148, y + 59, 0, 211, 16, 16);
                this.func_73729_b(x + 137, y + 48, 46, 218, 22, 22);
            }
        }
        switch (this.canvasRotation) {
            case 0: {
                this.func_73729_b(x + 130, y + 93, 39, 240, 10, 10);
                break;
            }
            case 1: {
                this.func_73729_b(x + 130, y + 93, 49, 240, 10, 10);
                break;
            }
            case 2: {
                this.func_73729_b(x + 130, y + 93, 59, 240, 10, 10);
                break;
            }
            case 3: {
                this.func_73729_b(x + 130, y + 93, 69, 240, 10, 10);
            }
        }
        this.rsScale = this.canvasScale + "x";
        this.field_146289_q.func_78276_b(this.sScale, x + 28, y + 5, 0x404040);
        this.field_146289_q.func_78276_b(this.rsScale, x + 46 - this.rsScale.length() * 8 / 2, y + 16, 0xFFFFFF);
        this.field_146289_q.func_78276_b(this.sResolution, x + 19, y + 31, 0x404040);
        this.field_146289_q.func_78276_b(this.sSizeTitle, x + 12, y + 57, 0x404040);
        this.field_146289_q.func_78276_b(this.sCanvasCorner, x + 97, y + 5, 0x404040);
        this.field_146289_q.func_78276_b(this.sPaintingFinalSize, x + 12, y + 82, 0x404040);
        this.field_146289_q.func_78276_b(this.sPaintingRotation, x + 115, y + 82, 0x404040);
        if (!this.paintingTitle.contentEquals("blank")) {
            if (this.paintingType == 0) {
                this.bAspectXPos.field_146124_l = false;
                this.bAspectXPos.field_146125_m = false;
                this.bAspectXNeg.field_146124_l = false;
                this.bAspectXNeg.field_146125_m = false;
                this.bAspectYPos.field_146124_l = false;
                this.bAspectYPos.field_146125_m = false;
                this.bAspectYNeg.field_146124_l = false;
                this.bAspectYNeg.field_146125_m = false;
                if (this.biblioArtList[this.paintingNumber].resolution.length > 1) {
                    this.bResPos.field_146124_l = true;
                    this.bResPos.field_146125_m = true;
                    this.bResNeg.field_146124_l = true;
                    this.bResNeg.field_146125_m = true;
                } else {
                    this.bResPos.field_146124_l = false;
                    this.bResPos.field_146125_m = false;
                    this.bResNeg.field_146124_l = false;
                    this.bResNeg.field_146125_m = false;
                }
                if (this.biblioArtList[this.paintingNumber].sizeX.length > 1) {
                    this.bSizePos.field_146124_l = true;
                    this.bSizePos.field_146125_m = true;
                    this.bSizeNeg.field_146124_l = true;
                    this.bSizeNeg.field_146125_m = true;
                } else {
                    this.bSizePos.field_146124_l = false;
                    this.bSizePos.field_146125_m = false;
                    this.bSizeNeg.field_146124_l = false;
                    this.bSizeNeg.field_146125_m = false;
                }
                this.resx = this.biblioArtList[this.paintingNumber].resolution[this.canvasResolution] * this.biblioArtList[this.paintingNumber].sizeX[this.canvasSize];
                this.resy = this.biblioArtList[this.paintingNumber].resolution[this.canvasResolution] * this.biblioArtList[this.paintingNumber].sizeY[this.canvasSize];
                if (!this.biblioArtList[this.paintingNumber].title.contentEquals("cornerexplody") && this.resx != this.resy) {
                    if (this.biblioArtList[this.paintingNumber].title.contentEquals("seaofportals") || this.biblioArtList[this.paintingNumber].title.contentEquals("boathouse") || this.biblioArtList[this.paintingNumber].title.contentEquals("raven")) {
                        this.resx /= 4;
                        this.resy /= 4;
                    } else {
                        this.resx /= 2;
                        this.resy /= 2;
                    }
                }
                this.rsAspectRatio = this.biblioArtList[this.paintingNumber].sizeX[this.canvasSize] + ":" + this.biblioArtList[this.paintingNumber].sizeY[this.canvasSize];
                this.rsFinalSize = this.canvasScale * this.biblioArtList[this.paintingNumber].sizeX[this.canvasSize] + " x " + this.canvasScale * this.biblioArtList[this.paintingNumber].sizeY[this.canvasSize];
            } else if (this.paintingType == 1) {
                this.bResPos.field_146124_l = false;
                this.bResPos.field_146125_m = false;
                this.bResNeg.field_146124_l = false;
                this.bResNeg.field_146125_m = false;
                this.bSizePos.field_146124_l = false;
                this.bSizePos.field_146125_m = false;
                this.bSizeNeg.field_146124_l = false;
                this.bSizeNeg.field_146125_m = false;
                this.bAspectXPos.field_146124_l = false;
                this.bAspectXPos.field_146125_m = false;
                this.bAspectXNeg.field_146124_l = false;
                this.bAspectXNeg.field_146125_m = false;
                this.bAspectYPos.field_146124_l = false;
                this.bAspectYPos.field_146125_m = false;
                this.bAspectYNeg.field_146124_l = false;
                this.bAspectYNeg.field_146125_m = false;
                this.resx = this.vanillaArtList[this.paintingNumber].field_75703_B;
                this.resy = this.vanillaArtList[this.paintingNumber].field_75704_C;
                this.rsAspectRatio = (int)((double)this.resx * 1.0 / 16.0) + ":" + (int)((double)this.resy * 1.0 / 16.0);
                this.rsFinalSize = this.canvasScale * (int)((double)this.resx * 1.0 / 16.0) + " x " + this.canvasScale * (int)((double)this.resy * 1.0 / 16.0);
            } else if (this.paintingType == 2) {
                this.bResPos.field_146124_l = false;
                this.bResPos.field_146125_m = false;
                this.bResNeg.field_146124_l = false;
                this.bResNeg.field_146125_m = false;
                this.bSizePos.field_146124_l = false;
                this.bSizePos.field_146125_m = false;
                this.bSizeNeg.field_146124_l = false;
                this.bSizeNeg.field_146125_m = false;
                this.bAspectXPos.field_146124_l = true;
                this.bAspectXPos.field_146125_m = true;
                this.bAspectXNeg.field_146124_l = true;
                this.bAspectXNeg.field_146125_m = true;
                this.bAspectYPos.field_146124_l = true;
                this.bAspectYPos.field_146125_m = true;
                this.bAspectYNeg.field_146124_l = true;
                this.bAspectYNeg.field_146125_m = true;
                if (this.customArtNames != null) {
                    this.resx = this.customArtWidths[this.paintingNumber];
                    this.resy = this.customArtHeights[this.paintingNumber];
                    this.rsAspectRatio = this.customPaintingAspectX + ":" + this.customPaintingAspectY;
                    this.rsFinalSize = this.customPaintingAspectX * this.canvasScale + " x " + this.customPaintingAspectY * this.canvasScale;
                }
            }
            this.rsPixelSize = this.resx + "x" + this.resy;
            this.field_146289_q.func_78276_b(this.rsPixelSize, x + 53 - this.rsPixelSize.length() * 8 / 2, y + 42, 0xFFFFFF);
            this.field_146289_q.func_78276_b(this.rsAspectRatio, x + 50 - this.rsAspectRatio.length() * 8 / 2, y + 68, 0xFFFFFF);
            this.field_146289_q.func_175065_a(this.rsFinalSize, (float)(x + 46 - this.rsFinalSize.length() * 7 / 2), (float)(y + 92), 65280, true);
        } else {
            this.bResPos.field_146124_l = false;
            this.bResPos.field_146125_m = false;
            this.bResNeg.field_146124_l = false;
            this.bResNeg.field_146125_m = false;
            this.bSizePos.field_146124_l = false;
            this.bSizePos.field_146125_m = false;
            this.bSizeNeg.field_146124_l = false;
            this.bSizeNeg.field_146125_m = false;
            this.bAspectXPos.field_146124_l = false;
            this.bAspectXPos.field_146125_m = false;
            this.bAspectXNeg.field_146124_l = false;
            this.bAspectXNeg.field_146125_m = false;
            this.bAspectYPos.field_146124_l = false;
            this.bAspectYPos.field_146125_m = false;
            this.bAspectYNeg.field_146124_l = false;
            this.bAspectYNeg.field_146125_m = false;
        }
    }

    private int roundNum(float num) {
        int roundDown = (int)num;
        float roundTest = num - (float)roundDown;
        if (roundTest >= 0.5f || roundDown == 0) {
            return roundDown + 1;
        }
        return roundDown;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }
}

