/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.models;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.blocks.BiblioWoodBlock;
import jds.bibliocraft.helpers.ModelCache;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ModelSeatBacks
implements IBakedModel {
    private IBakedModel baseModel;
    List<String> modelParts;
    IModel model = null;
    private String woodTextureString = "none";
    private CustomItemOverrideList overrides = new CustomItemOverrideList();
    public IBakedModel wrapper;
    private ModelCache cache;
    private boolean gotOBJ = false;
    protected Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            String texture = location.toString();
            if (texture.contains("minecraft:blocks/planks_spruce")) {
                texture = ModelSeatBacks.this.woodTextureString;
            }
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(texture);
        }
    };

    public ModelSeatBacks(IBakedModel model) {
        this.modelParts = new ArrayList<String>();
        this.modelParts = this.getModelParts(this.modelParts);
        this.wrapper = this;
        this.cache = new ModelCache();
    }

    public abstract List<String> getModelParts(List<String> var1);

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        if (this.baseModel.func_177554_e() == null) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b("minecraft:blocks/planks_oak");
        }
        return this.baseModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public boolean func_177555_b() {
        return false;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation transform = new TRSRTransformation(ModelRotation.X0_Y90);
        switch (cameraTransformType) {
            case FIRST_PERSON_RIGHT_HAND: {
                transform = new TRSRTransformation(new Vector3f(1.2f, -0.6f, 0.5f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case FIRST_PERSON_LEFT_HAND: {
                transform = new TRSRTransformation(new Vector3f(1.25f, -0.6f, -1.6f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f));
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                transform = new TRSRTransformation(new Vector3f(0.2f, -0.45f, 0.1f), new Quat4f(0.7f, 0.0f, 0.2f, 1.0f), new Vector3f(0.5f, 0.5f, 0.5f), new Quat4f(0.0f, -0.3f, 0.0f, 1.0f));
                break;
            }
            case THIRD_PERSON_LEFT_HAND: {
                transform = new TRSRTransformation(new Vector3f(0.2f, 0.5f, -0.5f), new Quat4f(0.7f, 1.0f, 0.2f, 1.0f), new Vector3f(0.5f, 0.5f, 0.5f), new Quat4f(0.0f, 1.3f, 0.0f, 1.0f));
                break;
            }
            case GUI: {
                transform = this.getAdjustedGUITransform(transform);
                break;
            }
            case GROUND: {
                transform = new TRSRTransformation(new Vector3f(0.3f, -0.2f, 0.42f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(0.4f, 0.4f, 0.4f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case FIXED: {
                transform = new TRSRTransformation(new Vector3f(-0.91f, -0.4f, 0.6f), new Quat4f(0.0f, -1.0f, 0.0f, 1.0f), new Vector3f(0.9f, 0.9f, 0.9f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
        }
        return Pair.of((Object)this, (Object)transform.getMatrix());
    }

    public abstract TRSRTransformation getAdjustedGUITransform(TRSRTransformation var1);

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        try {
            List q = this.baseModel.func_188616_a(state, side, rand);
            return q;
        }
        catch (NullPointerException e) {
            return new ArrayList<BakedQuad>();
        }
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    private class CustomItemOverrideList
    extends ItemOverrideList {
        private CustomItemOverrideList() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nonnull World world, @Nonnull EntityLivingBase entity) {
            String customTextureLocation = "none";
            NBTTagCompound tags = stack.func_77978_p();
            if (tags != null && tags.func_74764_b("renderTexture")) {
                customTextureLocation = tags.func_74779_i("renderTexture");
            }
            switch (BiblioWoodBlock.EnumWoodType.getEnum(stack.func_77952_i())) {
                case OAK: {
                    ModelSeatBacks.this.woodTextureString = "minecraft:blocks/planks_oak";
                    break;
                }
                case SPRUCE: {
                    ModelSeatBacks.this.woodTextureString = "minecraft:blocks/planks_spruce";
                    break;
                }
                case BIRCH: {
                    ModelSeatBacks.this.woodTextureString = "minecraft:blocks/planks_birch";
                    break;
                }
                case JUNGLE: {
                    ModelSeatBacks.this.woodTextureString = "minecraft:blocks/planks_jungle";
                    break;
                }
                case ACACIA: {
                    ModelSeatBacks.this.woodTextureString = "minecraft:blocks/planks_acacia";
                    break;
                }
                case DARKOAK: {
                    ModelSeatBacks.this.woodTextureString = "minecraft:blocks/planks_big_oak";
                    break;
                }
                case FRAME: {
                    if (customTextureLocation.contains("none") || customTextureLocation.contains("minecraft:white")) {
                        ModelSeatBacks.this.woodTextureString = "bibliocraft:blocks/frame";
                        break;
                    }
                    ModelSeatBacks.this.woodTextureString = customTextureLocation;
                    break;
                }
                default: {
                    ModelSeatBacks.this.woodTextureString = "minecraft:blocks/planks_oak";
                }
            }
            if (ModelSeatBacks.this.model == null || ModelSeatBacks.this.model != null && !ModelSeatBacks.this.model.toString().contains("obj.OBJModel")) {
                try {
                    ModelSeatBacks.this.model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("bibliocraft:block/seat.obj"));
                    ModelSeatBacks.this.model = ModelSeatBacks.this.model.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
                    ModelSeatBacks.this.gotOBJ = true;
                }
                catch (Exception e) {
                    ModelSeatBacks.this.model = ModelLoaderRegistry.getMissingModel();
                }
                ModelSeatBacks.this.model = ModelSeatBacks.this.model.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
            }
            if (ModelSeatBacks.this.cache.hasModel(ModelSeatBacks.this.woodTextureString)) {
                ModelSeatBacks.this.baseModel = ModelSeatBacks.this.cache.getCurrentMatch();
            } else {
                TRSRTransformation transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                OBJModel.OBJState partList = new OBJModel.OBJState(ModelSeatBacks.this.modelParts, true, (IModelState)transform);
                IBakedModel bakedModel = ModelSeatBacks.this.model.bake((IModelState)partList, DefaultVertexFormats.field_176599_b, ModelSeatBacks.this.textureGetter);
                if (ModelSeatBacks.this.gotOBJ) {
                    ModelSeatBacks.this.cache.addToCache(bakedModel, ModelSeatBacks.this.woodTextureString);
                }
                ModelSeatBacks.this.baseModel = bakedModel;
            }
            return ModelSeatBacks.this.wrapper;
        }
    }
}

