/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.rendering;

import java.util.ArrayList;
import jds.bibliocraft.helpers.EnumShiftPosition;
import jds.bibliocraft.helpers.EnumVertPosition;
import jds.bibliocraft.rendering.TileEntityBiblioRenderer;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityClock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class TileEntityClockRenderer
extends TileEntityBiblioRenderer {
    private ResourceLocation modelLocation = new ResourceLocation("bibliocraft:block/clock.obj");
    private IBakedModel minHand;
    private IBakedModel hourHand;
    private IBakedModel smallPendulum;
    private IBakedModel largePendulum;
    private IBlockState state;

    @Override
    public void render(BiblioTileEntity tile, double x, double y, double z, float tick) {
        TileEntityClock clock = (TileEntityClock)tile;
        if (this.state == null) {
            this.state = clock.func_145831_w().func_180495_p(clock.func_174877_v());
        }
        if (this.minHand == null || this.hourHand == null || this.smallPendulum == null || this.largePendulum == null || this.tessellator == null || this.worldRenderer == null) {
            ArrayList<String> hourPart = new ArrayList<String>();
            hourPart.add("hour");
            ArrayList<String> minPart = new ArrayList<String>();
            minPart.add("second");
            ArrayList<String> smallPendulumPart = new ArrayList<String>();
            smallPendulumPart.add("smallPendulum");
            ArrayList<String> largePendulumPart = new ArrayList<String>();
            largePendulumPart.add("largePendulum");
            this.minHand = this.initModel(minPart, this.modelLocation);
            this.hourHand = this.initModel(hourPart, this.modelLocation);
            this.smallPendulum = this.initModel(smallPendulumPart, this.modelLocation);
            this.largePendulum = this.initModel(largePendulumPart, this.modelLocation);
        }
        this.func_147499_a(TextureMap.field_110575_b);
        if (this.getVertPosition() == EnumVertPosition.WALL || this.getVertPosition() == EnumVertPosition.CEILING) {
            this.renderPart(this.minHand, 0.5, 0.715, 0.25, clock.secondCount);
            this.renderPart(this.hourHand, 0.5, 0.715, 0.25, clock.hourCount);
        }
        if (this.getVertPosition() == EnumVertPosition.WALL) {
            this.renderPart(this.smallPendulum, 0.5, 0.5, 0.21, clock.pendulumCount);
        } else if (this.getVertPosition() == EnumVertPosition.CEILING) {
            this.renderPart(this.largePendulum, 0.5, 0.5, 0.21, clock.pendulumCount);
        }
    }

    private void renderPart(IBakedModel model, double x, double y, double z, float rotation) {
        switch (this.getAngle()) {
            case SOUTH: {
                double tx = x;
                x = -z;
                z = tx;
                break;
            }
            case WEST: {
                x *= -1.0;
                z *= -1.0;
                break;
            }
            case NORTH: {
                double tx = x;
                x = z;
                z = -tx;
                break;
            }
            case EAST: {
                break;
            }
        }
        float halfShift = 0.35f;
        float fullShift = 0.675f;
        switch (this.getAngle()) {
            case SOUTH: {
                this.degreeAngle = 270;
                this.xshift = 1.0f;
                this.zshift = 0.0f;
                if (this.getShiftPosition() == EnumShiftPosition.FULL_SHIFT) {
                    this.xshift += -fullShift;
                    this.zshift += 0.0f;
                }
                if (this.getShiftPosition() != EnumShiftPosition.HALF_SHIFT) break;
                this.xshift += -halfShift;
                this.zshift += 0.0f;
                break;
            }
            case WEST: {
                this.degreeAngle = 180;
                this.xshift = 1.0f;
                this.zshift = 1.0f;
                if (this.getShiftPosition() == EnumShiftPosition.FULL_SHIFT) {
                    this.xshift += 0.0f;
                    this.zshift += -fullShift;
                }
                if (this.getShiftPosition() != EnumShiftPosition.HALF_SHIFT) break;
                this.xshift += 0.0f;
                this.zshift += -halfShift;
                break;
            }
            case NORTH: {
                this.degreeAngle = 90;
                this.xshift = 0.0f;
                this.zshift = 1.0f;
                if (this.getShiftPosition() == EnumShiftPosition.FULL_SHIFT) {
                    this.xshift += fullShift;
                    this.zshift += 0.0f;
                }
                if (this.getShiftPosition() != EnumShiftPosition.HALF_SHIFT) break;
                this.xshift += halfShift;
                this.zshift += 0.0f;
                break;
            }
            case EAST: {
                this.degreeAngle = 0;
                this.xshift = 0.0f;
                this.zshift = 0.0f;
                if (this.getShiftPosition() == EnumShiftPosition.FULL_SHIFT) {
                    this.xshift += 0.0f;
                    this.zshift += fullShift;
                }
                if (this.getShiftPosition() != EnumShiftPosition.HALF_SHIFT) break;
                this.xshift += 0.0f;
                this.zshift += halfShift;
                break;
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179137_b((double)(this.globalX + (double)this.xshift + x), (double)(this.globalY + y), (double)(this.globalZ + (double)this.zshift + z));
        GlStateManager.func_179114_b((float)((float)this.degreeAngle + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotation, (float)1.0f, (float)0.0f, (float)0.0f);
        this.worldRenderer.func_181668_a(7, Attributes.DEFAULT_BAKED_FORMAT);
        for (BakedQuad quad : model.func_188616_a(null, null, 0L)) {
            LightUtil.renderQuadColor((BufferBuilder)this.worldRenderer, (BakedQuad)quad, (int)-1);
        }
        this.tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }
}

