/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.blocks.BlockSecurityCamera;
import net.geforcemods.securitycraft.entity.EntitySecurityCamera;
import net.geforcemods.securitycraft.entity.EntitySentry;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.tileentity.TileEntitySecurityCamera;
import net.geforcemods.securitycraft.util.GuiUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="securitycraft")
public class SCClientEventHandler {
    public static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");

    @SubscribeEvent
    public static void onScreenshot(ScreenshotEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)player)) {
            EntitySecurityCamera camera = (EntitySecurityCamera)player.func_184187_bx();
            if (camera.screenshotSoundCooldown == 0) {
                camera.screenshotSoundCooldown = 7;
                Minecraft.func_71410_x().field_71441_e.func_184156_a(player.func_180425_c(), SCSounds.CAMERASNAP.event, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRendered(RenderPlayerEvent.Pre event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.getEntityPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71439_g.func_184187_bx().func_180425_c().equals((Object)event.getTarget().func_178782_a())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (Minecraft.func_71410_x().field_71439_g != null && PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) {
            if (event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE && Minecraft.func_71410_x().field_71441_e.func_180495_p(Minecraft.func_71410_x().field_71439_g.func_184187_bx().func_180425_c()).func_177230_c() instanceof BlockSecurityCamera) {
                GuiUtils.drawCameraOverlay(Minecraft.func_71410_x(), (Gui)Minecraft.func_71410_x().field_71456_v, event.getResolution(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (World)Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().field_71439_g.func_184187_bx().func_180425_c());
            }
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            World world = player.func_130014_f_();
            for (EnumHand hand : EnumHand.values()) {
                Entity hitEntity;
                Object[] coords;
                int i;
                RayTraceResult mop;
                ItemStack stack = player.func_184586_b(hand);
                int uCoord = 0;
                if (stack.func_77973_b() == SCContent.cameraMonitor) {
                    double eyeHeight = player.func_70047_e();
                    Vec3d lookVec = new Vec3d(player.field_70165_t + player.func_70040_Z().field_72450_a * 5.0, eyeHeight + player.field_70163_u + player.func_70040_Z().field_72448_b * 5.0, player.field_70161_v + player.func_70040_Z().field_72449_c * 5.0);
                    mop = world.func_72933_a(new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v), lookVec);
                    if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK && world.func_175625_s(mop.func_178782_a()) instanceof TileEntitySecurityCamera) {
                        uCoord = 110;
                        NBTTagCompound cameras = stack.func_77978_p();
                        if (cameras != null) {
                            for (i = 1; i < 31; ++i) {
                                if (!cameras.func_74764_b("Camera" + i) || Integer.parseInt((coords = cameras.func_74779_i("Camera" + i).split(" "))[0]) != mop.func_178782_a().func_177958_n() || Integer.parseInt(coords[1]) != mop.func_178782_a().func_177956_o() || Integer.parseInt(coords[2]) != mop.func_178782_a().func_177952_p()) continue;
                                uCoord = 88;
                                break;
                            }
                        }
                    }
                } else if (stack.func_77973_b() == SCContent.remoteAccessMine) {
                    double eyeHeight = player.func_70047_e();
                    Vec3d lookVec = new Vec3d(player.field_70165_t + player.func_70040_Z().field_72450_a * 5.0, eyeHeight + player.field_70163_u + player.func_70040_Z().field_72448_b * 5.0, player.field_70161_v + player.func_70040_Z().field_72449_c * 5.0);
                    mop = world.func_72933_a(new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v), lookVec);
                    if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK && world.func_180495_p(mop.func_178782_a()).func_177230_c() instanceof IExplosive) {
                        uCoord = 110;
                        NBTTagCompound mines = stack.func_77978_p();
                        if (mines != null) {
                            for (i = 1; i <= 6; ++i) {
                                if (stack.func_77978_p().func_74759_k("mine" + i).length <= 0 || (coords = (Object[])mines.func_74759_k("mine" + i))[0] != mop.func_178782_a().func_177958_n() || coords[1] != mop.func_178782_a().func_177956_o() || coords[2] != mop.func_178782_a().func_177952_p()) continue;
                                uCoord = 88;
                                break;
                            }
                        }
                    }
                } else if (stack.func_77973_b() == SCContent.remoteAccessSentry && (hitEntity = Minecraft.func_71410_x().field_147125_j) instanceof EntitySentry) {
                    uCoord = 110;
                    NBTTagCompound sentries = stack.func_77978_p();
                    if (sentries != null) {
                        for (int i2 = 1; i2 <= 12; ++i2) {
                            int[] coords2;
                            if (stack.func_77978_p().func_74759_k("sentry" + i2).length <= 0 || (coords2 = sentries.func_74759_k("sentry" + i2))[0] != hitEntity.func_180425_c().func_177958_n() || coords2[1] != hitEntity.func_180425_c().func_177956_o() || coords2[2] != hitEntity.func_180425_c().func_177952_p()) continue;
                            uCoord = 88;
                            break;
                        }
                    }
                }
                if (uCoord == 0) continue;
                GlStateManager.func_179141_d();
                Minecraft.func_71410_x().field_71446_o.func_110577_a(BEACON_GUI);
                SCClientEventHandler.drawNonStandardTexturedRect(event.getResolution().func_78326_a() / 2 - 90 + (hand == EnumHand.MAIN_HAND ? player.field_71071_by.field_70461_c * 20 : -29), event.getResolution().func_78328_b() - 22, uCoord, 219, 21, 22, 256, 256);
                GlStateManager.func_179118_c();
            }
        }
    }

    @SubscribeEvent
    public static void fovUpdateEvent(FOVUpdateEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.getEntity())) {
            event.setNewfov(((EntitySecurityCamera)event.getEntity().func_184187_bx()).getZoomAmount());
        }
    }

    @SubscribeEvent
    public static void renderHandEvent(RenderHandEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onMouseClicked(MouseEvent event) {
        if (Minecraft.func_71410_x().field_71441_e != null && PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)Minecraft.func_71410_x().field_71439_g) && event.getButton() != 1) {
            event.setCanceled(true);
        }
    }

    private static void drawNonStandardTexturedRect(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        double z = 200.0;
        double widthFactor = 1.0 / (double)textureWidth;
        double heightFactor = 1.0 / (double)textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), z).func_187315_a((double)u * widthFactor, (double)(v + height) * heightFactor).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), z).func_187315_a((double)(u + width) * widthFactor, (double)(v + height) * heightFactor).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, z).func_187315_a((double)(u + width) * widthFactor, (double)v * heightFactor).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, z).func_187315_a((double)u * widthFactor, (double)v * heightFactor).func_181675_d();
        tessellator.func_78381_a();
    }
}

