/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.EnumLinkedAction;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordConvertible;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.geforcemods.securitycraft.blocks.BlockDisguisable;
import net.geforcemods.securitycraft.blocks.BlockSecurityCamera;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.entity.EntitySecurityCamera;
import net.geforcemods.securitycraft.entity.EntitySentry;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.misc.PortalSize;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.misc.SCWorldListener;
import net.geforcemods.securitycraft.network.client.PlaySoundAtPos;
import net.geforcemods.securitycraft.tileentity.IEMPAffected;
import net.geforcemods.securitycraft.tileentity.TileEntityDisguisable;
import net.geforcemods.securitycraft.tileentity.TileEntitySecurityCamera;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber(modid="securitycraft")
public class SCEventHandler {
    private static final String PREVIOUS_PLAYER_POS_NBT = "SecurityCraftPreviousPlayerPos";
    public static HashMap<String, String> tipsWithLink = new HashMap();

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (player.getEntityData().func_74764_b(PREVIOUS_PLAYER_POS_NBT)) {
            BlockPos pos = BlockPos.func_177969_a((long)player.getEntityData().func_74763_f(PREVIOUS_PLAYER_POS_NBT));
            player.getEntityData().func_82580_o(PREVIOUS_PLAYER_POS_NBT);
            player.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }
        if (ConfigHandler.sayThanksMessage) {
            String tipKey = SCEventHandler.getRandomTip();
            ITextComponent message = new TextComponentString("[" + TextFormatting.GOLD + "SecurityCraft" + TextFormatting.WHITE + "] ").func_150257_a((ITextComponent)Utils.localize("messages.securitycraft:thanks", SecurityCraft.getVersion())).func_150257_a((ITextComponent)new TextComponentString(" ")).func_150257_a((ITextComponent)Utils.localize("messages.securitycraft:tip", new Object[0])).func_150257_a((ITextComponent)new TextComponentString(" ")).func_150257_a((ITextComponent)Utils.localize(tipKey, new Object[0]));
            if (tipsWithLink.containsKey(tipKey.split("\\.")[2])) {
                message.func_150257_a((ITextComponent)new TextComponentString(" ")).func_150257_a(ForgeHooks.newChatWithLinks((String)tipsWithLink.get(tipKey.split("\\.")[2])));
            }
            player.func_145747_a(message);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)player)) {
            BlockPos pos = new BlockPos((Vec3i)((EntitySecurityCamera)player.func_184187_bx()).getPreviousPlayerPos());
            player.func_184187_bx().func_70106_y();
            player.getEntityData().func_74772_a(PREVIOUS_PLAYER_POS_NBT, pos.func_177986_g());
        }
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingHurtEvent event) {
        if (event.getEntityLiving() != null && PlayerUtils.isPlayerMountedOnCamera(event.getEntityLiving())) {
            event.setCanceled(true);
            return;
        }
        if (event.getSource() == CustomDamageSources.ELECTRICITY) {
            SecurityCraft.network.sendToAll((IMessage)new PlaySoundAtPos(event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, SCSounds.ELECTRIFIED.path, 0.25, "block"));
        }
    }

    @SubscribeEvent
    public static void onBucketUsed(FillBucketEvent event) {
        ItemStack result;
        BlockPos pos;
        if (event.getTarget() == null) {
            return;
        }
        World world = event.getWorld();
        Block block = world.func_180495_p(pos = event.getTarget().func_178782_a()).func_177230_c();
        if (block == SCContent.fakeWater) {
            result = new ItemStack(SCContent.fWaterBucket, 1);
        } else if (block == SCContent.fakeLava) {
            result = new ItemStack(SCContent.fLavaBucket, 1);
        } else {
            return;
        }
        world.func_175698_g(pos);
        event.setFilledBucket(result);
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.getEntityPlayer())) {
            event.setCanceled(true);
            return;
        }
        World world = event.getWorld();
        TileEntity tileEntity = world.func_175625_s(event.getPos());
        if (event.getItemStack().func_77973_b() == Items.field_151137_ax && tileEntity instanceof IEMPAffected && ((IEMPAffected)tileEntity).isShutDown()) {
            ((IEMPAffected)tileEntity).reactivate();
            if (!event.getEntityPlayer().func_184812_l_()) {
                event.getItemStack().func_190918_g(1);
            }
            event.getEntityPlayer().func_184609_a(event.getHand());
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
            return;
        }
        Block block = world.func_180495_p(event.getPos()).func_177230_c();
        if (PlayerUtils.isHoldingItem(event.getEntityPlayer(), SCContent.keyPanel, event.getHand())) {
            for (IPasswordConvertible pc : SecurityCraftAPI.getRegisteredPasswordConvertibles()) {
                if (pc.getOriginalBlock() != block) continue;
                event.setUseBlock(Event.Result.DENY);
                event.setUseItem(Event.Result.ALLOW);
            }
            return;
        }
        if (PlayerUtils.isHoldingItem(event.getEntityPlayer(), SCContent.codebreaker, event.getHand()) && SCEventHandler.handleCodebreaking(event)) {
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
            return;
        }
        if (PlayerUtils.isHoldingItem(event.getEntityPlayer(), SCContent.universalBlockModifier, event.getHand()) && tileEntity instanceof IModuleInventory) {
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
            if (tileEntity instanceof IOwnable && !((IOwnable)tileEntity).getOwner().isOwner(event.getEntityPlayer())) {
                if (!(tileEntity instanceof TileEntityDisguisable) || ((ItemBlock)((BlockDisguisable)((TileEntityDisguisable)tileEntity).func_145838_q()).getDisguisedStack((IBlockAccess)world, event.getPos()).func_77973_b()).func_179223_d() instanceof BlockDisguisable) {
                    PlayerUtils.sendMessageToPlayer(event.getEntityPlayer(), (ITextComponent)Utils.localize("item.securitycraft:universalBlockModifier.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:notOwned", ((IOwnable)tileEntity).getOwner().getName()), TextFormatting.RED);
                }
                return;
            }
            event.getEntityPlayer().openGui((Object)SecurityCraft.instance, 100, world, event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p());
            return;
        }
        if (tileEntity instanceof INameable && ((INameable)tileEntity).canBeNamed() && PlayerUtils.isHoldingItem(event.getEntityPlayer(), Items.field_151057_cb, event.getHand()) && event.getEntityPlayer().func_184586_b(event.getHand()).func_82837_s()) {
            ItemStack nametag = event.getEntityPlayer().func_184586_b(event.getHand());
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
            if (((INameable)tileEntity).getCustomName().equals(nametag.func_82833_r())) {
                PlayerUtils.sendMessageToPlayer(event.getEntityPlayer(), (ITextComponent)Utils.localize(event.getWorld().func_180495_p(event.getPos()).func_177230_c().func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:naming.alreadyMatches", ((INameable)tileEntity).getCustomName()), TextFormatting.RED);
                return;
            }
            if (!event.getEntityPlayer().func_184812_l_()) {
                nametag.func_190918_g(1);
            }
            if (!world.field_72995_K) {
                ((INameable)tileEntity).setCustomName(nametag.func_82833_r());
            }
            PlayerUtils.sendMessageToPlayer(event.getEntityPlayer(), (ITextComponent)Utils.localize(event.getWorld().func_180495_p(event.getPos()).func_177230_c().func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:naming.named", ((INameable)tileEntity).getCustomName()), TextFormatting.GREEN);
            return;
        }
        List sentries = world.func_72872_a(EntitySentry.class, new AxisAlignedBB(event.getPos()));
        if (!sentries.isEmpty()) {
            event.setCanceled(((EntitySentry)((Object)sentries.get(0))).func_184645_a(event.getEntityPlayer(), event.getHand()));
            event.setCancellationResult(EnumActionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.getEntityPlayer())) {
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.FAIL);
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.getEntityPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityInteracted(PlayerInteractEvent.EntityInteract event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.getEntityPlayer())) {
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.FAIL);
        }
    }

    @SubscribeEvent
    public static void onBlockEventBreak(BlockEvent.BreakEvent event) {
        ItemStack disguiseModule;
        ArrayList<Block> blocks;
        List sentries;
        if (!event.getWorld().field_72995_K) {
            BlockPos pos = event.getPos();
            World world = event.getWorld();
            if (world.func_175625_s(pos) instanceof IModuleInventory) {
                IModuleInventory te = (IModuleInventory)world.func_175625_s(pos);
                int i = 100;
                while (i - 100 < te.getMaxNumberOfModules()) {
                    if (!te.getStackInSlot(i).func_190926_b()) {
                        ItemStack stack = te.getStackInSlot(i);
                        EntityItem item = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
                        WorldUtils.addScheduledTask(world, () -> world.func_72838_d((Entity)item));
                        te.onModuleRemoved(stack, ((ItemModule)stack.func_77973_b()).getModuleType());
                        if (te instanceof CustomizableSCTE) {
                            ((CustomizableSCTE)te).createLinkedBlockAction(EnumLinkedAction.MODULE_REMOVED, new Object[]{stack, ((ItemModule)stack.func_77973_b()).getModuleType()}, (CustomizableSCTE)te);
                        }
                        if (te instanceof TileEntitySecurityCamera) {
                            TileEntitySecurityCamera cam = (TileEntitySecurityCamera)te;
                            cam.func_145831_w().func_175685_c(cam.func_174877_v().func_177967_a((EnumFacing)cam.func_145831_w().func_180495_p(cam.func_174877_v()).func_177229_b((IProperty)BlockSecurityCamera.FACING), -1), cam.func_145831_w().func_180495_p(cam.func_174877_v()).func_177230_c(), true);
                        }
                    }
                    ++i;
                }
            }
        }
        if (!(sentries = event.getWorld().func_72872_a(EntitySentry.class, new AxisAlignedBB(event.getPos()))).isEmpty() && !((EntitySentry)((Object)sentries.get(0))).getDisguiseModule().func_190926_b() && (blocks = ((ItemModule)(disguiseModule = ((EntitySentry)((Object)sentries.get(0))).getDisguiseModule()).func_77973_b()).getBlockAddons(disguiseModule.func_77978_p())).size() > 0 && blocks.get(0) == event.getWorld().func_180495_p(event.getPos()).func_177230_c()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("securitycraft")) {
            ConfigManager.sync((String)"securitycraft", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void onOwnership(OwnershipEvent event) {
        TileEntity te = event.getWorld().func_175625_s(event.getPos());
        if (te instanceof IOwnable) {
            String name = event.getPlayer().func_70005_c_();
            String uuid = event.getPlayer().func_146103_bH().getId().toString();
            ((IOwnable)te).setOwner(uuid, name);
        }
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.PlaceEvent event) {
        if (event.getState().func_177230_c() == Blocks.field_150480_ab && event.getWorld().func_180495_p(event.getPos().func_177977_b()).func_177230_c() == SCContent.reinforcedObsidian) {
            PortalSize portalSize = new PortalSize(event.getWorld(), event.getPos(), EnumFacing.Axis.X);
            if (portalSize.isValid() && portalSize.getPortalBlockCount() == 0) {
                portalSize.placePortalBlocks();
            } else {
                portalSize = new PortalSize(event.getWorld(), event.getPos(), EnumFacing.Axis.Z);
                if (portalSize.isValid() && portalSize.getPortalBlockCount() == 0) {
                    portalSize.placePortalBlocks();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getWorld().field_72995_K) {
            BlockPos pos = event.getEntity().func_180425_c();
            do {
                Object portalSize;
                if (event.getWorld().func_180495_p(pos).func_177230_c() == Blocks.field_150343_Z) {
                    portalSize = new BlockPortal.Size(event.getWorld(), pos, EnumFacing.Axis.X);
                    if (portalSize.func_150860_b()) {
                        double y = (double)pos.func_177956_o() + 0.5;
                        if (event.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) {
                            y -= 3.0;
                        }
                        event.getEntity().func_70107_b((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
                        break;
                    }
                    portalSize = new BlockPortal.Size(event.getWorld(), pos, EnumFacing.Axis.Z);
                    if (!portalSize.func_150860_b()) continue;
                    double y = (double)pos.func_177956_o() + 0.5;
                    if (event.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) {
                        y -= 3.0;
                    }
                    event.getEntity().func_70107_b((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
                    break;
                }
                if (event.getWorld().func_180495_p(pos).func_177230_c() != SCContent.reinforcedObsidian) continue;
                portalSize = new PortalSize(event.getWorld(), pos, EnumFacing.Axis.X);
                if (((PortalSize)portalSize).isValid()) {
                    double y = (double)pos.func_177956_o() + 0.5;
                    if (event.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) {
                        y -= 3.0;
                    }
                    event.getEntity().func_70107_b((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
                    break;
                }
                portalSize = new PortalSize(event.getWorld(), pos, EnumFacing.Axis.Z);
                if (!((PortalSize)portalSize).isValid()) continue;
                double y = (double)pos.func_177956_o() + 0.5;
                if (event.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) {
                    y -= 3.0;
                }
                event.getEntity().func_70107_b((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
                break;
            } while ((pos = pos.func_177984_a()).func_177956_o() < Math.min(event.getWorld().func_72800_K(), 256));
        }
    }

    @SubscribeEvent
    public static void onNeighborNotify(BlockEvent.NeighborNotifyEvent event) {
        if (event.getState().func_177230_c() == Blocks.field_150427_aO) {
            PortalSize portalSize;
            EnumFacing.Axis axis = (EnumFacing.Axis)event.getState().func_177229_b((IProperty)BlockPortal.field_176550_a);
            if (axis == EnumFacing.Axis.X) {
                PortalSize portalSize2 = new PortalSize(event.getWorld(), event.getPos(), EnumFacing.Axis.X);
                if (portalSize2.isValid() || portalSize2.getPortalBlockCount() > portalSize2.getWidth() * portalSize2.getHeight()) {
                    event.setCanceled(true);
                }
            } else if (axis == EnumFacing.Axis.Z && ((portalSize = new PortalSize(event.getWorld(), event.getPos(), EnumFacing.Axis.Z)).isValid() || portalSize.getPortalBlockCount() > portalSize.getWidth() * portalSize.getHeight())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            return;
        }
        if (event.getTarget() instanceof EntityPlayer && event.getTarget() != event.getEntityLiving().func_94060_bK()) {
            if (PlayerUtils.isPlayerMountedOnCamera(event.getTarget())) {
                ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
            }
        } else if (event.getTarget() instanceof EntitySentry) {
            ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        event.getWorld().func_72954_a((IWorldEventListener)new SCWorldListener());
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Item held;
        if (event.getEntityPlayer() != null && ((held = event.getEntityPlayer().func_184614_ca().func_77973_b()) == SCContent.universalBlockReinforcerLvL1 || held == SCContent.universalBlockReinforcerLvL2 || held == SCContent.universalBlockReinforcerLvL3)) {
            for (Block rb : IReinforcedBlock.BLOCKS) {
                IReinforcedBlock reinforcedBlock = (IReinforcedBlock)rb;
                if (!reinforcedBlock.getVanillaBlocks().contains(event.getState().func_177230_c())) continue;
                event.setNewSpeed(10000.0f);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onEntityMount(EntityMountEvent event) {
        if (event.isDismounting() && event.getEntityBeingMounted() instanceof EntitySecurityCamera && event.getEntityMounting() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityMounting();
            TileEntity te = event.getWorldObj().func_175625_s(event.getEntityBeingMounted().func_180425_c());
            if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)player) && te instanceof TileEntitySecurityCamera && ((TileEntitySecurityCamera)te).hasModule(EnumModuleType.SMART)) {
                ((TileEntitySecurityCamera)te).lastPitch = player.field_70125_A;
                ((TileEntitySecurityCamera)te).lastYaw = player.field_70177_z;
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.getEntityPlayer()) && event.getItemStack().func_77973_b() != SCContent.cameraMonitor) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDestroyEvent(LivingDestroyBlockEvent event) {
        event.setCanceled(event.getEntity() instanceof EntityWither && event.getState().func_177230_c() instanceof IReinforcedBlock);
    }

    private static boolean handleCodebreaking(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getEntityPlayer().field_70170_p;
        TileEntity tileEntity = event.getEntityPlayer().field_70170_p.func_175625_s(event.getPos());
        if (tileEntity instanceof IPasswordProtected && ((IPasswordProtected)tileEntity).isCodebreakable()) {
            if (ConfigHandler.allowCodebreakerItem) {
                if (event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b() == SCContent.codebreaker) {
                    event.getEntityPlayer().func_184586_b(event.getHand()).func_77972_a(1, (EntityLivingBase)event.getEntityPlayer());
                }
                if (event.getEntityPlayer().func_184812_l_() || new Random().nextInt(3) == 1) {
                    return ((IPasswordProtected)tileEntity).onCodebreakerUsed(world.func_180495_p(event.getPos()), event.getEntityPlayer());
                }
                PlayerUtils.sendMessageToPlayer(event.getEntityPlayer(), (ITextComponent)Utils.localize("item.securitycraft:codebreaker.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:codebreaker.failed", new Object[0]), TextFormatting.RED);
                return true;
            }
            Block block = world.func_180495_p(event.getPos()).func_177230_c();
            PlayerUtils.sendMessageToPlayer(event.getEntityPlayer(), (ITextComponent)Utils.localize(block.func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), TextFormatting.RED);
        }
        return false;
    }

    private static String getRandomTip() {
        String[] tips = new String[]{"messages.securitycraft:tip.scHelp", "messages.securitycraft:tip.patreon", "messages.securitycraft:tip.discord", "messages.securitycraft:tip.scserver", "messages.securitycraft:tip.outdated"};
        return tips[new Random().nextInt(SCEventHandler.isOutdated() ? tips.length : tips.length - 1)];
    }

    private static boolean isOutdated() {
        return ForgeVersion.getResult((ModContainer)Loader.instance().activeModContainer()).status == ForgeVersion.Status.OUTDATED;
    }

    static {
        tipsWithLink.put("patreon", "https://www.patreon.com/Geforce");
        tipsWithLink.put("discord", "https://discord.gg/U8DvBAW");
        tipsWithLink.put("outdated", "https://www.curseforge.com/minecraft/mc-mods/security-craft/files/all");
    }
}

