/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.tileentity.TileEntityDisguisable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDisguisable
extends BlockOwnable
implements IOverlayDisplay {
    public BlockDisguisable(Material material) {
        super(material);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        IBlockState actualState = this.getDisguisedBlockState((IBlockAccess)world, pos);
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_177230_c().getSoundType(state, world, pos, entity);
        }
        return this.field_149762_H;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(world, pos);
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_185900_c(world, pos);
        }
        return super.func_185496_a(state, world, pos);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(world, pos);
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_185890_d(world, pos);
        }
        return super.func_180646_a(state, world, pos);
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState((IBlockAccess)world, pos);
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_185918_c(world, pos);
        }
        return super.func_180640_a(state, world, pos);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean isActualState) {
        IBlockState actualState = this.getDisguisedBlockState((IBlockAccess)world, pos);
        if (actualState != null && actualState.func_177230_c() != this) {
            actualState.func_185908_a(world, pos, entityBox, collidingBoxes, entity, true);
        } else {
            BlockDisguisable.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_180646_a(state, (IBlockAccess)world, pos));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityDisguisable && ((TileEntityDisguisable)te).hasModule(EnumModuleType.DISGUISE)) {
            ItemStack module = ((TileEntityDisguisable)te).getModule(EnumModuleType.DISGUISE);
            if (((ItemModule)module.func_77973_b()).getBlockAddons(module.func_77978_p()).isEmpty()) {
                return BlockFaceShape.SOLID;
            }
            return ((ItemModule)module.func_77973_b()).getBlockAddons(module.func_77978_p()).get(0).func_176223_P().func_193401_d(world, pos, face);
        }
        return BlockFaceShape.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        Block blockToDisguiseAs;
        ItemStack disguiseModule;
        ArrayList<Block> blocks;
        if (!(world.func_175625_s(pos) instanceof TileEntityDisguisable)) {
            return true;
        }
        TileEntityDisguisable te = (TileEntityDisguisable)world.func_175625_s(pos);
        if (!(!te.hasModule(EnumModuleType.DISGUISE) || (blocks = ((ItemModule)(disguiseModule = te.getModule(EnumModuleType.DISGUISE)).func_77973_b()).getBlockAddons(disguiseModule.func_77978_p())).size() == 0 || (blockToDisguiseAs = (Block)blocks.get(0)).func_176223_P().func_185914_p() && blockToDisguiseAs.func_176223_P().func_185917_h())) {
            return this.checkForSideTransparency(world, world.func_180495_p(pos.func_177972_a(side)), pos.func_177972_a(side), side);
        }
        return true;
    }

    public boolean checkForSideTransparency(IBlockAccess world, IBlockState neighborState, BlockPos neighborPos, EnumFacing side) {
        Block neighborBlock = neighborState.func_177230_c();
        if (neighborBlock.isAir(neighborState, world, neighborPos)) {
            return true;
        }
        return !(neighborBlock instanceof BlockBreakable) || !neighborBlock.getRegistryName().func_110624_b().equals("minecraft");
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState disguisedState = this.getDisguisedBlockState(world, pos);
        return disguisedState != null ? disguisedState : state;
    }

    public IBlockState getDisguisedBlockState(IBlockAccess world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof TileEntityDisguisable) {
            ItemStack module;
            TileEntityDisguisable te = (TileEntityDisguisable)world.func_175625_s(pos);
            ItemStack itemStack = module = te.hasModule(EnumModuleType.DISGUISE) ? te.getModule(EnumModuleType.DISGUISE) : ItemStack.field_190927_a;
            if (!module.func_190926_b() && !((ItemModule)module.func_77973_b()).getBlockAddons(module.func_77978_p()).isEmpty()) {
                ItemStack disguisedStack = ((ItemModule)module.func_77973_b()).getAddons(module.func_77978_p()).get(0);
                Block block = Block.func_149634_a((Item)disguisedStack.func_77973_b());
                boolean hasMeta = disguisedStack.func_77981_g();
                IBlockState disguisedModel = block.func_176203_a(hasMeta ? disguisedStack.func_77952_i() : this.func_176201_c(world.func_180495_p(pos)));
                if (block != this) {
                    return disguisedModel.func_185899_b(world, pos);
                }
            }
        }
        return null;
    }

    public ItemStack getDisguisedStack(IBlockAccess world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof TileEntityDisguisable) {
            ItemStack disguisedStack;
            ItemStack stack;
            TileEntityDisguisable te = (TileEntityDisguisable)world.func_175625_s(pos);
            ItemStack itemStack = stack = te.hasModule(EnumModuleType.DISGUISE) ? te.getModule(EnumModuleType.DISGUISE) : ItemStack.field_190927_a;
            if (!stack.func_190926_b() && !((ItemModule)stack.func_77973_b()).getBlockAddons(stack.func_77978_p()).isEmpty() && Block.func_149634_a((Item)(disguisedStack = ((ItemModule)stack.func_77973_b()).getAddons(stack.func_77978_p()).get(0)).func_77973_b()) != this) {
                return disguisedStack;
            }
        }
        return new ItemStack((Block)this);
    }

    @Override
    public ItemStack getDisplayStack(World world, IBlockState state, BlockPos pos) {
        return this.getDisguisedStack((IBlockAccess)world, pos);
    }

    @Override
    public boolean shouldShowSCInfo(World world, IBlockState state, BlockPos pos) {
        return this.getDisguisedStack((IBlockAccess)world, pos).func_77973_b() == Item.func_150898_a((Block)this);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getDisguisedStack((IBlockAccess)world, pos);
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityDisguisable();
    }
}

